 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kprdata
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kprdata.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Print Data in Formatted ASCII
|
|       Purpose: main program for kprdata
|
|         Input:
|		char *clui_info->i_file; {Input Data Object}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		int clui_info->attr_flag; {TRUE if -attr specified}
|
|		int clui_info->loc_flag; {TRUE if -loc specified}
|
|		int clui_info->time_flag; {TRUE if -time specified}
|
|		int clui_info->val_flag; {TRUE if -val specified}
|
|		int clui_info->mask_flag; {TRUE if -mask specified}
|
|		int clui_info->ind_flag; {TRUE if -ind specified}
|
|		char *clui_info->replace_string; {Replacement String for Masked Values}
|		int   clui_info->replace_flag; {TRUE if -replace specified}
|
|		char *clui_info->f_file; {Resulting Output File}
|		int   clui_info->f_flag; {TRUE if -f specified}
|
|		Optional M.E. group:
|		    Loose group:
|			int clui_info->mind_flag; {TRUE if -mind specified}
|
|			int clui_info->map_flag; {TRUE if -map specified}
|
|		    int clui_info->mval_flag; {TRUE if -mval specified}
|
|        Output:
|       Returns:
|
|    Written By: Donna Koechner
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
	kobject	 in_obj;
	kfile 	 *ascii_out;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(kprdata_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "kprdata",
		kprdata_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kprdata_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	if ( (in_obj = kpds_open_input_object(clui_info->i_file)) == NULL) {
            kerror("kprdata", "main", "Cannot Open input Object.");
            kexit(KEXIT_FAILURE);
	}

	if (clui_info->f_flag)
	   ascii_out = kfopen(clui_info->f_file, "w");
	else
	   ascii_out = (kfile *) kstdout;
	
	if (!clui_info->loc_flag && !clui_info->time_flag && 
	    !clui_info->map_flag && !clui_info->val_flag &&
	    !clui_info->attr_flag && !clui_info->time_flag)
	clui_info->attr_flag = TRUE;
/* -main_before_lib_call_end */

/* -main_library_call */
	if (! lkprdata(in_obj, 		    /* 1  input object */
		 ascii_out, 		    /* 2  output ascii file */
		 clui_info->attr_flag,     /* 3  print attributes if TRUE */
		 clui_info->ind_flag,     /* 7  print indices if TRUE */
		 clui_info->loc_flag,	    /* 8  print location if TRUE */
		 clui_info->time_flag,    /* 9  print time if TRUE */
		 clui_info->val_flag,     /* 10 print value if TRUE */
		 clui_info->mask_flag,    /* 11 print mask if TRUE */
		 clui_info->mind_flag,    /* 12 print map indices if TRUE */
		 clui_info->map_flag,	    /* 13 print map if TRUE */
		 clui_info->mval_flag, 	/* 14 map values data if TRUE */
		 clui_info->replace_flag,     /* 15 replace masked values */
		 clui_info->replace_string)) {  /* 16 replacement string */
	   kfclose(ascii_out);
	   kpds_close_object(in_obj);
	   kexit(KEXIT_FAILURE);
	}
/* -main_library_call_end */

/* -main_after_lib_call */
	kfclose(ascii_out);
	kpds_close_object(in_obj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kprdata_usage_additions
| 
|       Purpose: Prints usage additions in kprdata_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kprdata
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kprdata_usage_additions(void)
{
	kfprintf(kstderr, "\tPrint Data in Formatted ASCII\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kprdata_free_args
| 
|       Purpose: Frees CLUI struct allocated in kprdata_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kprdata
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kprdata_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->replace_string);
	kfree(clui_info->f_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
