 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "knormal.h"
/*-----------------------------------------------------------
| 
|  Routine Name: knormal_get_args
| 
|       Purpose: Gets command line args for knormal
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname knormal
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void knormal_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for knormal is out of sync with arguments specified in knormal's *.pane file; please rerun ghostwriter on knormal.";


	/*
	 * allocate the knormal structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "knormal_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "lval",
			  &(clui_info->lval_double),
			  &(clui_info->lval_flag))))
	{
	    kerror(NULL, "knormal_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "uval",
			  &(clui_info->uval_double),
			  &(clui_info->uval_flag))))
	{
	    kerror(NULL, "knormal_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_value(pane, "type", KVF_LIST_LABEL,
			  &(clui_info->type_label),
			  &(clui_info->type_flag)) &&
	      kclui_get_value(pane, "type", KVF_LIST_VAL,
			  &(clui_info->type_list),
			  &(clui_info->type_flag))))
	{
	    kerror(NULL, "knormal_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "knormal_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "whole",
			  &(clui_info->whole_flag))))
	{
	    kerror(NULL, "knormal_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "w",
			  &(clui_info->w_flag))))
	{
	    kerror(NULL, "knormal_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "h",
			  &(clui_info->h_flag))))
	{
	    kerror(NULL, "knormal_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "d",
			  &(clui_info->d_flag))))
	{
	    kerror(NULL, "knormal_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "t",
			  &(clui_info->t_flag))))
	{
	    kerror(NULL, "knormal_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "e",
			  &(clui_info->e_flag))))
	{
	    kerror(NULL, "knormal_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "dmin",
			  &(clui_info->dmin_double),
			  &(clui_info->dmin_flag))))
	{
	    kerror(NULL, "knormal_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "dmax",
			  &(clui_info->dmax_double),
			  &(clui_info->dmax_flag))))
	{
	    kerror(NULL, "knormal_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



