 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kmsquish.h"
/*-----------------------------------------------------------
| 
|  Routine Name: kmsquish_get_args
| 
|       Purpose: Gets command line args for kmsquish
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kmsquish
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kmsquish_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for kmsquish is out of sync with arguments specified in kmsquish's *.pane file; please rerun ghostwriter on kmsquish.";

	char  *value_string;


	/*
	 * allocate the kmsquish structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "kmsquish_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_logical(pane, "map",
			  &(clui_info->map_logic),
			  &(clui_info->map_flag))))
	{
	    kerror(NULL, "kmsquish_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_value(pane, "t", KVF_TOGGLE_VAL,
			  &value_string,
			  &(clui_info->t_flag))))
	{
	    kerror(NULL, "kmsquish_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}
	else clui_info->t_toggle = atoi(value_string);

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "kmsquish_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



