 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for klocxform
   >>>> 
   >>>>    Written By: Steve Kubica
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 15, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _klocxform_h_
#define _klocxform_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <datamanip.h>

/* -include_includes */
#include <kdatamanip/kdatamanip.h>
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$DATAMANIP/objects/kroutine/klocxform/uis/klocxform.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  the input object to be processed (required infile)
 */
char	*i_file;	/* the input object to be processed FILENAME */
int	 i_flag;	/* the input object to be processed FLAG */

/*
 *  the output object (required outfile)
 */
char	*o_file;	/* the output object FILENAME */
int	 o_flag;	/* the output object FLAG */

/*
 *  rotate around x axis (optional float)
 */
float	 xrot_float;	/* rotate around x axis FLOAT */
int	 xrot_flag;   	/* rotate around x axis FLAG */

/*
 *  rotate around y axis (optional float)
 */
float	 yrot_float;	/* rotate around y axis FLOAT */
int	 yrot_flag;   	/* rotate around y axis FLAG */

/*
 *  rotate around z axis (optional float)
 */
float	 zrot_float;	/* rotate around z axis FLOAT */
int	 zrot_flag;   	/* rotate around z axis FLAG */

/*
 *  flip x coordinates (optional flag)
 */
int	 fx_flag;  	/* flip x coordinates FLAG */

/*
 *  translate in x direction (optional float)
 */
float	 xtrans_float;	/* translate in x direction FLOAT */
int	 xtrans_flag;   	/* translate in x direction FLAG */

/*
 *  flip y coordinates (optional flag)
 */
int	 fy_flag;  	/* flip y coordinates FLAG */

/*
 *  translate in y direction (optional float)
 */
float	 ytrans_float;	/* translate in y direction FLOAT */
int	 ytrans_flag;   	/* translate in y direction FLAG */

/*
 *  flip z coordinates (optional flag)
 */
int	 fz_flag;  	/* flip z coordinates FLAG */

/*
 *  translate in z direction (optional float)
 */
float	 ztrans_float;	/* translate in z direction FLOAT */
int	 ztrans_flag;   	/* translate in z direction FLAG */

/*----- optional ME group ----*/
/*
 *  orthogonal scale factor (optional float)
 */
float	 scale_float;	/* orthogonal scale factor FLOAT */
int	 scale_flag;   	/* orthogonal scale factor FLAG */

	/*---- nested optional   group ----*/
/*
 *  scale x coordinates (optional float)
 */
float	 xscale_float;	/* scale x coordinates FLOAT */
int	 xscale_flag;   	/* scale x coordinates FLAG */

/*
 *  scale y coordinates (optional float)
 */
float	 yscale_float;	/* scale y coordinates FLOAT */
int	 yscale_flag;   	/* scale y coordinates FLAG */

/*
 *  scale z coordinates (optional float)
 */
float	 zscale_float;	/* scale z coordinates FLOAT */
int	 zscale_flag;   	/* scale z coordinates FLAG */

	/*-- nested optional   group end --*/

/*-- optional ME group end ---*/

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void klocxform_get_args PROTO((kform *));
void klocxform_usage_additions PROTO((void));
void klocxform_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
