 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for kinsertseg
   >>>> 
   >>>>    Written By: John M. Salas & Donna Koechner
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _kinsertseg_h_
#define _kinsertseg_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <datamanip.h>

/* -include_includes */
#include "ksegops/ksegops.h"
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$DATAMANIP/objects/kroutine/kinsertseg/uis/kinsertseg.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  Source Input File (required infile)
 */
char	*i1_file;	/* Source Input File FILENAME */
int	 i1_flag;	/* Source Input File FLAG */

/*
 *  Destination Input File (required infile)
 */
char	*i2_file;	/* Destination Input File FILENAME */
int	 i2_flag;	/* Destination Input File FLAG */

/*
 *  output file (required outfile)
 */
char	*o_file;	/* output file FILENAME */
int	 o_flag;	/* output file FLAG */

/*----- required   group ----*/
/*
 *  If -val flag is selected, operate on Value segment (optional flag)
 */
int	 val_flag;  	/* If -val flag is selected, operate on Value segment FLAG */

/*
 *  If -map flag is selected, operate on map segment (optional flag)
 */
int	 map_flag;  	/* If -map flag is selected, operate on map segment FLAG */

/*
 *  If -mask flag is selected, operate on Mask segment (optional flag)
 */
int	 mask_flag;  	/* If -mask flag is selected, operate on Mask segment FLAG */

/*
 *  If -loc flag is selected, operate on Location segment (optional flag)
 */
int	 loc_flag;  	/* If -loc flag is selected, operate on Location segment FLAG */

/*
 *  If -time flag is selected, operate on Time segment (optional flag)
 */
int	 time_flag;  	/* If -time flag is selected, operate on Time segment FLAG */

/*
 *  Perform operation on user specified segment (optional string)
 */
char	*segment_string;	/* Perform operation on user specified segment STRING */
int	 segment_flag;   	/* Perform operation on user specified segment FLAG */

/*-- required   group end ---*/

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void kinsertseg_get_args PROTO((kform *));
void kinsertseg_usage_additions PROTO((void));
void kinsertseg_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
