 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kimpulse
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kimpulse.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Generate Object Containing Impulse Value Data
|
|       Purpose: main program for kimpulse
|
|         Input:
|		char *clui_info->o_file; {Output file containing impulse value data}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		int clui_info->wsize_int; {Width of impulse value data}
|		int clui_info->wsize_flag; {TRUE if -wsize specified}
|
|		int clui_info->wnum_int; {Number of impulses generated along the width dimension}
|		int clui_info->wnum_flag; {TRUE if -wnum specified}
|
|		int clui_info->hsize_int; {Height of impulse value data}
|		int clui_info->hsize_flag; {TRUE if -hsize specified}
|
|		int clui_info->hnum_int; {Number of impulses generated along the height dimension}
|		int clui_info->hnum_flag; {TRUE if -hnum specified}
|
|		int clui_info->dsize_int; {Depth of impulse value data}
|		int clui_info->dsize_flag; {TRUE if -dsize specified}
|
|		int clui_info->dnum_int; {Number of impulses generated along the depth dimension}
|		int clui_info->dnum_flag; {TRUE if -dnum specified}
|
|		int clui_info->tsize_int; {Time of impulse value data}
|		int clui_info->tsize_flag; {TRUE if -tsize specified}
|
|		int clui_info->tnum_int; {Number of impulses generated along the time dimension}
|		int clui_info->tnum_flag; {TRUE if -tnum specified}
|
|		int clui_info->esize_int; {Element dimension of impulse value data}
|		int clui_info->esize_flag; {TRUE if -esize specified}
|
|		int clui_info->enum_int; {Number of impulses generated along the element dimension}
|		int clui_info->enum_flag; {TRUE if -enum specified}
|
|		int clui_info->wsp_int; {Spacing between two impulses along the width dimension}
|		int clui_info->wsp_flag; {TRUE if -wsp specified}
|
|		int clui_info->woff_int; {Offset of first impulse along width dimension}
|		int clui_info->woff_flag; {TRUE if -woff specified}
|
|		int clui_info->hsp_int; {Spacing between two impulses along the height dimension}
|		int clui_info->hsp_flag; {TRUE if -hsp specified}
|
|		int clui_info->hoff_int; {Offset of first impulse along height dimension}
|		int clui_info->hoff_flag; {TRUE if -hoff specified}
|
|		int clui_info->dsp_int; {Spacing between two impulses along the depth dimension}
|		int clui_info->dsp_flag; {TRUE if -dsp specified}
|
|		int clui_info->doff_int; {Offset of first impulse along depth dimension}
|		int clui_info->doff_flag; {TRUE if -doff specified}
|
|		int clui_info->tsp_int; {Spacing between two impulses along the time dimension}
|		int clui_info->tsp_flag; {TRUE if -tsp specified}
|
|		int clui_info->toff_int; {Offset of first impulse along time dimension}
|		int clui_info->toff_flag; {TRUE if -toff specified}
|
|		int clui_info->esp_int; {Spacing between two impulses along the element dimension}
|		int clui_info->esp_flag; {TRUE if -esp specified}
|
|		int clui_info->eoff_int; {Offset of the first impulse along the element dimension}
|		int clui_info->eoff_flag; {TRUE if -eoff specified}
|
|		double clui_info->fgreal_double; {Real value assigned to the generated impulse}
|		int    clui_info->fgreal_flag; {TRUE if -fgreal specified}
|
|		double clui_info->bgreal_double; {Real value assigned to background value data}
|		int    clui_info->bgreal_flag; {TRUE if -bgreal specified}
|
|		double clui_info->fgimag_double; {Imaginary value of generated impulse }
|		int    clui_info->fgimag_flag; {TRUE if -fgimag specified}
|
|		double clui_info->bgimag_double; {Imaginary value assigned to background}
|		int    clui_info->bgimag_flag; {TRUE if -bgimag specified}
|
|		int   clui_info->type_list; {Data type of impulse value data}
|		char *clui_info->type_label;
|		int   clui_info->type_flag; {TRUE if -type specified}
|
|        Output:
|       Returns:
|
|    Written By: Ashish Malhotra
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
        kobject out_obj;
        int     data_type;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(kimpulse_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "kimpulse",
		kimpulse_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kimpulse_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        if ((out_obj = kpds_open_output_object(clui_info->o_file))
		== KOBJECT_INVALID) 
        {
           kerror("kimpulse", "main", "Failed to open output object");
           kexit(KEXIT_FAILURE);
        }
        /*kpds_set_attribute(out_obj, KPDS_FORMAT,KXVIMAGE);*/ 
        data_type = kdatatype_to_define(clui_info->type_label);
/* -main_before_lib_call_end */

/* -main_library_call */
	if (!lkimpulse(clui_info->wsize_int, clui_info->hsize_int,
                clui_info->dsize_int, clui_info->tsize_int,
                clui_info->esize_int,clui_info->wsp_int, 
                clui_info->hsp_int,clui_info->dsp_int, 
                clui_info->tsp_int,clui_info->esp_int, 
                clui_info->wnum_int, clui_info->hnum_int,
                clui_info->dnum_int, clui_info->tnum_int,
                clui_info->enum_int,clui_info->woff_int, 
                clui_info->hoff_int, clui_info->doff_int, 
                clui_info->toff_int, clui_info->eoff_int,
                clui_info->fgreal_double,clui_info->fgimag_double,
                clui_info->bgreal_double,clui_info->bgimag_double,
                data_type, out_obj))
        {
           kexit(KEXIT_FAILURE);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
	/* add history to the output object */
	if (!kpds_set_attribute(out_obj, KPDS_HISTORY, kpds_history_string()))
	{
	   kerror("kimpulse", "main", 
		  "Unable to set history on the destination object");
	   kexit(KEXIT_FAILURE);
	}

        kpds_close_object(out_obj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kimpulse_usage_additions
| 
|       Purpose: Prints usage additions in kimpulse_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kimpulse
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kimpulse_usage_additions(void)
{
	kfprintf(kstderr, "\tGenerate Object Containing Impulse Value Data\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kimpulse_free_args
| 
|       Purpose: Frees CLUI struct allocated in kimpulse_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kimpulse
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kimpulse_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->o_file);
	kfree(clui_info->type_label);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
