 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kimportraw.h"
/*-----------------------------------------------------------
| 
|  Routine Name: kimportraw_get_args
| 
|       Purpose: Gets command line args for kimportraw
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kimportraw
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kimportraw_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for kimportraw is out of sync with arguments specified in kimportraw's *.pane file; please rerun ghostwriter on kimportraw.";


	/*
	 * allocate the kimportraw structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i1",
			  &(clui_info->i1_file),
			  &(clui_info->i1_flag))))
	{
	    kerror(NULL, "kimportraw_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "i2",
			  &(clui_info->i2_file),
			  &(clui_info->i2_flag))))
	{
	    kerror(NULL, "kimportraw_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_value(pane, "arch", KVF_LIST_LABEL,
			  &(clui_info->arch_label),
			  &(clui_info->arch_flag)) &&
	      kclui_get_value(pane, "arch", KVF_LIST_VAL,
			  &(clui_info->arch_list),
			  &(clui_info->arch_flag))))
	{
	    kerror(NULL, "kimportraw_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_value(pane, "type", KVF_LIST_LABEL,
			  &(clui_info->type_label),
			  &(clui_info->type_flag)) &&
	      kclui_get_value(pane, "type", KVF_LIST_VAL,
			  &(clui_info->type_list),
			  &(clui_info->type_flag))))
	{
	    kerror(NULL, "kimportraw_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "wsize",
			  &(clui_info->wsize_int),
			  &(clui_info->wsize_flag))))
	{
	    kerror(NULL, "kimportraw_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "hsize",
			  &(clui_info->hsize_int),
			  &(clui_info->hsize_flag))))
	{
	    kerror(NULL, "kimportraw_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "dsize",
			  &(clui_info->dsize_int),
			  &(clui_info->dsize_flag))))
	{
	    kerror(NULL, "kimportraw_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "tsize",
			  &(clui_info->tsize_int),
			  &(clui_info->tsize_flag))))
	{
	    kerror(NULL, "kimportraw_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "esize",
			  &(clui_info->esize_int),
			  &(clui_info->esize_flag))))
	{
	    kerror(NULL, "kimportraw_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_value(pane, "segment", KVF_LIST_LABEL,
			  &(clui_info->segment_label),
			  &(clui_info->segment_flag)) &&
	      kclui_get_value(pane, "segment", KVF_LIST_VAL,
			  &(clui_info->segment_list),
			  &(clui_info->segment_flag))))
	{
	    kerror(NULL, "kimportraw_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "kimportraw_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



