 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kgnoise
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kgnoise.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Generate Noise Data
|
|       Purpose: main program for kgnoise
|
|         Input:
|		char *clui_info->o_file; {Output file containing noise data}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		Required M.E. group:
|		    M.I. group:
|			int clui_info->gauss_flag; {TRUE if -gauss specified}
|
|			double clui_info->gmean_double; {Mean for Gaussian noise}
|			int    clui_info->gmean_flag; {TRUE if -gmean specified}
|
|			double clui_info->gvar_double; {Variance for Gaussian noise}
|			int    clui_info->gvar_flag; {TRUE if -gvar specified}
|
|		    M.I. group:
|			int clui_info->ray_flag; {TRUE if -ray specified}
|
|			double clui_info->rvar_double; {Variance for Rayleigh noise}
|			int    clui_info->rvar_flag; {TRUE if -rvar specified}
|
|		    M.I. group:
|			int clui_info->unif_flag; {TRUE if -unif specified}
|
|			double clui_info->umax_double; {Maximum value for uniform distribution}
|			int    clui_info->umax_flag; {TRUE if -umax specified}
|
|			double clui_info->umin_double; {Minimum value for uniform noise}
|			int    clui_info->umin_flag; {TRUE if -umin specified}
|
|		    M.I. group:
|			int clui_info->poiss_flag; {TRUE if -poiss specified}
|
|			double clui_info->ptime_double; {Amount of time}
|			int    clui_info->ptime_flag; {TRUE if -ptime specified}
|
|			double clui_info->pvar_double; {Variance for Poisson distribution}
|			int    clui_info->pvar_flag; {TRUE if -pvar specified}
|
|		    M.I. group:
|			int clui_info->exp_flag; {TRUE if -exp specified}
|
|			double clui_info->evar_double; {Variance for exponential distribution}
|			int    clui_info->evar_flag; {TRUE if -evar specified}
|
|		int clui_info->wsize_int; {Width size of noise value data}
|		int clui_info->wsize_flag; {TRUE if -wsize specified}
|
|		int clui_info->hsize_int; {Height size of noise value data}
|		int clui_info->hsize_flag; {TRUE if -hsize specified}
|
|		int clui_info->dsize_int; {Depth size of noise value data}
|		int clui_info->dsize_flag; {TRUE if -dsize specified}
|
|		int clui_info->tsize_int; {Time size of noise value data}
|		int clui_info->tsize_flag; {TRUE if -tsize specified}
|
|		int clui_info->esize_int; {Element dimension size of noise data}
|		int clui_info->esize_flag; {TRUE if -esize specified}
|
|		int   clui_info->type_list; {Data type of noise value data}
|		char *clui_info->type_label;
|		int   clui_info->type_flag; {TRUE if -type specified}
|
|        Output:
|       Returns:
|
|    Written By: Ashish Malhotra, Scott Wilson
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
        kobject out_obj=NULL;
        int     datatype;
        char    *noise_type=NULL;
        double  noise_spec1=0.0, noise_spec2=1.0;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(kgnoise_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "kgnoise",
		kgnoise_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kgnoise_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        if ((out_obj = kpds_open_output_object(clui_info->o_file))
		== KOBJECT_INVALID)
        {
           kerror("kgnoise", "main", "Failed to open output object");
           kexit(KEXIT_FAILURE);
        }

        datatype = kdatatype_to_define(clui_info->type_label);

        if (clui_info->gauss_flag)
        {
           noise_type = "gauss";
           noise_spec1 = clui_info->gmean_double;
           noise_spec2 = clui_info->gvar_double;
        }
        else if (clui_info->ray_flag)
        {
           noise_type = "ray";
           noise_spec1 = clui_info->rvar_double;
        }
        else if (clui_info->unif_flag)
        {
           noise_type = "unif";
           noise_spec1 = clui_info->umin_double;
           noise_spec2 = clui_info->umax_double;

           if (noise_spec2 <= noise_spec1)
           {

              kerror("kgnoise","main",
              "Max cannot be less than/equal to min for uniform distribution");
              kexit(KEXIT_FAILURE);
           }
        }
        else if (clui_info->poiss_flag)
        {
           noise_type = "poiss";
           noise_spec1 = clui_info->pvar_double;
           noise_spec2 = clui_info->ptime_double;
        }
        else if (clui_info->exp_flag)
        {
           noise_type = "exp";
           noise_spec1 = clui_info->evar_double;
        }
	else
	{
           kerror("kgnoise","main", "noise type not specified");
           kexit(KEXIT_FAILURE);
	}
/* -main_before_lib_call_end */

/* -main_library_call */
	if (!(lkgnoise(clui_info->wsize_int, clui_info->hsize_int,
                clui_info->dsize_int, clui_info->tsize_int,
                clui_info->esize_int,noise_type, datatype, 
                noise_spec1, noise_spec2, out_obj)))
        {
           kexit(KEXIT_FAILURE);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
	/* add history to the output object */
	if (!kpds_set_attribute(out_obj, KPDS_HISTORY, kpds_history_string()))
	{
	   kerror("kgnoise", "main", 
		  "Unable to set history on the destination object");
	   kexit(KEXIT_FAILURE);
	}

        kpds_close_object(out_obj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kgnoise_usage_additions
| 
|       Purpose: Prints usage additions in kgnoise_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kgnoise
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kgnoise_usage_additions(void)
{
	kfprintf(kstderr, "\tGenerate Noise Data\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kgnoise_free_args
| 
|       Purpose: Frees CLUI struct allocated in kgnoise_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kgnoise
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kgnoise_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->o_file);
	kfree(clui_info->type_label);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
