 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kformats.h"
/*-----------------------------------------------------------
| 
|  Routine Name: kformats_get_args
| 
|       Purpose: Gets command line args for kformats
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kformats
|          Date: Apr 15, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kformats_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for kformats is out of sync with arguments specified in kformats's *.pane file; please rerun ghostwriter on kformats.";


	/*
	 * allocate the kformats structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "kformats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "kformats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "ascii",
			  &(clui_info->ascii_flag))))
	{
	    kerror(NULL, "kformats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "viff",
			  &(clui_info->viff_flag))))
	{
	    kerror(NULL, "kformats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "avs",
			  &(clui_info->avs_flag))))
	{
	    kerror(NULL, "kformats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "xbm",
			  &(clui_info->xbm_flag))))
	{
	    kerror(NULL, "kformats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "arf",
			  &(clui_info->arf_flag))))
	{
	    kerror(NULL, "kformats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "xvimage",
			  &(clui_info->xvimage_flag))))
	{
	    kerror(NULL, "kformats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "pnm",
			  &(clui_info->pnm_flag))))
	{
	    kerror(NULL, "kformats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "xwd",
			  &(clui_info->xwd_flag))))
	{
	    kerror(NULL, "kformats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "raw",
			  &(clui_info->raw_flag))))
	{
	    kerror(NULL, "kformats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "xpm",
			  &(clui_info->xpm_flag))))
	{
	    kerror(NULL, "kformats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "rast",
			  &(clui_info->rast_flag))))
	{
	    kerror(NULL, "kformats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "format",
			  &(clui_info->format_string),
			  &(clui_info->format_flag))))
	{
	    kerror(NULL, "kformats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



