 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kflip.h"
/*-----------------------------------------------------------
| 
|  Routine Name: kflip_get_args
| 
|       Purpose: Gets command line args for kflip
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kflip
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kflip_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for kflip is out of sync with arguments specified in kflip's *.pane file; please rerun ghostwriter on kflip.";


	/*
	 * allocate the kflip structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "kflip_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "kflip_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "w",
			  &(clui_info->w_flag))))
	{
	    kerror(NULL, "kflip_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "h",
			  &(clui_info->h_flag))))
	{
	    kerror(NULL, "kflip_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "d",
			  &(clui_info->d_flag))))
	{
	    kerror(NULL, "kflip_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "t",
			  &(clui_info->t_flag))))
	{
	    kerror(NULL, "kflip_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "e",
			  &(clui_info->e_flag))))
	{
	    kerror(NULL, "kflip_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



