 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kextract
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kextract.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Extract Rectangular Region from Object
|
|       Purpose: main program for kextract
|
|         Input:
|		char *clui_info->i_file; {Input object}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {Resulting output region}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		int clui_info->wsize_int; {Specifies the region width}
|		int clui_info->wsize_flag; {TRUE if -wsize specified}
|
|		int clui_info->hsize_int; {Specifies the region height}
|		int clui_info->hsize_flag; {TRUE if -hsize specified}
|
|		int clui_info->dsize_int; {Specifies the region depth}
|		int clui_info->dsize_flag; {TRUE if -dsize specified}
|
|		int clui_info->tsize_int; {Specifies the region size on time dimension}
|		int clui_info->tsize_flag; {TRUE if -tsize specified}
|
|		int clui_info->esize_int; {Specifies the region size on elements dimension}
|		int clui_info->esize_flag; {TRUE if -esize specified}
|
|		int clui_info->woff_int; {Specifies origin of region on width dimension}
|		int clui_info->woff_flag; {TRUE if -woff specified}
|
|		int clui_info->hoff_int; {Specifies origin of region on height dimension}
|		int clui_info->hoff_flag; {TRUE if -hoff specified}
|
|		int clui_info->doff_int; {Specifies origin of region on depth dimension}
|		int clui_info->doff_flag; {TRUE if -doff specified}
|
|		int clui_info->toff_int; {Specifies origin of region on time dimension}
|		int clui_info->toff_flag; {TRUE if -toff specified}
|
|		int clui_info->eoff_int; {Specifies origin of region on elements dimension}
|		int clui_info->eoff_flag; {TRUE if -eoff specified}
|
|		int clui_info->subpos_logic; {Record region origin (Subobject Position) in output}
|		int clui_info->subpos_flag; {TRUE if -subpos specified}
|
|        Output:
|       Returns:
|
|    Written By: Donna Koechner and Mark Young
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
	kobject input, output;
	int w, h, d, t, e, width, height, depth, tsize, elements;
	int tmp_dim = 1;
        /*
         *  The variables defined below are for use with kerror.
         */
	char *lib = NULL;
	char *rtn = "kextract";
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(kextract_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "kextract",
		kextract_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kextract_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	/* 
	 *  Open the input and output data objects using the 
	 *  kpds_open_input_object and kpds_open_output_object calls.  
	 *  These calls will open the input and output data objects 
	 *  with the flags set correctly.  If an open fails, report the 
	 *  error using kerror, and exit the program using the 
	 *  kexit(KEXIT_FAILURE) call.
	 */
	if ((input = kpds_open_input_object(clui_info->i_file))
		== KOBJECT_INVALID) {
	   kerror(lib, rtn, "failed to open the input object %s.",
		  clui_info->i_file);
	   kexit(KEXIT_FAILURE);
	}

	if ((output = kpds_open_output_object(clui_info->o_file))
		== KOBJECT_INVALID) {
	   kerror(lib, rtn, "failed to open the output object %s.",
		  clui_info->o_file);
	   kexit(KEXIT_FAILURE);
	}

	/* 
	 *  The lkextract library should have no side effects on its output 
	 *  object.  It will only manipulate the the value, mask, location, 
	 *  and time data if they exist.  The only attributes of the output 
	 *  data object that are altered by lkextract are those that are 
	 *  related to the extract operation, such as size.
	 * 
	 *  Since the input object may contain additional data segments and 
	 *  attributes, they need to be copied to the output object so that
	 *  the user is not surprised by unwanted side effects, such as not 
	 *  transferring input map data to the output.  Copy the input object 
	 *  attributes to the output object by calling kpds_copy_object_attr.  
	 *  After the library returns, use the kpds_copy_remaining_data call 
	 *  to copy any unaltered data to the output object.
	 */
	 
	if (!kpds_copy_object_attr(input, output)) {
	   kerror(lib, rtn, 
		"Failed to copy attributes from input to output.");
	   kexit(KEXIT_FAILURE);
	}

	/* 
	 *  Any of the kextract dimension sizes not selected on the cantata 
	 *  GUI, or specified on the command line, should be set to the 
	 *  original size of the data (minus the offset given for that
	 *  dimension).  
	 *
	 *  To set the extract size correctly before calling the library
	 *  routine, first initialize the size to the original size of the 
	 *  input object, using the kpds_get_attribute call.  Then calculate 
	 *  the extract size using the parameters selected and passed
	 *  in from the user interface.
	 *  
	 *  kextract can operate on the value, mask, location and/or time 
	 *  data segments in the input object.  Since the most probable segment 
	 *  that the object will have is the value segment, query it first 
	 *  for its size. If the kpds_get_attribute call fails, it is because 
	 *  the value segment does not exist.  In that case the mask segment 
	 *  is queried, and so on.  
	 */
	width = height = depth = tsize = elements = 1;
	if (!kpds_get_attribute(input, KPDS_VALUE_SIZE, 
		&width, &height, &depth, &tsize, &elements)) 
	{
           if (!kpds_get_attribute(input, 
                KPDS_MASK_SIZE, &width, &height, &depth, &tsize, &elements)) 
	   {
              if (!kpds_get_attribute(input, 
                   KPDS_LOCATION_SIZE, &width, &height, &depth, &tmp_dim)) 
	      {
	         kpds_get_attribute(input, KPDS_TIME_SIZE, &tsize);
	      }
	   }
	}

	/*
	 *  To use kinfo for debugging purposes, pass in VERBOSE as the 
	 *  mode.  To print these messages when running kextract, set the 
	 *  KHOROS_NOTIFY environment variable to KVERBOSE.
	 */
	kinfo(KVERBOSE, 
	   "width = %d, height = %d, depth = %d, tsize = %d, elements = %d", 
	    width, height, depth, tsize, elements);

	/*
	 *  Offset parameters (which define extract starting point) that 
	 *  are not selected on the cantata GUI, or specified on the 
	 *  command line, should default to 0, so first set the starting 
	 *  point (w,h,d,t,e) to (0,0,0,0,0). 
	 *
	 *  Next Assign the offset values that were passed in if the 
	 *  parameter's flags have been set.  These variables are in the 
	 *  clui_info structure, which is created by the code generators 
	 *  using the user interface specification file (kextract.pane).  
	 *  This structure is located in the kextract.h file.  
	 */

	w = h = d = t = e = 0;
	if (clui_info->woff_flag)	w = clui_info->woff_int;
	if (clui_info->hoff_flag)	h = clui_info->hoff_int;
	if (clui_info->doff_flag)	d = clui_info->doff_int;
	if (clui_info->toff_flag)	t = clui_info->toff_int;
	if (clui_info->eoff_flag)	e = clui_info->eoff_int;


	/*
	 *  If sizes are specified on the CLUI, or selected on the GUI, 
	 *  the flags for these parameters will be true, so check the flags 
	 *  and set the corresponding dimension sizes.  For any size that is 
	 *  not specified, subtract the offset for that dimension from the 
	 *  original object size to get the correct output size.
	 *
	 *  Doing this will insure the following behavior.  If you have a 
	 *  data file with dimensions (width=100, height=100, depth=10, 
	 *  time=1, elements = 1), and run kextract the following input 
	 *  parameters _specified_ 
	 *     EXTRACT SIZE: width = 50, height_int = 50 
	 *     OFFSETS:      w_int = 2, h_int = 2, d_int = 2
	 *  the output object size will be (width=50, height=50, depth=8,
	 *  time=1, elements = 1).
	 */
	if (clui_info->wsize_flag)     width = clui_info->wsize_int;
	else  width -= w;
	if (clui_info->hsize_flag)     height = clui_info->hsize_int;
	else  height -= h;
	if (clui_info->dsize_flag)     depth = clui_info->dsize_int;
	else  depth -= d;
	if (clui_info->tsize_flag)     tsize = clui_info->tsize_int;
	else  tsize -= t;
	if (clui_info->esize_flag)     elements = clui_info->esize_int;
	else  elements -= e;
	kinfo(KVERBOSE, 
	   "width = %d, height = %d, depth = %d, tsize = %d, elements = %d", 
	    width, height, depth, tsize, elements);
/* -main_before_lib_call_end */

/* -main_library_call */
	/* 
	 *  Once the preliminary work has been done, pass the input and 
	 *  output data objects, and the parameters to the library. If the 
	 *  library fails, close the objects and exit the routine.  Do not
	 *  print an error message since the library should print it.
	 */
	if (!lkextract(input, w, h, d, t, e, 
		width, height, depth, tsize, elements, 
		clui_info->subpos_logic, output))
        {
           kexit(KEXIT_FAILURE);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
	/* add history to the output object */
	if (!kpds_set_attribute(output, KPDS_HISTORY, kpds_history_string()))
	{
	   kerror(lib, rtn,
		  "Unable to set history on the destination object");
	   kexit(KEXIT_FAILURE);
	}

	/* copy any remaining data to the output object */
	if (!kpds_copy_remaining_data(input, output)) {
	   kerror(lib, rtn, 
		"Failed to copy remaining data from input to output.");
	   kexit(KEXIT_FAILURE);
	}

        kpds_close_object(input);
        kpds_close_object(output);


	/* 
	 *  If the library call was successful, exit using 
	 *  kexit(KEXIT_SUCCESS).  (This final kexit call is automatically 
	 *  generated for you by the code generators.)
	 */
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kextract_usage_additions
| 
|       Purpose: Prints usage additions in kextract_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kextract
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kextract_usage_additions(void)
{
	kfprintf(kstderr, "\tExtract Rectangular Region from Object\n");

/* -usage_additions */
	kfprintf(kstderr, "\tOutput Object Size: If the size parameter is not selected for a dimension, all data on that dimension will be extracted, starting at the dimension's specified origin\n");
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kextract_free_args
| 
|       Purpose: Frees CLUI struct allocated in kextract_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kextract
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kextract_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
