 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kcptoval.h"
/*-----------------------------------------------------------
| 
|  Routine Name: kcptoval_get_args
| 
|       Purpose: Gets command line args for kcptoval
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kcptoval
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kcptoval_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for kcptoval is out of sync with arguments specified in kcptoval's *.pane file; please rerun ghostwriter on kcptoval.";


	/*
	 * allocate the kcptoval structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "kcptoval_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "kcptoval_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "val",
			  &(clui_info->val_flag))))
	{
	    kerror(NULL, "kcptoval_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "map",
			  &(clui_info->map_flag))))
	{
	    kerror(NULL, "kcptoval_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "mask",
			  &(clui_info->mask_flag))))
	{
	    kerror(NULL, "kcptoval_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "loc",
			  &(clui_info->loc_flag))))
	{
	    kerror(NULL, "kcptoval_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "time",
			  &(clui_info->time_flag))))
	{
	    kerror(NULL, "kcptoval_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "segment",
			  &(clui_info->segment_string),
			  &(clui_info->segment_flag))))
	{
	    kerror(NULL, "kcptoval_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



