 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kcompare.h"
/*-----------------------------------------------------------
| 
|  Routine Name: kcompare_get_args
| 
|       Purpose: Gets command line args for kcompare
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kcompare
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kcompare_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for kcompare is out of sync with arguments specified in kcompare's *.pane file; please rerun ghostwriter on kcompare.";


	/*
	 * allocate the kcompare structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i1",
			  &(clui_info->i1_file),
			  &(clui_info->i1_flag))))
	{
	    kerror(NULL, "kcompare_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "tol",
			  &(clui_info->tol_double),
			  &(clui_info->tol_flag))))
	{
	    kerror(NULL, "kcompare_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "tval",
			  &(clui_info->tval_double),
			  &(clui_info->tval_flag))))
	{
	    kerror(NULL, "kcompare_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "fval",
			  &(clui_info->fval_double),
			  &(clui_info->fval_flag))))
	{
	    kerror(NULL, "kcompare_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "kcompare_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "i2",
			  &(clui_info->i2_file),
			  &(clui_info->i2_flag))))
	{
	    kerror(NULL, "kcompare_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "real",
			  &(clui_info->real_double),
			  &(clui_info->real_flag))))
	{
	    kerror(NULL, "kcompare_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "eq",
			  &(clui_info->eq_flag))))
	{
	    kerror(NULL, "kcompare_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "ne",
			  &(clui_info->ne_flag))))
	{
	    kerror(NULL, "kcompare_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "gt",
			  &(clui_info->gt_flag))))
	{
	    kerror(NULL, "kcompare_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "ge",
			  &(clui_info->ge_flag))))
	{
	    kerror(NULL, "kcompare_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "lt",
			  &(clui_info->lt_flag))))
	{
	    kerror(NULL, "kcompare_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "le",
			  &(clui_info->le_flag))))
	{
	    kerror(NULL, "kcompare_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



