 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kcmplx2real
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kcmplx2real.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Output = Real, Imaginary, Phase, or Magnitude Component of Input
|
|       Purpose: main program for kcmplx2real
|
|         Input:
|		char *clui_info->i_file; {Input data object}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		Loose group:
|		    char *clui_info->or_file; {Output data object containing REAL component of input }
|		    int   clui_info->or_flag; {TRUE if -or specified}
|
|		    char *clui_info->oi_file; {Output data object containing imaginary component of input}
|		    int   clui_info->oi_flag; {TRUE if -oi specified}
|
|		    char *clui_info->op_file; {Output data object containing phase of input}
|		    int   clui_info->op_flag; {TRUE if -op specified}
|
|		    char *clui_info->om_file; {Output data object containing magnitude of input}
|		    int   clui_info->om_flag; {TRUE if -om specified}
|
|		    Optional M.E. group:
|			int clui_info->mag_flag; {TRUE if -mag specified}
|
|			int clui_info->magsq_flag; {TRUE if -magsq specified}
|
|			int clui_info->logmag1_flag; {TRUE if -logmag1 specified}
|
|			int clui_info->logmagsq1_flag; {TRUE if -logmagsq1 specified}
|
|			int clui_info->logmag_flag; {TRUE if -logmag specified}
|
|			int clui_info->logmagsq_flag; {TRUE if -logmagsq specified}
|
|        Output:
|       Returns:
|
|    Written By: Donna Koechner
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
        kobject src_obj=NULL;
        kobject real_obj=NULL, imag_obj=NULL, mag_obj=NULL, phase_obj=NULL;
        char    *name="kcmplx2real";
        char    *prog="main";
        char    *conversion=NULL;
        char    *seg_datatype=NULL;
        int     data_type, dt, mag_type=KMAGNITUDE;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(kcmplx2real_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "kcmplx2real",
		kcmplx2real_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kcmplx2real_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	if (!clui_info->or_flag && !clui_info->oi_flag && 
	    !clui_info->om_flag  && !clui_info->op_flag)
	{
           kerror(name,prog, "At least one output object must be selected.");
           kexit(KEXIT_FAILURE);
	}

	/* Open Source object */
        if ((src_obj = kpds_open_input_object(clui_info->i_file))
                == KOBJECT_INVALID)
        {
           kerror(name,prog, "Cannot open input object.");
           kexit(KEXIT_FAILURE);
        }
 
	/* Open Destination object */
	if (clui_info->or_flag)
	{
           if ((real_obj = kpds_open_output_object(clui_info->or_file))
                == KOBJECT_INVALID)
           {
              kerror(name,prog, "Cannot open Real output object.");
              kexit(KEXIT_FAILURE);
           }
	}

	if (clui_info->oi_flag)
	{
           if ((imag_obj = kpds_open_output_object(clui_info->oi_file))
                == KOBJECT_INVALID)
           {
              kerror(name,prog, "Cannot open Imaginary output object.");
              kexit(KEXIT_FAILURE);
           }
	}

	if (clui_info->om_flag)
	{
           if ((mag_obj = kpds_open_output_object(clui_info->om_file))
                == KOBJECT_INVALID)
           {
              kerror(name,prog, "Cannot open Magnitude output object.");
              kexit(KEXIT_FAILURE);
           }
	}

	if (clui_info->op_flag)
	{
           if ((phase_obj = kpds_open_output_object(clui_info->op_file))
                == KOBJECT_INVALID)
           {
              kerror(name,prog, "Cannot open Phase output object.");
              kexit(KEXIT_FAILURE);
           }
	}

	/* If map data exists, operate on it.  Otherwise operate on Value */
	if (kpds_query_map(src_obj))
	{
	   if (!kpds_get_attribute(src_obj, KPDS_MAP_DATA_TYPE, &dt))
	   {
	      kerror(name,prog, "Cannot get source map data type.");
	      kexit(KEXIT_FAILURE);
	   }
	   seg_datatype = KPDS_MAP_DATA_TYPE;
	   conversion   = KPDS_MAP_COMPLEX_CONVERT;
	}
	else if (kpds_query_value(src_obj))
	{
	   if (!kpds_get_attribute(src_obj, KPDS_VALUE_DATA_TYPE, &dt))
	   {
	      kerror(name,prog, "Cannot get source value data type.");
	      kexit(KEXIT_FAILURE);
	   }
	   seg_datatype = KPDS_VALUE_DATA_TYPE;
	   conversion   = KPDS_VALUE_COMPLEX_CONVERT;
	}
	else
	{
	   kerror(name,prog, "Object does not contain Value or Map data.");
	   kexit(KEXIT_FAILURE);
	}

        /* this IF statement added to get correct results when source 
	   object is not complex */
	if ( (dt != KCOMPLEX) && (dt != KDCOMPLEX) )
	{
	   if (dt == KDOUBLE)	 dt = KDCOMPLEX;
	   else			 dt = KCOMPLEX;

	   if (!kpds_set_attribute(src_obj, seg_datatype, dt))
           {
              kerror(name,prog, "Unable to set src_obj to complex data type");
              kexit(KEXIT_FAILURE);
           }
	   kpds_set_attribute(src_obj, KPDS_COUPLING, KDEMAND);
	   kpds_sync_object(src_obj, KPRES2PHYS);
	}

	/* create a reference to the source object */
        if ((src_obj = kpds_reference_object(src_obj)) == KOBJECT_INVALID)
        {
           kerror(name,prog, "Failed to reference input object");
           kexit(KEXIT_FAILURE);
        }

	/* set data type to double or float, depending on complex type */
	if (dt == KDCOMPLEX)	 data_type = KDOUBLE;
	else			 data_type = KFLOAT;

	/* For each output component requested, set data type and complex 
	 * convert attributes, and then copy the source to the destination */
	if (clui_info->or_flag)
	{
	   if (!kpds_set_attributes(src_obj, conversion, KREAL,
				    seg_datatype, data_type, NULL))
	   {
	      kerror(name,prog, "Real: unable to set src_obj attributes");
	      kexit(KEXIT_FAILURE);
	   }

	   /* After attributes are set on source object, copy to destination */
	   if (!kpds_copy_object(src_obj, real_obj))
	   {
	      kerror(name,prog, "Unable to copy src_obj to real_obj.");
	      kexit(KEXIT_FAILURE);
	   }
   
           /* add history to the output object */
           if (!kpds_set_attribute(real_obj, KPDS_HISTORY, 
				   kpds_history_string()))
           {
              kerror(name,prog, "Unable to set history on real output object");
              kexit(KEXIT_FAILURE);
           }
           kpds_close_object(real_obj);
	}

	if (clui_info->oi_flag)
	{
	   if (!kpds_set_attributes(src_obj, conversion, KIMAGINARY,
				    seg_datatype, data_type, NULL))
	   {
	      kerror(name,prog, "Imaginary: unable to set src_obj attributes");
	      kexit(KEXIT_FAILURE);
	   }

	   /* After attributes are set on source object, copy to destination */
	   if (!kpds_copy_object(src_obj, imag_obj))
	   {
	      kerror(name,prog, "Unable to copy src_obj to imag_obj.");
	      kexit(KEXIT_FAILURE);
	   }
   
           /* add history to the output object */
           if (!kpds_set_attribute(imag_obj, KPDS_HISTORY, 
				   kpds_history_string()))
           {
              kerror(name,prog, "Unable to set history on imaginary output");
              kexit(KEXIT_FAILURE);
           }
           kpds_close_object(imag_obj);
	}
	if (clui_info->om_flag)
	{
	   if      (clui_info->mag_flag)       mag_type = KMAGNITUDE;
	   else if (clui_info->logmag_flag)    mag_type = KLOGMAG;
	   else if (clui_info->logmag1_flag)   mag_type = KLOGMAGP1;
	   else if (clui_info->magsq_flag)     mag_type = KMAGSQ;
	   else if (clui_info->logmagsq_flag)  mag_type = KLOGMAGSQ;
	   else if (clui_info->logmagsq1_flag) mag_type = KLOGMAGSQP1;
	   else                                mag_type = KLOGMAGP1;
	   if (!kpds_set_attributes(src_obj, conversion, mag_type,
				    seg_datatype, data_type, NULL))
	   {
	      kerror(name,prog, "Magnitude: unable to set src_obj attributes");
	      kexit(KEXIT_FAILURE);
	   }

	   /* After attributes are set on source object, copy to destination */
	   if (!kpds_copy_object(src_obj, mag_obj))
	   {
	      kerror(name,prog, "Unable to copy src_obj to mag_obj.");
	      kexit(KEXIT_FAILURE);
	   }
   
/* uncomment for debugging
kpds_print_attribute(mag_obj, conversion, kstdout);
kinfo(KSTANDARD, " <-- mag_obj magnitude conversion type");
kpds_print_attribute(src_obj, conversion, kstdout);
kinfo(KSTANDARD, " <-- src_obj magnitude conversion type");
*/
           /* add history to the output object */
           if (!kpds_set_attribute(mag_obj, KPDS_HISTORY, 
				   kpds_history_string()))
           {
              kerror(name,prog, "Unable to set history on magnitude output");
              kexit(KEXIT_FAILURE);
           }
           kpds_close_object(mag_obj);
	}
	if (clui_info->op_flag)
	{
	   if (!kpds_set_attributes(src_obj, conversion, KPHASE,
				    seg_datatype, data_type, NULL))
	   {
	      kerror(name,prog, "Phase: unable to set src_obj attributes");
	      kexit(KEXIT_FAILURE);
	   }

	   /* After attributes are set on source object, copy to destination */
	   if (!kpds_copy_object(src_obj, phase_obj))
	   {
	      kerror(name,prog, "Unable to copy src_obj to phase_obj.");
	      kexit(KEXIT_FAILURE);
	   }
   
           /* add history to the output object */
           if (!kpds_set_attribute(phase_obj, KPDS_HISTORY, 
				   kpds_history_string()))
           {
              kerror(name,prog, "Unable to set history on phase output");
              kexit(KEXIT_FAILURE);
           }
           kpds_close_object(phase_obj);
	}
 
        kpds_close_object(src_obj);
/* -main_before_lib_call_end */

/* -main_library_call */
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kcmplx2real_usage_additions
| 
|       Purpose: Prints usage additions in kcmplx2real_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kcmplx2real
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kcmplx2real_usage_additions(void)
{
	kfprintf(kstderr, "\tOutput = Real, Imaginary, Phase, or Magnitude Component of\n");
	kfprintf(kstderr, "\tInput\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kcmplx2real_free_args
| 
|       Purpose: Frees CLUI struct allocated in kcmplx2real_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kcmplx2real
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kcmplx2real_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->or_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
