 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kcmplx
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kcmplx.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Single Operand Complex Arithmetic
|
|       Purpose: main program for kcmplx
|
|         Input:
|		char *clui_info->i_file; {input data object}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {resulting output data object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		Required M.E. group:
|		    int clui_info->conj_flag; {TRUE if -conj specified}
|
|		    int clui_info->p2r_flag; {TRUE if -p2r specified}
|
|		    int clui_info->r2p_flag; {TRUE if -r2p specified}
|
|        Output:
|       Returns:
|
|    Written By: Donna Koechner, Ashish Malhotra, Mark Young, Jeremy Worley
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
        kobject in_obj;
        kobject out_obj;
        char    *function=NULL;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(kcmplx_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "kcmplx",
		kcmplx_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kcmplx_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        if ((in_obj = kpds_open_input_object(clui_info->i_file))
		== KOBJECT_INVALID)
        {
           kerror("kcmplx", "main", "Cannot open input object.");
           kexit(KEXIT_FAILURE);
        }

        if ((out_obj = kpds_open_output_object(clui_info->o_file))
		== KOBJECT_INVALID)
        {
           kerror("kcmplx", "main", "Cannot open output object.");
           kexit(KEXIT_FAILURE);
        }

        if (clui_info->conj_flag)
           function = "conj";
        else if (clui_info->p2r_flag)
           function = "p2r";
        else if (clui_info->r2p_flag)
           function = "r2p";
        else
        {
           kerror("kcmplx", "main", "function not specified.");
           kexit(KEXIT_FAILURE);
        }

        kpds_copy_object(in_obj, out_obj);
/* -main_before_lib_call_end */

/* -main_library_call */
	if (!lkcmplx(in_obj, function, out_obj))
	   kexit(KEXIT_FAILURE);
/* -main_library_call_end */

/* -main_after_lib_call */
        /* add history to the output object */
        if (!kpds_set_attribute(out_obj, KPDS_HISTORY, kpds_history_string()))
        {
           kerror("kcmplx", "main",
                  "Unable to set history on the destination object");
            kexit(KEXIT_FAILURE);
        }
 

        kpds_close_object(in_obj);
        kpds_close_object(out_obj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kcmplx_usage_additions
| 
|       Purpose: Prints usage additions in kcmplx_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kcmplx
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kcmplx_usage_additions(void)
{
	kfprintf(kstderr, "\tSingle Operand Complex Arithmetic\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kcmplx_free_args
| 
|       Purpose: Frees CLUI struct allocated in kcmplx_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kcmplx
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kcmplx_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
