 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for kblend
   >>>> 
   >>>>    Written By: Ashish Malhotra
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _kblend_h_
#define _kblend_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <datamanip.h>

/* -include_includes */
#include "kdatamanip/kdatamanip.h"
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$DATAMANIP/objects/kroutine/kblend/uis/kblend.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  first input data object (required infile)
 */
char	*i1_file;	/* first input data object FILENAME */
int	 i1_flag;	/* first input data object FLAG */

/*
 *  second input file object (required infile)
 */
char	*i2_file;	/* second input file object FILENAME */
int	 i2_flag;	/* second input file object FLAG */

/*
 *  resulting output data object (required outfile)
 */
char	*o_file;	/* resulting output data object FILENAME */
int	 o_flag;	/* resulting output data object FLAG */

/*----- required ME group ----*/
/*
 *  Ratio of blending the two objects (optional double)
 */
double	 ratio_double;	/* Ratio of blending the two objects DOUBLE */
int	 ratio_flag;   	/* Ratio of blending the two objects FLAG */

/*
 *  Input object for providing blending ratios (optional infile)
 */
char	*iratio_file;	/* Input object for providing blending ratios FILENAME */
int	 iratio_flag;	/* Input object for providing blending ratios FLAG */

/*-- required ME group end ---*/

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void kblend_get_args PROTO((kform *));
void kblend_usage_additions PROTO((void));
void kblend_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
