 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for kbitwise
   >>>> 
   >>>>    Written By: Donna Koechner & Mark Young
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _kbitwise_h_
#define _kbitwise_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <datamanip.h>

/* -include_includes */
#include "kdatamanip/kdatamanip.h"
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$DATAMANIP/objects/kroutine/kbitwise/uis/kbitwise.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  first input data object (required infile)
 */
char	*i1_file;	/* first input data object FILENAME */
int	 i1_flag;	/* first input data object FLAG */

/*
 *  resulting output data object (required outfile)
 */
char	*o_file;	/* resulting output data object FILENAME */
int	 o_flag;	/* resulting output data object FLAG */

/*----- required ME group ----*/
/*
 *  Bitwise AND:  o = i1 & (i2 or val) (optional flag)
 */
int	 and_flag;  	/* Bitwise AND:  o = i1 & (i2 or val) FLAG */

/*
 *  Bitwise Left Shift:  o = i1 << by (i2 or val) (optional flag)
 */
int	 ls_flag;  	/* Bitwise Left Shift:  o = i1 << by (i2 or val) FLAG */

/*
 *  Bitwise OR:   o = i1 | (i2 or val) (optional flag)
 */
int	 or_flag;  	/* Bitwise OR:   o = i1 | (i2 or val) FLAG */

/*
 *  Bitwise Right Shift:  o = i1 >> by (i2 or val) (optional flag)
 */
int	 rs_flag;  	/* Bitwise Right Shift:  o = i1 >> by (i2 or val) FLAG */

/*
 *  Bitwise XOR:  o = i1 ^ (i2 or val) (optional flag)
 */
int	 xor_flag;  	/* Bitwise XOR:  o = i1 ^ (i2 or val) FLAG */

/*
 *  Bitwise Signed Right Shift by (i2 or val) (optional flag)
 */
int	 srs_flag;  	/* Bitwise Signed Right Shift by (i2 or val) FLAG */

/*
 *  Bitwise NAND: o = (~i1) | (~(i2 or val)) (optional flag)
 */
int	 nand_flag;  	/* Bitwise NAND: o = (~i1) | (~(i2 or val)) FLAG */

/*
 *  Bitwise Right Rotate by (i2 or val) (optional flag)
 */
int	 rr_flag;  	/* Bitwise Right Rotate by (i2 or val) FLAG */

/*
 *  Bitwise NOR:  o = (~i1) & (~(i2 or val)) (optional flag)
 */
int	 nor_flag;  	/* Bitwise NOR:  o = (~i1) & (~(i2 or val)) FLAG */

/*
 *  Bitwise Left Rotate by (i2 or val) (optional flag)
 */
int	 lr_flag;  	/* Bitwise Left Rotate by (i2 or val) FLAG */

/*
 *  Bitwise AND Reverse:   o = i1 & (~(i2 or val)) (optional flag)
 */
int	 andrev_flag;  	/* Bitwise AND Reverse:   o = i1 & (~(i2 or val)) FLAG */

/*
 *  Bitwise AND Inverted:  o = (~i1) & (i2 or val) (optional flag)
 */
int	 andinv_flag;  	/* Bitwise AND Inverted:  o = (~i1) & (i2 or val) FLAG */

/*
 *  Bitwise OR Reverse:    o = i1 | (~(i2 or val)) (optional flag)
 */
int	 orrev_flag;  	/* Bitwise OR Reverse:    o = i1 | (~(i2 or val)) FLAG */

/*
 *  Bitwise OR Inverted:   o = (~i1) | i2 (optional flag)
 */
int	 orinv_flag;  	/* Bitwise OR Inverted:   o = (~i1) | i2 FLAG */

/*-- required ME group end ---*/

/*----- optional ME group ----*/
/*
 *  second input data object (optional infile)
 */
char	*i2_file;	/* second input data object FILENAME */
int	 i2_flag;	/* second input data object FLAG */

/*
 *  constant value (optional integer)
 */
int	 real_int; 	/* constant value INT */
int	 real_flag;	/* constant value FLAG */

/*-- optional ME group end ---*/

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void kbitwise_get_args PROTO((kform *));
void kbitwise_usage_additions PROTO((void));
void kbitwise_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
