 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kbessel
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kbessel.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Compute Bessel Functions
|
|       Purpose: main program for kbessel
|
|         Input:
|		char *clui_info->i_file; {input data object}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {resulting output data object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		Required M.E. group:
|		    int clui_info->j_flag; {TRUE if -j specified}
|
|		    int clui_info->y_flag; {TRUE if -y specified}
|
|		Required M.E. group:
|		    int clui_info->ord0_flag; {TRUE if -ord0 specified}
|
|		    int clui_info->ord1_flag; {TRUE if -ord1 specified}
|
|		    int clui_info->order_int; {Compute Bessel function of specified order}
|		    int clui_info->order_flag; {TRUE if -order specified}
|
|        Output:
|       Returns:
|
|    Written By: Ashish Malhotra
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
        kobject in_obj;
        kobject out_obj;
        int order=0;
        int fn_kind=1;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(kbessel_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "kbessel",
		kbessel_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kbessel_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        if ((in_obj = kpds_open_input_object(clui_info->i_file))
		== KOBJECT_INVALID)
        {
           kerror("kbessel","main",
                  "Cannot open input object.");
           kexit(KEXIT_FAILURE);
        }

        if ((out_obj = kpds_open_output_object(clui_info->o_file))
		== KOBJECT_INVALID)
        {
           kerror("kbessel","main",
                  "Cannot open output object.");
           kexit(KEXIT_FAILURE);
        }

       if(clui_info->ord0_flag)
          order = 0;
       if(clui_info->ord1_flag)
          order = 1;
       if(clui_info->order_flag)
          order = clui_info->order_int;

       if(clui_info->j_flag)
          fn_kind=1;
       if(clui_info->y_flag)
          fn_kind=2;

       if (!kpds_copy_object_attr(in_obj,out_obj))
       {
          kerror("kbessel","main",
                 "Cannot copy attributes from input to output object.");
          kexit(KEXIT_FAILURE);
       }
/* -main_before_lib_call_end */

/* -main_library_call */
       if (!lkbessel(in_obj, fn_kind, order, out_obj))

       {
          kpds_close_object(in_obj);
          kpds_close_object(out_obj);
          kexit(KEXIT_FAILURE);
       }
/* -main_library_call_end */

/* -main_after_lib_call */
	/* add history to the output object */
	if (!kpds_set_attribute(out_obj, KPDS_HISTORY, kpds_history_string()))
	{
	   kerror("kbessel", "main", 
		  "Unable to set history on the destination object");
            kexit(KEXIT_FAILURE);
	}

       if (!kpds_copy_remaining_data(in_obj,out_obj))
       {
          kerror("kbessel","main",
                 "Cannot copy remaining data from input to output object.");
          kexit(KEXIT_FAILURE);
       }

/* -main_before_lib_call_end */
        kpds_close_object(in_obj);
        kpds_close_object(out_obj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kbessel_usage_additions
| 
|       Purpose: Prints usage additions in kbessel_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kbessel
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kbessel_usage_additions(void)
{
	kfprintf(kstderr, "\tCompute Bessel Functions\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kbessel_free_args
| 
|       Purpose: Frees CLUI struct allocated in kbessel_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kbessel
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kbessel_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
