 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kasc2time.h"
/*-----------------------------------------------------------
| 
|  Routine Name: kasc2time_get_args
| 
|       Purpose: Gets command line args for kasc2time
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kasc2time
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kasc2time_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for kasc2time is out of sync with arguments specified in kasc2time's *.pane file; please rerun ghostwriter on kasc2time.";


	/*
	 * allocate the kasc2time structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i1",
			  &(clui_info->i1_file),
			  &(clui_info->i1_flag))))
	{
	    kerror(NULL, "kasc2time_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "i2",
			  &(clui_info->i2_file),
			  &(clui_info->i2_flag))))
	{
	    kerror(NULL, "kasc2time_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "so",
			  &(clui_info->so_int),
			  &(clui_info->so_flag))))
	{
	    kerror(NULL, "kasc2time_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "tsize",
			  &(clui_info->tsize_int),
			  &(clui_info->tsize_flag))))
	{
	    kerror(NULL, "kasc2time_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_value(pane, "type", KVF_LIST_LABEL,
			  &(clui_info->type_label),
			  &(clui_info->type_flag)) &&
	      kclui_get_value(pane, "type", KVF_LIST_VAL,
			  &(clui_info->type_list),
			  &(clui_info->type_flag))))
	{
	    kerror(NULL, "kasc2time_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "kasc2time_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



