 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "karith2.h"
/*-----------------------------------------------------------
| 
|  Routine Name: karith2_get_args
| 
|       Purpose: Gets command line args for karith2
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname karith2
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void karith2_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for karith2 is out of sync with arguments specified in karith2's *.pane file; please rerun ghostwriter on karith2.";


	/*
	 * allocate the karith2 structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i1",
			  &(clui_info->i1_file),
			  &(clui_info->i1_flag))))
	{
	    kerror(NULL, "karith2_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "karith2_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "i2",
			  &(clui_info->i2_file),
			  &(clui_info->i2_flag))))
	{
	    kerror(NULL, "karith2_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "real",
			  &(clui_info->real_double),
			  &(clui_info->real_flag))))
	{
	    kerror(NULL, "karith2_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "imag",
			  &(clui_info->imag_double),
			  &(clui_info->imag_flag))))
	{
	    kerror(NULL, "karith2_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "add",
			  &(clui_info->add_flag))))
	{
	    kerror(NULL, "karith2_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "hypot",
			  &(clui_info->hypot_flag))))
	{
	    kerror(NULL, "karith2_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "sub",
			  &(clui_info->sub_flag))))
	{
	    kerror(NULL, "karith2_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "atan2",
			  &(clui_info->atan2_flag))))
	{
	    kerror(NULL, "karith2_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "subfrom",
			  &(clui_info->subfrom_flag))))
	{
	    kerror(NULL, "karith2_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "mul",
			  &(clui_info->mul_flag))))
	{
	    kerror(NULL, "karith2_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "div",
			  &(clui_info->div_flag))))
	{
	    kerror(NULL, "karith2_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "ldexp",
			  &(clui_info->ldexp_flag))))
	{
	    kerror(NULL, "karith2_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "divinto",
			  &(clui_info->divinto_flag))))
	{
	    kerror(NULL, "karith2_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "pow",
			  &(clui_info->pow_flag))))
	{
	    kerror(NULL, "karith2_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "absdiff",
			  &(clui_info->absdiff_flag))))
	{
	    kerror(NULL, "karith2_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "min",
			  &(clui_info->min_flag))))
	{
	    kerror(NULL, "karith2_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "max",
			  &(clui_info->max_flag))))
	{
	    kerror(NULL, "karith2_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "mod",
			  &(clui_info->mod_flag))))
	{
	    kerror(NULL, "karith2_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



