 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for karith2
   >>>> 
   >>>>    Written By: Donna Koechner & Mark Young
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _karith2_h_
#define _karith2_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <datamanip.h>

/* -include_includes */
#include "kdatamanip/kdatamanip.h"
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$DATAMANIP/objects/kroutine/karith2/uis/karith2.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  first input data object (required infile)
 */
char	*i1_file;	/* first input data object FILENAME */
int	 i1_flag;	/* first input data object FLAG */

/*
 *  resulting output data object (required outfile)
 */
char	*o_file;	/* resulting output data object FILENAME */
int	 o_flag;	/* resulting output data object FLAG */

/*----- required ME group ----*/
/*
 *  second input data object (optional infile)
 */
char	*i2_file;	/* second input data object FILENAME */
int	 i2_flag;	/* second input data object FLAG */

	/*---- nested optional   group ----*/
/*
 *  Real constant value      (optional double)
 */
double	 real_double;	/* Real constant value      DOUBLE */
int	 real_flag;   	/* Real constant value      FLAG */

/*
 *  Imaginary constant value (optional double)
 */
double	 imag_double;	/* Imaginary constant value DOUBLE */
int	 imag_flag;   	/* Imaginary constant value FLAG */

	/*-- nested optional   group end --*/

/*-- required ME group end ---*/

/*----- required ME group ----*/
/*
 *  Add: o = i1 + (i2 or val) (optional flag)
 */
int	 add_flag;  	/* Add: o = i1 + (i2 or val) FLAG */

/*
 *  Hypotenuse:  o = sqrt(i1*i1 + (i2*i2* or val*val)) (optional flag)
 */
int	 hypot_flag;  	/* Hypotenuse:  o = sqrt(i1*i1 + (i2*i2* or val*val)) FLAG */

/*
 *  Subtract: o = i1 - (i2 or val) (optional flag)
 */
int	 sub_flag;  	/* Subtract: o = i1 - (i2 or val) FLAG */

/*
 *  atan2: o = arc tangent (i1 / (i2 or val) (optional flag)
 */
int	 atan2_flag;  	/* atan2: o = arc tangent (i1 / (i2 or val) FLAG */

/*
 *  Subtract From: o = (i2 or val) - i1 (optional flag)
 */
int	 subfrom_flag;  	/* Subtract From: o = (i2 or val) - i1 FLAG */

/*
 *  Multiply: o = i1 * (i2 or val) (optional flag)
 */
int	 mul_flag;  	/* Multiply: o = i1 * (i2 or val) FLAG */

/*
 *  Divide: o = i1 / (i2 or val) (optional flag)
 */
int	 div_flag;  	/* Divide: o = i1 / (i2 or val) FLAG */

/*
 *  ldexp: i1 * 2 ** (i2 or val) (optional flag)
 */
int	 ldexp_flag;  	/* ldexp: i1 * 2 ** (i2 or val) FLAG */

/*
 *  Divide Into:  o = (i2 or val) / i1 (optional flag)
 */
int	 divinto_flag;  	/* Divide Into:  o = (i2 or val) / i1 FLAG */

/*
 *  Power: o = i1 raised to power of (i2 or val) (optional flag)
 */
int	 pow_flag;  	/* Power: o = i1 raised to power of (i2 or val) FLAG */

/*
 *  Absolute Difference:  o = | i1 - (i2 or val) | (optional flag)
 */
int	 absdiff_flag;  	/* Absolute Difference:  o = | i1 - (i2 or val) | FLAG */

/*
 *  Minimum: Returns lower value between i1 and (i2 or val) (optional flag)
 */
int	 min_flag;  	/* Minimum: Returns lower value between i1 and (i2 or val) FLAG */

/*
 *  Maximum: Returns higher value between i1 and (i2 or val) (optional flag)
 */
int	 max_flag;  	/* Maximum: Returns higher value between i1 and (i2 or val) FLAG */

/*
 *  Modulus: o = remainder (i1/i2) (optional flag)
 */
int	 mod_flag;  	/* Modulus: o = remainder (i1/i2) FLAG */

/*-- required ME group end ---*/

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void karith2_get_args PROTO((kform *));
void karith2_usage_additions PROTO((void));
void karith2_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
