 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kappend
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kappend.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Append (or Prepend) Input Objects to Base Object
|
|       Purpose: main program for kappend
|
|         Input:
|		char *clui_info->i1_file; {Base Input data object (input 1)}
|		int   clui_info->i1_flag; {TRUE if -i1 specified}
|
|		char *clui_info->o_file; {Resulting output data object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		char *clui_info->i2_file; {input file 2}
|		int   clui_info->i2_flag; {TRUE if -i2 specified}
|
|		char *clui_info->i3_file; {input file 3}
|		int   clui_info->i3_flag; {TRUE if -i3 specified}
|
|		char *clui_info->i4_file; {input file 4}
|		int   clui_info->i4_flag; {TRUE if -i4 specified}
|
|		char *clui_info->i5_file; {input file 5}
|		int   clui_info->i5_flag; {TRUE if -i5 specified}
|
|		char *clui_info->i6_file; {input file 6}
|		int   clui_info->i6_flag; {TRUE if -i6 specified}
|
|		char *clui_info->i7_file; {input file 7}
|		int   clui_info->i7_flag; {TRUE if -i7 specified}
|
|		char *clui_info->i8_file; {input file 8}
|		int   clui_info->i8_flag; {TRUE if -i8 specified}
|
|		char *clui_info->i9_file; {input file 9}
|		int   clui_info->i9_flag; {TRUE if -i9 specified}
|
|		char *clui_info->i10_file; {input file 10}
|		int   clui_info->i10_flag; {TRUE if -i10 specified}
|
|		int clui_info->append_logic; {If True, append objects to base, otherwise prepend}
|		int clui_info->append_flag; {TRUE if -append specified}
|
|		int   clui_info->mapping_list; {Defines map treatment when some, but not all, objects have maps }
|		char *clui_info->mapping_label;
|		int   clui_info->mapping_flag; {TRUE if -mapping specified}
|
|		Optional M.E. group:
|		    int clui_info->w_flag; {TRUE if -w specified}
|
|		    int clui_info->h_flag; {TRUE if -h specified}
|
|		    int clui_info->d_flag; {TRUE if -d specified}
|
|		    int clui_info->t_flag; {TRUE if -t specified}
|
|		    int clui_info->e_flag; {TRUE if -e specified}
|
|        Output:
|       Returns:
|
|    Written By: 
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
        kobject src_obj_array[10], dst_obj=NULL;
        kstring name_array[10];
        char    *rtn="main";
        int     i, num_objects=0;
        int     mapping;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(kappend_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "kappend",
		kappend_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kappend_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	for (i=0; i<10; i++)
	{	
	   src_obj_array[i]=NULL;
	   name_array[i]=NULL;
	}

	if (!clui_info->i1_flag)
	{
	   kerror(NULL,rtn, "Input 1 must be specified.");
           kexit(KEXIT_FAILURE);
	}
	
	if ((dst_obj = kpds_open_output_object(clui_info->o_file)) 
			== KOBJECT_INVALID)
	{
	   kerror(NULL,rtn, "Cannot open output object %s.", clui_info->o_file);
           kexit(KEXIT_FAILURE);
	}

	if (clui_info->append_logic)
	{
	   if (!kappend_build_obj_array(clui_info->i1_flag, clui_info->i1_file,
			src_obj_array, name_array, &num_objects))
	      kexit(KEXIT_FAILURE);
	   if (!kpds_copy_object_attr(src_obj_array[num_objects-1], dst_obj))
	   {
	      kerror(NULL, rtn, 
		   "Unable to copy object attributes from Input 1 to Output");
              kexit(KEXIT_FAILURE);
	   }
	}

	if ((!kappend_build_obj_array(clui_info->i2_flag, clui_info->i2_file, 
			src_obj_array, name_array, &num_objects)) ||
	    (!kappend_build_obj_array(clui_info->i3_flag, clui_info->i3_file, 
			src_obj_array, name_array, &num_objects)) ||
	    (!kappend_build_obj_array(clui_info->i4_flag, clui_info->i4_file,
			src_obj_array, name_array, &num_objects)) ||
	    (!kappend_build_obj_array(clui_info->i5_flag, clui_info->i5_file,
			src_obj_array, name_array, &num_objects)) ||
	    (!kappend_build_obj_array(clui_info->i6_flag, clui_info->i6_file,
			src_obj_array, name_array, &num_objects)) ||
	    (!kappend_build_obj_array(clui_info->i7_flag, clui_info->i7_file,
			src_obj_array, name_array, &num_objects)) ||
	    (!kappend_build_obj_array(clui_info->i8_flag, clui_info->i8_file,
			src_obj_array, name_array, &num_objects)) ||
	    (!kappend_build_obj_array(clui_info->i9_flag, clui_info->i9_file,
			src_obj_array, name_array, &num_objects)) ||
	    (!kappend_build_obj_array(clui_info->i10_flag, clui_info->i10_file,
			src_obj_array, name_array, &num_objects)) )
	    kexit(KEXIT_FAILURE);

	if (!clui_info->append_logic)
	{
	   if (!kappend_build_obj_array(clui_info->i1_flag, clui_info->i1_file,
			src_obj_array, name_array, &num_objects))
	      kexit(KEXIT_FAILURE);
	   if (!kpds_copy_object_attr(src_obj_array[num_objects-1], dst_obj))
	   {
	      kerror(NULL, rtn, 
		   "Unable to copy object attributes from Input 1 to Output");
              kexit(KEXIT_FAILURE);
	   }
	}

	if ( (!clui_info->w_flag) && (!clui_info->h_flag) && 
	     (!clui_info->d_flag) && (!clui_info->t_flag) && 
	     (!clui_info->e_flag) )
	clui_info->w_flag = TRUE;

	if (clui_info->mapping_list == 1)
	   mapping = KAPU_USE_COMMON_MAP;
	else if (clui_info->mapping_list == 2)
	   mapping = KAPU_CREATE_AUTOCOLOR_MAPS;
	else
	   mapping = KAPU_MAP_ALL_DATA;
/*
	kinfo(KSTANDARD,"\n");
	for (i=0; i<num_objects; i++)
	   kinfo(KSTANDARD,"source object number %d, %s",i, name_array[i]);
*/
/* -main_before_lib_call_end */

/* -main_library_call */
        if (!kapu_append(src_obj_array, num_objects, clui_info->w_flag,
                clui_info->h_flag, clui_info->d_flag, clui_info->t_flag,
                clui_info->e_flag, mapping, dst_obj))
           kexit(KEXIT_FAILURE);
/* -main_library_call_end */

/* -main_after_lib_call */
        /* add history to the output object */
        if (!kpds_set_attribute(dst_obj, KPDS_HISTORY, kpds_history_string()))
        {
           kerror(NULL, rtn,
                  "Unable to set history on the destination object");
            kexit(KEXIT_FAILURE);
        }
 
	if (clui_info->append_logic)
	{
           if (!kpds_copy_remaining_data(src_obj_array[0], dst_obj))
           {
               kerror(NULL, rtn,
                   "unable to copy remaining data from input1 to output.");
               kexit(KEXIT_FAILURE);
           }
	}
	else 
	{
           if (!kpds_copy_remaining_data(src_obj_array[num_objects-1], dst_obj))
           {
               kerror(NULL, rtn,
                   "unable to copy remaining data from input1 to output.");
               kexit(KEXIT_FAILURE);
           }
	}

        kpds_close_object(dst_obj);
	for (i=0; i<num_objects; i++)
	{
	   kpds_close_object(src_obj_array[i]);
	   kfree(name_array[i]);
	}

/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kappend_usage_additions
| 
|       Purpose: Prints usage additions in kappend_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kappend
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kappend_usage_additions(void)
{
	kfprintf(kstderr, "\tAppend (or Prepend) Input Objects to Base Object\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kappend_free_args
| 
|       Purpose: Frees CLUI struct allocated in kappend_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kappend
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kappend_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i1_file);
	kfree(clui_info->o_file);
	kfree(clui_info->i2_file);
	kfree(clui_info->i3_file);
	kfree(clui_info->i4_file);
	kfree(clui_info->i5_file);
	kfree(clui_info->i6_file);
	kfree(clui_info->i7_file);
	kfree(clui_info->i8_file);
	kfree(clui_info->i9_file);
	kfree(clui_info->i10_file);
	kfree(clui_info->mapping_label);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
