#include <bootstrap.h>

#define NUM_BYTES 7
#define NUM_UBYTES  NUM_BYTES
#define NUM_SHORTS  NUM_BYTES
#define NUM_USHORTS NUM_BYTES
#define NUM_INTS    NUM_BYTES
#define NUM_UINTS   NUM_BYTES
#define NUM_LONGS   NUM_BYTES
#define NUM_ULONGS  NUM_BYTES
#define NUM_FLOATS  NUM_BYTES
#define NUM_DOUBLES NUM_BYTES

kaddr data;
int fid;
int k;
 
void
do_byte(void)
{
   kprintf("char\n");
   
   /*
    * the little endian vax case
    */
   fid = kopen("data/char.vax", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_VAX);
   if (kread_byte(fid, data, NUM_BYTES) != NUM_BYTES)
   {
      kprintf("vax byte failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("vax:                  ");
   for (k = 0; k < NUM_BYTES; k++)
      kprintf("%d ",(int)((signed char *)data)[k]);
   kprintf("\n");
   
   /*
    * the 32bit big-endian ieee case
    */
   fid = kopen("data/char.ieee_be", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_SPARC);
   if (kread_byte(fid, data, NUM_BYTES) != NUM_BYTES)
   {
      kprintf("ieee big endian byte failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("ieee (big endian):    ");
   for (k = 0; k < NUM_BYTES; k++)
      kprintf("%d ",(int)((signed char *)data)[k]);
   kprintf("\n");
   
   /*
    * the 32bit little-endian ieee case
    */
   fid = kopen("data/char.ieee_le", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_MIPSEL);
   if (kread_byte(fid, data, NUM_BYTES) != NUM_BYTES)
   {
      kprintf("ieee little endian byte failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("ieee (little endian): ");
   for (k = 0; k < NUM_BYTES; k++)
      kprintf("%d ",(int)((signed char *)data)[k]);
   kprintf("\n");
   
   /*
    * the DEC alpha case
    */
   fid = kopen("data/char.alpha", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_ALPHA);
   if (kread_byte(fid, data, NUM_BYTES) != NUM_BYTES)
   {
      kprintf("alpha byte failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("alpha:                ");
   for (k = 0; k < NUM_BYTES; k++)
      kprintf("%d ",(int)((signed char *)data)[k]);
   kprintf("\n");
   
   /*
    * the cray case
    */
   fid = kopen("data/char.cray", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_CRAY);
   if (kread_byte(fid, data, NUM_BYTES) != NUM_BYTES)
   {
      kprintf("cray byte failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("cray:                 ");
   for (k = 0; k < NUM_BYTES; k++)
      kprintf("%d ",(int)((signed char *)data)[k]);
   kprintf("\n");
   
   return;
}

void
do_ubyte(void)
{
   kprintf("unsigned char\n");
   
   /*
    * the little endian vax case
    */
   fid = kopen("data/uchar.vax", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_VAX);
   if (kread_ubyte(fid, data, NUM_UBYTES) != NUM_UBYTES)
   {
      kprintf("vax ubyte failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("vax:                  ");
   for (k = 0; k < NUM_UBYTES; k++)
      kprintf("%u ",(unsigned int)((unsigned char *)data)[k]);
   kprintf("\n");
   
   /*
    * the 32bit big-endian ieee case
    */
   fid = kopen("data/uchar.ieee_be", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_SPARC);
   if (kread_ubyte(fid, data, NUM_UBYTES) != NUM_UBYTES)
   {
      kprintf("ieee big endian ubyte failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("ieee (big endian):    ");
   for (k = 0; k < NUM_UBYTES; k++)
      kprintf("%u ",(unsigned int)((unsigned char *)data)[k]);
   kprintf("\n");
   
   /*
    * the 32bit little-endian ieee case
    */
   fid = kopen("data/uchar.ieee_le", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_MIPSEL);
   if (kread_ubyte(fid, data, NUM_UBYTES) != NUM_UBYTES)
   {
      kprintf("ieee little endian ubyte failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("ieee (little endian): ");
   for (k = 0; k < NUM_UBYTES; k++)
      kprintf("%u ",(unsigned int)((unsigned char *)data)[k]);
   kprintf("\n");
   
   /*
    * the DEC alpha case
    */
   fid = kopen("data/uchar.alpha", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_ALPHA);
   if (kread_ubyte(fid, data, NUM_UBYTES) != NUM_UBYTES)
   {
      kprintf("alpha ubyte failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("alpha:                ");
   for (k = 0; k < NUM_UBYTES; k++)
      kprintf("%u ",(unsigned int)((unsigned char *)data)[k]);
   kprintf("\n");
   
   /*
    * the cray case
    */
   fid = kopen("data/uchar.cray", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_CRAY);
   if (kread_ubyte(fid, data, NUM_UBYTES) != NUM_UBYTES)
   {
      kprintf("cray ubyte failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("cray:                 ");
   for (k = 0; k < NUM_UBYTES; k++)
      kprintf("%u ",(unsigned int)((unsigned char *)data)[k]);
   kprintf("\n");
   
   return;
}

 
void
do_short(void)
{
   kprintf("short\n");
   
   /*
    * the little endian vax case
    */
   fid = kopen("data/short.vax", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_VAX);
   if (kread_short(fid, data, NUM_SHORTS) != NUM_SHORTS)
   {
      kprintf("vax short failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("vax:                  ");
   for (k = 0; k < NUM_SHORTS; k++)
      kprintf("%d ",(int)((short *)data)[k]);
   kprintf("\n");
   
   /*
    * the 32bit big-endian ieee case
    */
   fid = kopen("data/short.ieee_be", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_SPARC);
   if (kread_short(fid, data, NUM_SHORTS) != NUM_SHORTS)
   {
      kprintf("ieee big endian short failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("ieee (big endian):    ");
   for (k = 0; k < NUM_SHORTS; k++)
      kprintf("%d ",(int)((short *)data)[k]);
   kprintf("\n");
   
   /*
    * the 32bit little-endian ieee case
    */
   fid = kopen("data/short.ieee_le", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_MIPSEL);
   if (kread_short(fid, data, NUM_SHORTS) != NUM_SHORTS)
   {
      kprintf("ieee little endian short failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("ieee (little endian): ");
   for (k = 0; k < NUM_SHORTS; k++)
      kprintf("%d ",(int)((short *)data)[k]);
   kprintf("\n");
   
   /*
    * the DEC alpha case
    */
   fid = kopen("data/short.alpha", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_ALPHA);
   if (kread_short(fid, data, NUM_SHORTS) != NUM_SHORTS)
   {
      kprintf("alpha short failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("alpha:                ");
   for (k = 0; k < NUM_SHORTS; k++)
      kprintf("%d ",(int)((short *)data)[k]);
   kprintf("\n");
   
   /*
    * the cray case
    */
   fid = kopen("data/short.cray", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_CRAY);
   if (kread_short(fid, data, NUM_SHORTS) != NUM_SHORTS)
   {
      kprintf("cray short failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("cray:                 ");
   for (k = 0; k < NUM_SHORTS; k++)
      kprintf("%d ",(int)((short *)data)[k]);
   kprintf("\n");
   
   return;
}

 
void
do_ushort(void)
{
   kprintf("unsigned short\n");
   
   /*
    * the little endian vax case
    */
   fid = kopen("data/ushort.vax", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_VAX);
   if (kread_ushort(fid, data, NUM_USHORTS) != NUM_USHORTS)
   {
      kprintf("vax ushort failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("vax:                  ");
   for (k = 0; k < NUM_USHORTS; k++)
      kprintf("%u ",(unsigned int)((unsigned short *)data)[k]);
   kprintf("\n");
   
   /*
    * the 32bit big-endian ieee case
    */
   fid = kopen("data/ushort.ieee_be", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_SPARC);
   if (kread_ushort(fid, data, NUM_USHORTS) != NUM_USHORTS)
   {
      kprintf("ieee big endian ushort failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("ieee (big endian):    ");
   for (k = 0; k < NUM_USHORTS; k++)
      kprintf("%u ",(unsigned int)((unsigned short *)data)[k]);
   kprintf("\n");
   
   /*
    * the 32bit little-endian ieee case
    */
   fid = kopen("data/ushort.ieee_le", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_MIPSEL);
   if (kread_ushort(fid, data, NUM_USHORTS) != NUM_USHORTS)
   {
      kprintf("ieee little endian ushort failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("ieee (little endian): ");
   for (k = 0; k < NUM_USHORTS; k++)
      kprintf("%u ",(unsigned int)((unsigned short *)data)[k]);
   kprintf("\n");
   
   /*
    * the DEC alpha case
    */
   fid = kopen("data/ushort.alpha", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_ALPHA);
   if (kread_ushort(fid, data, NUM_USHORTS) != NUM_USHORTS)
   {
      kprintf("alpha ushort failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("alpha:                ");
   for (k = 0; k < NUM_USHORTS; k++)
      kprintf("%u ",(unsigned int)((unsigned short *)data)[k]);
   kprintf("\n");
   
   /*
    * the cray case
    */
   fid = kopen("data/ushort.cray", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_CRAY);
   if (kread_ushort(fid, data, NUM_USHORTS) != NUM_USHORTS)
   {
      kprintf("cray ushort failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("cray:                 ");
   for (k = 0; k < NUM_USHORTS; k++)
      kprintf("%u ",(unsigned int)((unsigned short *)data)[k]);
   kprintf("\n");
   
   return;
}
 
void
do_int(void)
{
   kprintf("int\n");
   
   /*
    * the little endian vax case
    */
   fid = kopen("data/int.vax", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_VAX);
   if (kread_int(fid, data, NUM_INTS) != NUM_INTS)
   {
      kprintf("vax int failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("vax:                  ");
   for (k = 0; k < NUM_INTS; k++)
      kprintf("%d ",(int)((int *)data)[k]);
   kprintf("\n");
   
   /*
    * the 32bit big-endian ieee case
    */
   fid = kopen("data/int.ieee_be", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_SPARC);
   if (kread_int(fid, data, NUM_INTS) != NUM_INTS)
   {
      kprintf("ieee big endian int failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("ieee (big endian):    ");
   for (k = 0; k < NUM_INTS; k++)
      kprintf("%d ",(int)((int *)data)[k]);
   kprintf("\n");
   
   /*
    * the 32bit little-endian ieee case
    */
   fid = kopen("data/int.ieee_le", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_MIPSEL);
   if (kread_int(fid, data, NUM_INTS) != NUM_INTS)
   {
      kprintf("ieee little endian int failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("ieee (little endian): ");
   for (k = 0; k < NUM_INTS; k++)
      kprintf("%d ",(int)((int *)data)[k]);
   kprintf("\n");
   
   /*
    * the DEC alpha case
    */
   fid = kopen("data/int.alpha", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_ALPHA);
   if (kread_int(fid, data, NUM_INTS) != NUM_INTS)
   {
      kprintf("alpha int failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("alpha:                ");
   for (k = 0; k < NUM_INTS; k++)
      kprintf("%d ",(int)((int *)data)[k]);
   kprintf("\n");
   
   /*
    * the cray case
    */
   fid = kopen("data/int.cray", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_CRAY);
   if (kread_int(fid, data, NUM_INTS) != NUM_INTS)
   {
      kprintf("cray int failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("cray:                 ");
   for (k = 0; k < NUM_INTS; k++)
      kprintf("%d ",(int)((int *)data)[k]);
   kprintf("\n");
   
   return;
}

 
void
do_uint(void)
{
   kprintf("unsigned int\n");
   
   /*
    * the little endian vax case
    */
   fid = kopen("data/uint.vax", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_VAX);
   if (kread_uint(fid, data, NUM_UINTS) != NUM_UINTS)
   {
      kprintf("vax uint failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("vax:                  ");
   for (k = 0; k < NUM_UINTS; k++)
      kprintf("%u ",(unsigned int)((unsigned int *)data)[k]);
   kprintf("\n");
   
   /*
    * the 32bit big-endian ieee case
    */
   fid = kopen("data/uint.ieee_be", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_SPARC);
   if (kread_uint(fid, data, NUM_UINTS) != NUM_UINTS)
   {
      kprintf("ieee big endian uint failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("ieee (big endian):    ");
   for (k = 0; k < NUM_UINTS; k++)
      kprintf("%u ",(unsigned int)((unsigned int *)data)[k]);
   kprintf("\n");
   
   /*
    * the 32bit little-endian ieee case
    */
   fid = kopen("data/uint.ieee_le", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_MIPSEL);
   if (kread_uint(fid, data, NUM_UINTS) != NUM_UINTS)
   {
      kprintf("ieee little endian uint failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("ieee (little endian): ");
   for (k = 0; k < NUM_UINTS; k++)
      kprintf("%u ",(unsigned int)((unsigned int *)data)[k]);
   kprintf("\n");
   
   /*
    * the DEC alpha case
    */
   fid = kopen("data/uint.alpha", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_ALPHA);
   if (kread_uint(fid, data, NUM_UINTS) != NUM_UINTS)
   {
      kprintf("alpha uint failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("alpha:                ");
   for (k = 0; k < NUM_UINTS; k++)
      kprintf("%u ",(unsigned int)((unsigned int *)data)[k]);
   kprintf("\n");
   
   /*
    * the cray case
    */
   fid = kopen("data/uint.cray", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_CRAY);
   if (kread_uint(fid, data, NUM_UINTS) != NUM_UINTS)
   {
      kprintf("cray uint failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("cray:                 ");
   for (k = 0; k < NUM_UINTS; k++)
      kprintf("%u ",(unsigned int)((unsigned int *)data)[k]);
   kprintf("\n");
   
   return;
}

 
void
do_long(void)
{
   kprintf("long\n");
   
   /*
    * the little endian vax case
    */
   fid = kopen("data/long.vax", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_VAX);
   if (kread_long(fid, data, NUM_LONGS) != NUM_LONGS)
   {
      kprintf("vax long failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("vax:                  ");
   for (k = 0; k < NUM_LONGS; k++)
      kprintf("%ld ",(long)((long *)data)[k]);
   kprintf("\n");
   
   /*
    * the 32bit big-endian ieee case
    */
   fid = kopen("data/long.ieee_be", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_SPARC);
   if (kread_long(fid, data, NUM_LONGS) != NUM_LONGS)
   {
      kprintf("ieee big endian long failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("ieee (big endian):    ");
   for (k = 0; k < NUM_LONGS; k++)
      kprintf("%ld ",(long)((long *)data)[k]);
   kprintf("\n");
   
   /*
    * the 32bit little-endian ieee case
    */
   fid = kopen("data/long.ieee_le", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_MIPSEL);
   if (kread_long(fid, data, NUM_LONGS) != NUM_LONGS)
   {
      kprintf("ieee little endian long failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("ieee (little endian): ");
   for (k = 0; k < NUM_LONGS; k++)
      kprintf("%ld ",(long)((long *)data)[k]);
   kprintf("\n");
   
   /*
    * the DEC alpha case
    */
   fid = kopen("data/long.alpha", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_ALPHA);
   if (kread_long(fid, data, NUM_LONGS) != NUM_LONGS)
   {
      kprintf("alpha long failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("alpha:                ");
   for (k = 0; k < NUM_LONGS; k++)
      kprintf("%ld ",(long)((long *)data)[k]);
   kprintf("\n");
   
   /*
    * the cray case
    */
   fid = kopen("data/long.cray", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_CRAY);
   if (kread_long(fid, data, NUM_LONGS) != NUM_LONGS)
   {
      kprintf("cray long failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("cray:                 ");
   for (k = 0; k < NUM_LONGS; k++)
      kprintf("%ld ",(long)((long *)data)[k]);
   kprintf("\n");
   
   return;
}

 
void
do_ulong(void)
{
   kprintf("unsigned long\n");
   
   /*
    * the little endian vax case
    */
   fid = kopen("data/ulong.vax", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_VAX);
   if (kread_ulong(fid, data, NUM_ULONGS) != NUM_ULONGS)
   {
      kprintf("vax ulong failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("vax:                  ");
   for (k = 0; k < NUM_ULONGS; k++)
      kprintf("%u ",(unsigned long)((unsigned long *)data)[k]);
   kprintf("\n");
   
   /*
    * the 32bit big-endian ieee case
    */
   fid = kopen("data/ulong.ieee_be", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_SPARC);
   if (kread_ulong(fid, data, NUM_ULONGS) != NUM_ULONGS)
   {
      kprintf("ieee big endian ulong failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("ieee (big endian):    ");
   for (k = 0; k < NUM_ULONGS; k++)
      kprintf("%u ",(unsigned long)((unsigned long *)data)[k]);
   kprintf("\n");
   
   /*
    * the 32bit little-endian ieee case
    */
   fid = kopen("data/ulong.ieee_le", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_MIPSEL);
   if (kread_ulong(fid, data, NUM_ULONGS) != NUM_ULONGS)
   {
      kprintf("ieee little endian ulong failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("ieee (little endian): ");
   for (k = 0; k < NUM_ULONGS; k++)
      kprintf("%u ",(unsigned long)((unsigned long *)data)[k]);
   kprintf("\n");
   
   /*
    * the DEC alpha case
    */
   fid = kopen("data/ulong.alpha", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_ALPHA);
   if (kread_ulong(fid, data, NUM_ULONGS) != NUM_ULONGS)
   {
      kprintf("alpha ulong failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("alpha:                ");
   for (k = 0; k < NUM_ULONGS; k++)
      kprintf("%u ",(unsigned long)((unsigned long *)data)[k]);
   kprintf("\n");
   
   /*
    * the cray case
    */
   fid = kopen("data/ulong.cray", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_CRAY);
   if (kread_ulong(fid, data, NUM_ULONGS) != NUM_ULONGS)
   {
      kprintf("cray ulong failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("cray:                 ");
   for (k = 0; k < NUM_ULONGS; k++)
      kprintf("%u ",(unsigned long)((unsigned long *)data)[k]);
   kprintf("\n");
   
   return;
}

void
do_float(void)
{
   kprintf("float\n");
   
   /*
    * the little endian vax case
    */
   fid = kopen("data/float.vax", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_VAX);
   if (kread_float(fid, data, NUM_FLOATS) != NUM_FLOATS)
   {
      kprintf("vax float failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("vax:                  ");
   for (k = 0; k < NUM_FLOATS; k++)
      kprintf("%e ", ((float *)data)[k]);
   kprintf("\n");
   
   /*
    * the 32bit big-endian ieee case
    */
   fid = kopen("data/float.ieee_be", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_SPARC);
   if (kread_float(fid, data, NUM_FLOATS) != NUM_FLOATS)
   {
      kprintf("ieee big endian float failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("ieee (big endian):    ");
   for (k = 0; k < NUM_FLOATS; k++)
      kprintf("%e ", ((float *)data)[k]);
   kprintf("\n");
   
   /*
    * the 32bit little-endian ieee case
    */
   fid = kopen("data/float.ieee_le", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_MIPSEL);
   if (kread_float(fid, data, NUM_FLOATS) != NUM_FLOATS)
   {
      kprintf("ieee little endian float failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("ieee (little endian): ");
   for (k = 0; k < NUM_FLOATS; k++)
      kprintf("%e ", ((float *)data)[k]);
   kprintf("\n");
   
   /*
    * the DEC alpha case
    */
   fid = kopen("data/float.alpha", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_ALPHA);
   if (kread_float(fid, data, NUM_FLOATS) != NUM_FLOATS)
   {
      kprintf("alpha float failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("alpha:                ");
   for (k = 0; k < NUM_FLOATS; k++)
      kprintf("%e ", ((float *)data)[k]);
   kprintf("\n");
   
   /*
    * the cray case
    */
   fid = kopen("data/float.cray", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_CRAY);
   if (kread_float(fid, data, NUM_FLOATS) != NUM_FLOATS)
   {
      kprintf("cray float failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("cray:                 ");
   for (k = 0; k < NUM_FLOATS; k++)
      kprintf("%e ", ((float *)data)[k]);
   kprintf("\n");
   
   return;
}


void
do_double(void)
{
   kprintf("double\n");
   
   /*
    * the little endian vax case
    */
   fid = kopen("data/double.vax", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_VAX);
   if (kread_double(fid, data, NUM_DOUBLES) != NUM_DOUBLES)
   {
      kprintf("vax double failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("vax:                  ");
   for (k = 0; k < NUM_DOUBLES; k++)
      kprintf("%e ", ((double *)data)[k]);
   kprintf("\n");
   
   /*
    * the 32bit big-endian ieee case
    */
   fid = kopen("data/double.ieee_be", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_SPARC);
   if (kread_double(fid, data, NUM_DOUBLES) != NUM_DOUBLES)
   {
      kprintf("ieee big endian double failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("ieee (big endian):    ");
   for (k = 0; k < NUM_DOUBLES; k++)
      kprintf("%e ", ((double *)data)[k]);
   kprintf("\n");
   
   /*
    * the 32bit little-endian ieee case
    */
   fid = kopen("data/double.ieee_le", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_MIPSEL);
   if (kread_double(fid, data, NUM_DOUBLES) != NUM_DOUBLES)
   {
      kprintf("ieee little endian double failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("ieee (little endian): ");
   for (k = 0; k < NUM_DOUBLES; k++)
      kprintf("%e ", ((double *)data)[k]);
   kprintf("\n");
   
   /*
    * the DEC alpha case
    */
   fid = kopen("data/double.alpha", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_ALPHA);
   if (kread_double(fid, data, NUM_DOUBLES) != NUM_DOUBLES)
   {
      kprintf("alpha double failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("alpha:                ");
   for (k = 0; k < NUM_DOUBLES; k++)
      kprintf("%e ", ((double *)data)[k]);
   kprintf("\n");
   
   /*
    * the cray case
    */
   fid = kopen("data/double.cray", KOPEN_RDONLY, 0x0);
   kfile_setmachtype(fid,KMACH_CRAY);
   if (kread_double(fid, data, NUM_DOUBLES) != NUM_DOUBLES)
   {
      kprintf("cray double failure\n");
      kexit(1);
   }
   kclose(fid);
   kprintf("cray:                 ");
   for (k = 0; k < NUM_DOUBLES; k++)
      kprintf("%e ", ((double *)data)[k]);
   kprintf("\n");
   
   return;
}


main(int argc, char **argv)
{
   if (argc < 2)
   {
      kprintf("No data type specified.\n");
      kexit(1);
   }
   
   data = kmalloc(KLENGTH);
   
   switch (atoi(argv[1]))
   {
      case KBYTE:
	 do_byte();
	 break;
      case KUBYTE:
	 do_ubyte();
	 break;
      case KSHORT:
	 do_short();
	 break;
      case KUSHORT:
	 do_ushort();
	 break;
      case KINT:
	 do_int();
	 break;
      case KUINT:
	 do_uint();
	 break;
      case KLONG:
	 do_long();
	 break;
      case KULONG:
	 do_ulong();
	 break;
      case KFLOAT:
	 do_float();
	 break;
      case KDOUBLE:
	 do_double();
	 break;
   }

   kexit(0);
   return;
}
