/*
 * Khoros: $Id$
 */

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Khoros Transport Routines Declaration (Glue)
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: Jul 08, 1992 10:17
   >>>>
   >>>> Modifications: Converted from transport.h in Khoros 1.0 (MY)
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _kutils_routines_h_
#define _kutils_routines_h_

#include "internals.h"


/*
 *  Internal structures for the following transports can be found in
 *  the following source files:
 *
 *		remote(@)  -  Remote.c
 *		file	   -  File.c
 *		shm	   -  Shm.c
 *		mmap	   -  Mmap.c
 *		tli	   -  Tli.c
 *		pipe	   -  Pipe.c
 *		socket	   -  Socket.c
 *		stream	   -  Stream.c
 */
extern TransportInformation remote_transport[];
extern TransportInformation file_transport[];
extern TransportInformation shm_transport[];
extern TransportInformation mmap_transport[];
extern TransportInformation tli_transport[];
extern TransportInformation pipe_transport[];
extern TransportInformation socket_transport[];
extern TransportInformation stream_transport[];

/*
 *  List of currently supported transports....
 *
 *  To add a new transport please see supporting documentation
 *  transport.3
 */
static TransportInformation *transports[] =
{
	shm_transport,
	pipe_transport,
	stream_transport,
	socket_transport,
	file_transport,
	mmap_transport,
	tli_transport,
	remote_transport,
};

/*
 *  define for figuring out the number of transports in the array list
 */
#define	NumTransports	  ((int) sizeof(transports)/sizeof(transports[0]))

#endif /* _kutils_routines_h_ */
/* don`t add after the endif */
