/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            Negotiator Support Utility
   >>>>
   >>>>   Static:
   >>>>  Private:
   >>>>             knegotiate_transport()
   >>>>             knegotiate_open()
   >>>>             knegotiate_close()
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"


/*
 *  The following are private routines that the user should not call but
 *  should be private to the kutils library that enables a negotiation
 *  method between processes thru some user defined negotiator.
 *
 *	routines:	knegotiate_transport
 *			knegotiate_open
 *			knegotiate_close
 */
static int enable_negotiation = TRUE;

/*-----------------------------------------------------------
|
|  Routine Name: knegotiate_transport - enable transport negotation for the
|				   local process.
|
|       Purpose: This function is used to enable the transport negotations
|		 for the default transport
|
|         Input: enable - whether local negotiations should occur or not 
|    Written By: Mark Young
|          Date: Apr 09, 1995
|
------------------------------------------------------------*/
void knegotiate_transport(
   int enable)
{
	enable_negotiation = enable;
}

/*-----------------------------------------------------------
|
|  Routine Name: knegotiate_open - inform negotiator that we opening
|				   a file.
|
|       Purpose: This function is used to call the negotiator,
|		 if one exists.  The negotiator is informed
|		 that the this process will be opening a file
|		 by the name of "path".
|
|         Input: path  - the path that negotiator should be informed of
|		 flags - the flags in which we will be opening the file
|        Output: newpath - the original path or the newly negoatiated path.
|       Returns: 0 on success, -1 upon failure
|    Written By: Mark Young
|          Date: Oct 14, 1992 10:40
|
------------------------------------------------------------*/
int knegotiate_open(
   char *path,
   int  flags)
{
	int   result = 0;
	kfile *ifile, *ofile;
	char  buffer[KLENGTH], type[KLENGTH];


#if 0
kflags_to_type(flags, type);
if (enable_negotiation) kprintf("%d: open %s '%s'\n", getpid(), type, path);
#endif
	if (enable_negotiation == FALSE ||
	    kipc_getdescriptors(KIPC_TRANSPORT, &ifile, &ofile) == -1 ||
	    !ifile || !ofile)
	{
	   return(0);
	}

	kflags_to_type(flags, type);
	(void) ksprintf(buffer, "%d: open '%s' '%s'\n", getpid(), path, type);
	(void) kflock(ifile->id, KLOCK_EX);
	if (kfputs(buffer, ofile) != EOF)
	{
	   if (kfgets(buffer, KLENGTH, ifile) != NULL)
	   {
	      kstring_lower(buffer, buffer);
	      if (kstrcmp(buffer, "yes") == 0)
	         result = 0;
	      else
	         result = -1;
	   }
	}
	(void) kflock(ifile->id, KLOCK_UN);
	return(result);
}

/*-----------------------------------------------------------
|
|  Routine Name: knegotiate_close - inform negotiator that we closing
|				    a file.
|
|       Purpose: This function is used to call the negotiator,
|		 if one exists.  The negotiator is informed
|		 that this process has closed this transport path.
|
|         Input: path - the path that the negotiator should be informed of
|		 flags - the flags in which we will have the file opened
|
|        Output: none
|
|       Returns: 0 upon success, -1 upon failure
|
|    Written By: Mark Young
|          Date: Oct 14, 1992 10:42
| Modifications:
|
------------------------------------------------------------*/

int knegotiate_close(
   char *path,
   int  flags)
{
	int   result = 0;
	kfile *ifile, *ofile;
	char  buffer[KLENGTH], type[KLENGTH];


#if 0
kflags_to_type(flags, type);
if (enable_negotiation) kprintf("%d: close %s '%s'\n", getpid(), type, path);
#endif
	if (enable_negotiation == FALSE ||
	    kipc_getdescriptors(KIPC_TRANSPORT, &ifile, &ofile) == -1 ||
	    !ifile || !ofile)
	{
	   return(0);
	}

	kflags_to_type(flags, type);
	(void) ksprintf(buffer, "%d: close '%s' '%s'\n", getpid(), path, type);

	(void) kflock(ifile->id, KLOCK_EX);
	if (kfputs(buffer, ofile) != EOF)
	{
	   if (kfgets(buffer, KLENGTH, ifile) != NULL)
	   {
	      kstring_lower(buffer, buffer);
	      if (kstrcmp(buffer, "yes") == 0)
	         result = 0;
	      else
	         result = -1;
	   }
	}
	(void) kflock(ifile->id, KLOCK_UN);
	return(result);
}
