/*
 * Khoros: $Id$
 */

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

static char *CopyRight[] =
{
"",
"                        KHOROS SOFTWARE",
"                      FREE ACCESS LICENSE",
"",
"",
"ACCEPTANCE",
"",
"Please read this license agreement before using Khoros.",
"Do not use, copy, or distribute this software until you have read and",
"agreed to the Terms and Conditions of this license agreement.  This is",
"a contract with important legal consequences.  You and your",
"organization, as the Licensee, agree to the Terms and Conditions of",
"this agreement by using, copying, or distributing this software.",
"",
"REGISTRATION",
"",
"Please register your license with Khoral Research, Inc. (KRI).  If you",
"do not have an attached registration form, execute the program",
"kregister to send KRI electronic mail or print out a registration form",
"that can then be sent to KRI via postal mail or FAX.",
"",
"DEFINITIONS",
"",
"\"Khoros Software\" is defined to include source code, object code,",
"executables, libraries, user interface specifications, and",
"documentation of Khoros, all of which is owned by KRI.  Khoros also",
"includes components that are not owned by KRI; these components are",
"clearly marked and contain the owner's notices.",
"",
"\"Loaded\" is defined to mean combining object code to form an",
"executable.",
"",
"RIGHT TO REDISTRIBUTE",
"",
"Permission to distribute this Software using electronic media and at no",
"cost is granted, provided that the Software contains no modifications,",
"provided that the distribution is not assigned any price or value in",
"any way, provided that the distribution is not combined with any",
"product or service in any way, and provided that the distributed",
"Software is identical to the Software that is currently being",
"distributed at no cost via computer network by KRI.",
"",
"DERIVATIVE WORKS",
"",
"Permission to prepare derivative works or to modify the Khoros Software",
"for internal use only is granted to Licensee. However, all rights to",
"such modifications and derivative works, including all copyrights, are",
"the property of KRI. New software developed by Licensee as a result of",
"using the Khoros Software belongs to the author and is not bound by",
"this license agreement. However, any Khoros Software that is Loaded",
"with the author's software is bound by this license agreement.",
"",
"LICENSEE AGREES",
"",
"By distributing the Khoros Software, the Licensee agrees to abide by the",
"copyright law and all other applicable laws of the U.S. and foreign",
"countries, including, but not limited to, export control laws, and the",
"terms of this license.",
"",
"TERMINATION",
"",
"KRI shall have the right to terminate this license immediately by",
"written notice upon Licensee's breach of, or non-compliance with, any",
"of the terms of this license. Licensee may be held legally responsible",
"for any copyright infringement that is caused or encouraged by",
"Licensee's failure to abide by the terms of this license.",
"",
"GOVERNMENT USE RIGHTS",
"",
"Use, duplication, or disclosure by the U.S. Government is subject to",
"restrictions set forth in subparagraphs (a) through (d) of the",
"Commercial Computer Restricted Rights clause of FAR 52.227-19 when",
"applicable, or in subparagraph (c)(1)(ii) of the Rights in Technical",
"Data and Computer Software clause at DFARS 252.227-7013, and in similar",
"clauses in the NASA FAR Supplement. Any provision of Khoros",
"Software to the U.S. Government is with Limited Rights.",
"",
"ADDITIONAL RIGHTS AND CONSORTIUM MEMBERSHIP",
"",
"No additional rights or Khoros Consortium membership are granted.",
"",
"For more information on additional rights and Khoros Consortium",
"membership, contact KRI at the address below.",
"",
"ENTIRE AGREEMENT",
"",
"This License Agreement constitutes the entire agreement between KRI and",
"Licensee and may be amended or changed only by written agreement signed",
"by both parties.  This License Agreement is governed by the laws of the",
"State of New Mexico.",
"",
"DISCLAIMER OF WARRANTY",
"",
"THIS SOFTWARE IS PROVIDED BY KRI \"AS IS\" AND ANY EXPRESS OR IMPLIED",
"WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF",
"MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, ARE DISCLAIMED.",
"IN NO EVENT SHALL KRI BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,",
"SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT",
"LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,",
"DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY",
"THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT",
"(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE",
"OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.",
"",
"QUESTIONS AND INFORMATION",
"",
"If you have any questions concerning this license agreement, the",
"copyright, or trademarks, please contact KRI via electronic mail at",
"khoros-request@khoros.unm.edu or via postal mail at Khoral Research,",
"Inc., 6001 Indian School Road N.E., Suite 200, Albuquerque, NM 87110.",
"",
"COPYRIGHT NOTICE",
"",
"\"Copyright (C) 1993, 1994 Khoral Research, Inc. (\"KRI\"), All Rights Reserved.\"",
"",
"Licensee can not remove or obscure any of the copyright or ",
"trademark notices in this software.  Khoros is a registered trademark",
"of KRI. Cantata, Composer, Craftsman, Guise, Orchestrate and Xprism are ",
"trademarks of KRI. "
};

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            Khoros Initialization Routine
   >>>>
   >>>>  Private:
   >>>>             khoros_initialize()
   >>>>             khoros_imprint()
   >>>>   Static:
   >>>>
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"

static int num_lines = knumber(CopyRight);


/************************************************************
*
*  Routine Name: khoros_initialize - initialize khoros system
*
*       Purpose: Initializes some khoros global variables used in the
*		 khoros system.  Initializes the following
*		 global variables:
*
*         Input: argc    - the number of arguments on the command line
*		 argv    - the list of command line arguments
*		 envp    - the list of environment variables
*		 toolbox - the name of the toolbox the program is 
*		           associated with. 
*        Output: None
*
*	Returns: None
*
*  Restrictions:
*    Written By: Mark Young
*          Date: Sep 03, 1993
*      Verified:
*  Side Effects:
* Modifications: Converted from khoros_init() in Khoros 1.0 (MY)
*
*************************************************************/

void khoros_initialize(
   int  argc,
   char **argv,
   char **envp,
   char *toolbox)
{
	kutils_init_errors();
	kprog_set_argc(argc);
	kprog_set_argv(argv);
	kprog_set_envp(envp);
        if (argv != NULL)
	   kprog_set_program(argv[0]);

	kprog_set_toolbox(toolbox);
}
#if 0
#include <sys/times.h>
 
static int initialized;
static double elapsed;
static clock_t otime, ntime;
static struct tms obuffer, nbuffer;
otime = times(&obuffer);
...
ntime = times(&obuffer);
elapsed = ntime - otime;
kfprintf(kstderr,"elapsed time '%g'\n", elapsed/CLK_TCK);
#endif

/************************************************************
*
*  Routine Name: khoros_imprint - imprint the khoros toolbox
*
*       Purpose: Imprint information about the user into the
*		 khoros toolbox.
*
*         Input: 
*        Output:
*	Returns:
*
*  Restrictions:
*    Written By: Mark Young
*          Date: Oct 23, 1993
*      Verified:
*  Side Effects:
* Modifications:
*
*************************************************************/

void khoros_imprint(void)
{
	kfile  *file;
	time_t timeval;
	struct tm *tmval;
	struct passwd *passwd_ent;
	static char *copyright = NULL;
	char   *tmp, *domain, temp[KLENGTH], name[KLENGTH], date[KLENGTH];


	/*
	 *  If the .khoros file exists then they've already acknowledged
	 *  the terms and conditions.
	 */
	if (kaccess("~/.khoros", F_OK) == 0)
	   return;

	if (!copyright)
	   copyright = karray_to_string(CopyRight, num_lines, "\n");

	if (!kprompt(KFORCE, NULL, NULL, TRUE, "%s\t\t\n\nDo You agree To \
Abide By These Conditions?", copyright))
	{
	      kexit(KEXIT_FAILURE);
	}

	if (kgethostname(NULL, name, KLENGTH) == 0)
	{
	   if ((tmp = kstrchr(name, '.')) != NULL)
	      domain = ++tmp;
	   else
	      domain = name;
	}
	else domain = "UnknownDomainName";

	passwd_ent = getpwuid(getuid());
	(void) ksprintf(temp,"%s@%s", passwd_ent->pw_name, domain);
	timeval = time(NULL);
	tmval   = localtime(&timeval);
	kstrftime(date, KLENGTH, "%h %d, 19%y %H:%M", tmval);

	if ((file = kfopen("~/.khoros", "w")) != NULL)
	{
	   kfprintf(file, "%s: %s\n", temp, date);
	   kfclose(file);
	}
}
