/*
 * Khoros: $Id$
 */

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: The purpose of this file is to
   >>>>                provide sufficient information to
   >>>>                convert.c so that it will compile
   >>>>                successfully and the functions that
   >>>>                it contains will correctly perform
   >>>>                their intended functions.
   >>>>
   >>>>    Written By: Jeremy Worley
   >>>>
   >>>>          Date: Jun 26, 1992 16:41
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _kutils_convert_h_ 
#define _kutils_convert_h_

	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

#define IEEE_FLOAT_SIGN_0 0x80
#define IEEE_FLOAT_EXP1_0 0x7f
#define IEEE_FLOAT_EXP2_1 0x80
#define IEEE_FLOAT_MAN1_1 0x7f
#define IEEE_FLOAT_MAN2_2 0xff
#define IEEE_FLOAT_MAN3_3 0xff

#define IEEE_FLOAT_SIGN_RSHIFT 7
#define IEEE_FLOAT_EXP1_LSHIFT 1
#define IEEE_FLOAT_EXP2_RSHIFT 7
#define IEEE_FLOAT_MAN0_LSHIFT 31
#define IEEE_FLOAT_MAN1_LSHIFT 24
#define IEEE_FLOAT_MAN2_LSHIFT 16
#define IEEE_FLOAT_MAN3_LSHIFT 8

#define IEEE_DOUBLE_SIGN_0 0x80
#define IEEE_DOUBLE_EXP1_0 0x7f
#define IEEE_DOUBLE_EXP2_1 0xf0
#define IEEE_DOUBLE_MAN1_1 0x0f
#define IEEE_DOUBLE_MAN2_2 0xff
#define IEEE_DOUBLE_MAN3_3 0xff
#define IEEE_DOUBLE_MAN4_4 0xff
#define IEEE_DOUBLE_MAN5_5 0xe0
#define IEEE_DOUBLE_MAN6_5 0x1f
#define IEEE_DOUBLE_MAN7_6 0xff
#define IEEE_DOUBLE_MAN8_7 0xff

#define IEEE_DOUBLE_SIGN_RSHIFT 7
#define IEEE_DOUBLE_EXP1_LSHIFT 4
#define IEEE_DOUBLE_EXP2_RSHIFT 4
#define IEEE_DOUBLE_MAN0_LSHIFT 31
#define IEEE_DOUBLE_MAN1_LSHIFT 27
#define IEEE_DOUBLE_MAN2_LSHIFT 19
#define IEEE_DOUBLE_MAN3_LSHIFT 11
#define IEEE_DOUBLE_MAN4_LSHIFT 3
#define IEEE_DOUBLE_MAN5_RSHIFT 3
#define IEEE_DOUBLE_MAN6_LSHIFT 29
#define IEEE_DOUBLE_MAN7_LSHIFT 21
#define IEEE_DOUBLE_MAN8_LSHIFT 13

#define VAX_FLOAT_SIGN_0 IEEE_FLOAT_SIGN_0
#define VAX_FLOAT_EXP1_0 IEEE_FLOAT_EXP1_0
#define VAX_FLOAT_EXP2_1 IEEE_FLOAT_EXP2_1
#define VAX_FLOAT_MAN1_1 IEEE_FLOAT_MAN1_1
#define VAX_FLOAT_MAN2_2 IEEE_FLOAT_MAN2_2
#define VAX_FLOAT_MAN3_3 IEEE_FLOAT_MAN3_3

#define VAX_FLOAT_SIGN_RSHIFT 7
#define VAX_FLOAT_EXP1_LSHIFT 1
#define VAX_FLOAT_EXP2_RSHIFT 7
#define VAX_FLOAT_MAN1_LSHIFT 24
#define VAX_FLOAT_MAN2_LSHIFT 16
#define VAX_FLOAT_MAN3_LSHIFT 8

#define VAX_DOUBLE_SIGN_0 VAX_FLOAT_SIGN_0
#define VAX_DOUBLE_EXP1_0 VAX_FLOAT_EXP1_0
#define VAX_DOUBLE_EXP2_1 VAX_FLOAT_EXP2_1
#define VAX_DOUBLE_MAN1_1 VAX_FLOAT_MAN1_1
#define VAX_DOUBLE_MAN2_2 VAX_FLOAT_MAN2_2
#define VAX_DOUBLE_MAN3_3 VAX_FLOAT_MAN3_3
#define VAX_DOUBLE_MAN4_4 0x80
#define VAX_DOUBLE_MAN5_4 0x7f
#define VAX_DOUBLE_MAN6_5 0xff
#define VAX_DOUBLE_MAN7_6 0xff
#define VAX_DOUBLE_MAN8_7 0xff

#define VAX_DOUBLE_SIGN_RSHIFT VAX_FLOAT_SIGN_RSHIFT
#define VAX_DOUBLE_EXP1_LSHIFT VAX_FLOAT_EXP1_LSHIFT
#define VAX_DOUBLE_EXP2_RSHIFT VAX_FLOAT_EXP2_RSHIFT
#define VAX_DOUBLE_MAN1_LSHIFT VAX_FLOAT_MAN1_LSHIFT
#define VAX_DOUBLE_MAN2_LSHIFT VAX_FLOAT_MAN2_LSHIFT
#define VAX_DOUBLE_MAN3_LSHIFT VAX_FLOAT_MAN3_LSHIFT
#define VAX_DOUBLE_MAN4_RSHIFT 7
#define VAX_DOUBLE_MAN5_LSHIFT 24
#define VAX_DOUBLE_MAN6_LSHIFT 16
#define VAX_DOUBLE_MAN7_LSHIFT 8
#define VAX_DOUBLE_MAN8_LSHIFT 0

#define CRAY_FLOAT_SIGN_0 0x80
#define CRAY_FLOAT_EXP1_0 0x7f
#define CRAY_FLOAT_EXP2_1 0xff
#define CRAY_FLOAT_MAN1_2 0xff
#define CRAY_FLOAT_MAN2_3 0xff
#define CRAY_FLOAT_MAN3_4 0xff
#define CRAY_FLOAT_MAN4_5 0xff
#define CRAY_FLOAT_MAN5_6 0xff
#define CRAY_FLOAT_MAN6_7 0xff

#define CRAY_FLOAT_SIGN_RSHIFT 7
#define CRAY_FLOAT_EXP1_LSHIFT 8
#define CRAY_FLOAT_EXP2_RSHIFT 0
#define CRAY_FLOAT_MAN1_LSHIFT 24
#define CRAY_FLOAT_MAN2_LSHIFT 16
#define CRAY_FLOAT_MAN3_LSHIFT 8
#define CRAY_FLOAT_MAN4_LSHIFT 0
#define CRAY_FLOAT_MAN5_LSHIFT 24
#define CRAY_FLOAT_MAN6_LSHIFT 16

#define VAX_FLOAT_EXCESS  0x81
#define IEEE_FLOAT_EXCESS 0x7f
#define CRAY_FLOAT_EXCESS 0x4001

#define VAX_DOUBLE_EXCESS  0x81
#define IEEE_DOUBLE_EXCESS 0x3ff
#define CRAY_DOUBLE_EXCESS 0x4001


	/*-------------------------------------*
	|       macros
	---------------------------------------*/


/*
 * The following macros are used to convert to and from different data
 * types.
 */

/* 
 * LOAD IEEE FLOAT MACRO 
 */
#define load_ieee_float(tmpin,sign,expo,man1,man2)                            \
       sign = ((unsigned long)*tmpin & (unsigned long)IEEE_FLOAT_SIGN_0) >> (unsigned long)IEEE_FLOAT_SIGN_RSHIFT;         \
       expo = (((*tmpin & IEEE_FLOAT_EXP1_0) << IEEE_FLOAT_EXP1_LSHIFT) |     \
              (((unsigned int)*(tmpin+1) & (unsigned int)IEEE_FLOAT_EXP2_1) >> (unsigned int)IEEE_FLOAT_EXP2_RSHIFT))   \
              - IEEE_FLOAT_EXCESS;                                            \
       man1 = (0x1 << IEEE_FLOAT_MAN0_LSHIFT) |                       \
              ((*(tmpin+1) & IEEE_FLOAT_MAN1_1) << IEEE_FLOAT_MAN1_LSHIFT) |  \
              ((*(tmpin+2) & IEEE_FLOAT_MAN2_2) << IEEE_FLOAT_MAN2_LSHIFT) |  \
              ((*(tmpin+3) & IEEE_FLOAT_MAN3_3) << IEEE_FLOAT_MAN3_LSHIFT);   \
       man2 = 0x0; \
       man1 = (expo == -IEEE_FLOAT_EXCESS && man1 == 0x1 << IEEE_FLOAT_MAN0_LSHIFT && man2 == 0x0) ? 0x0 : man1; \
       expo = (man1 == 0x0 && man2 == 0x0) ? 0 : expo;

/* 
 * UNLOAD IEEE FLOAT MACRO 
 */
#define unload_ieee_float(tmpout,sign,expo,man1,man2)                         \
       tmp1 = (expo == 0 && man1 == 0 && man2 == 0) ? 0 : \
              (unsigned long)(expo + IEEE_FLOAT_EXCESS);                      \
       *tmpout = ((sign << IEEE_FLOAT_SIGN_RSHIFT) & IEEE_FLOAT_SIGN_0) |     \
                 ((tmp1 >> IEEE_FLOAT_EXP1_LSHIFT) & IEEE_FLOAT_EXP1_0);      \
       *(tmpout+1) = ((tmp1 << IEEE_FLOAT_EXP2_RSHIFT) & IEEE_FLOAT_EXP2_1) | \
                     ((man1 >> IEEE_FLOAT_MAN1_LSHIFT) & IEEE_FLOAT_MAN1_1);  \
       *(tmpout+2) = (man1 >> IEEE_FLOAT_MAN2_LSHIFT) & IEEE_FLOAT_MAN2_2;    \
       *(tmpout+3) = (man1 >> IEEE_FLOAT_MAN3_LSHIFT) & IEEE_FLOAT_MAN3_3;

/* 
 * LOAD IEEE DOUBLE MACRO 
 */
#define load_ieee_double(tmpin,sign,expo,man1,man2)                           \
       sign = ((unsigned long)*tmpin & (unsigned long)IEEE_DOUBLE_SIGN_0) >> (unsigned long)IEEE_DOUBLE_SIGN_RSHIFT;       \
       expo = (((*tmpin & IEEE_DOUBLE_EXP1_0) << IEEE_DOUBLE_EXP1_LSHIFT) |   \
              (((unsigned int)*(tmpin+1) & (unsigned int)IEEE_DOUBLE_EXP2_1) >> (unsigned int)IEEE_DOUBLE_EXP2_RSHIFT)) \
              - IEEE_DOUBLE_EXCESS;                                           \
       man1 = (0x1 << IEEE_DOUBLE_MAN0_LSHIFT) |                      \
              ((*(tmpin+1) & IEEE_DOUBLE_MAN1_1) << IEEE_DOUBLE_MAN1_LSHIFT) |\
              ((*(tmpin+2) & IEEE_DOUBLE_MAN2_2) << IEEE_DOUBLE_MAN2_LSHIFT) |\
              ((*(tmpin+3) & IEEE_DOUBLE_MAN3_3) << IEEE_DOUBLE_MAN3_LSHIFT) |\
              ((*(tmpin+4) & IEEE_DOUBLE_MAN4_4) << IEEE_DOUBLE_MAN4_LSHIFT) |\
              ((unsigned long)(*(tmpin+5) & IEEE_DOUBLE_MAN5_5) >> (unsigned long)IEEE_DOUBLE_MAN5_RSHIFT); \
       man2 = ((*(tmpin+5) & IEEE_DOUBLE_MAN6_5) << IEEE_DOUBLE_MAN6_LSHIFT) |\
              ((*(tmpin+6) & IEEE_DOUBLE_MAN7_6) << IEEE_DOUBLE_MAN7_LSHIFT) |\
              ((*(tmpin+7) & IEEE_DOUBLE_MAN8_7) << IEEE_DOUBLE_MAN8_LSHIFT); \
       man1 = (expo == -IEEE_DOUBLE_EXCESS && man1 == 0x1 << IEEE_DOUBLE_MAN0_LSHIFT && man2 == 0x0) ? 0x0 : man1; \
       expo = (man1 == 0x0 && man2 == 0x0) ? 0 : expo;


/* 
 * UNLOAD IEEE DOUBLE MACRO 
 */
#define unload_ieee_double(tmpout,sign,expo,man1,man2)                        \
       tmp1 = (expo == 0 && man1 == 0 && man2 == 0) ? 0 : \
              (unsigned long)(expo + IEEE_DOUBLE_EXCESS);                  \
       *tmpout = ((sign << IEEE_DOUBLE_SIGN_RSHIFT) & IEEE_DOUBLE_SIGN_0) |   \
                 ((tmp1 >> IEEE_DOUBLE_EXP1_LSHIFT) & IEEE_DOUBLE_EXP1_0);    \
       *(tmpout+1) = ((tmp1 << IEEE_DOUBLE_EXP2_RSHIFT) & IEEE_DOUBLE_EXP2_1)|\
                     ((man1 >> IEEE_DOUBLE_MAN1_LSHIFT) & IEEE_DOUBLE_MAN1_1);\
       *(tmpout+2) = (man1 >> IEEE_DOUBLE_MAN2_LSHIFT) & IEEE_DOUBLE_MAN2_2;  \
       *(tmpout+3) = (man1 >> IEEE_DOUBLE_MAN3_LSHIFT) & IEEE_DOUBLE_MAN3_3;  \
       *(tmpout+4) = (man1 >> IEEE_DOUBLE_MAN4_LSHIFT) & IEEE_DOUBLE_MAN4_4;  \
       *(tmpout+5) = ((man1 << IEEE_DOUBLE_MAN5_RSHIFT) & IEEE_DOUBLE_MAN5_5)|\
                     ((man2 >> IEEE_DOUBLE_MAN6_LSHIFT) & IEEE_DOUBLE_MAN6_5);\
       *(tmpout+6) = (man2 >> IEEE_DOUBLE_MAN7_LSHIFT) & IEEE_DOUBLE_MAN7_6;  \
       *(tmpout+7) = (man2 >> IEEE_DOUBLE_MAN8_LSHIFT) & IEEE_DOUBLE_MAN8_7;

/* 
 * LOAD VAX FLOAT MACRO.  Note: there is a kludge in here to deal
 * with the case that the mantissa is set to zero.  However, the kluge
 * never actually happens...
 */
#define load_vax_float(tmpin,sign,expo,man1,man2) \
       sign = ((unsigned long)*tmpin & (unsigned long)VAX_FLOAT_SIGN_0) >> (unsigned long)VAX_FLOAT_SIGN_RSHIFT;          \
       expo = (((*tmpin & VAX_FLOAT_EXP1_0) << VAX_FLOAT_EXP1_LSHIFT) |      \
              (((unsigned int)*(tmpin+1) & (unsigned int)VAX_FLOAT_EXP2_1) >> (unsigned int)VAX_FLOAT_EXP2_RSHIFT))    \
              - VAX_FLOAT_EXCESS; \
       man1 = 0x80000000 | \
              ((*(tmpin+1) & VAX_FLOAT_MAN1_1) << VAX_FLOAT_MAN1_LSHIFT) |   \
              ((*(tmpin+2) & VAX_FLOAT_MAN2_2) << VAX_FLOAT_MAN2_LSHIFT) |   \
              ((*(tmpin+3) & VAX_FLOAT_MAN3_3) << VAX_FLOAT_MAN3_LSHIFT);    \
       man2 = 0x0; \
       man1 = (man1 == 0x80000000 && expo == -VAX_FLOAT_EXCESS) ? 0x0 : man1;\
       expo = (man1 == 0x0) ? 0 : expo;

/* 
 * LOAD VAX DOUBLE MACRO 
 */
#define load_vax_double(tmpin,sign,expo,man1,man2) \
       sign = ((unsigned long)*tmpin & (unsigned long)VAX_DOUBLE_SIGN_0) >> (unsigned long)VAX_DOUBLE_SIGN_RSHIFT;         \
       expo = (((*tmpin & VAX_DOUBLE_EXP1_0) << VAX_DOUBLE_EXP1_LSHIFT) |     \
              (((unsigned int)*(tmpin+1) & (unsigned int)VAX_DOUBLE_EXP2_1) >> (unsigned int)VAX_DOUBLE_EXP2_RSHIFT))   \
              - VAX_DOUBLE_EXCESS;                                            \
       man1 = 0x80000000 |                                                    \
              ((*(tmpin+1) & VAX_DOUBLE_MAN1_1) << VAX_DOUBLE_MAN1_LSHIFT) |  \
              ((*(tmpin+2) & VAX_DOUBLE_MAN2_2) << VAX_DOUBLE_MAN2_LSHIFT) |  \
              ((*(tmpin+3) & VAX_DOUBLE_MAN3_3) << VAX_DOUBLE_MAN3_LSHIFT) |  \
              ((unsigned long)(*(tmpin+4) & VAX_DOUBLE_MAN4_4) >> (unsigned long)VAX_DOUBLE_MAN4_RSHIFT);   \
       man2 = ((*(tmpin+4) & VAX_DOUBLE_MAN5_4) << VAX_DOUBLE_MAN5_LSHIFT) |  \
              ((*(tmpin+5) & VAX_DOUBLE_MAN6_5) << VAX_DOUBLE_MAN6_LSHIFT) |  \
              ((*(tmpin+6) & VAX_DOUBLE_MAN7_6) << VAX_DOUBLE_MAN7_LSHIFT) |  \
              ((*(tmpin+7) & VAX_DOUBLE_MAN8_7) << VAX_DOUBLE_MAN8_LSHIFT); \
       man1 = (man1 == 0x80000000 && man2 == 0x0 &&expo == -VAX_DOUBLE_EXCESS)\
	      ? 0x0 : man1; \
       expo = (man1 == 0x0) ? 0 : expo;

/* 
 * UNLOAD VAX DOUBLE MACRO 
 */
#define unload_vax_double(tmpout,sign,expo,man1,man2) \
       tmp1 = (unsigned long)(expo + VAX_DOUBLE_EXCESS);                      \
       *tmpout = ((sign << VAX_DOUBLE_SIGN_RSHIFT) & VAX_DOUBLE_SIGN_0) |     \
                 ((tmp1 >> VAX_DOUBLE_EXP1_LSHIFT) & VAX_DOUBLE_EXP1_0);      \
       *(tmpout+1) = ((tmp1 << VAX_DOUBLE_EXP2_RSHIFT) & VAX_DOUBLE_EXP2_1) | \
                     ((man1 >> VAX_DOUBLE_MAN1_LSHIFT) & VAX_DOUBLE_MAN1_1);  \
       *(tmpout+2) = (man1 >> VAX_DOUBLE_MAN2_LSHIFT) & VAX_DOUBLE_MAN2_2;    \
       *(tmpout+3) = (man1 >> VAX_DOUBLE_MAN3_LSHIFT) & VAX_DOUBLE_MAN3_3;    \
       *(tmpout+4) = ((man1 << VAX_DOUBLE_MAN4_RSHIFT) & VAX_DOUBLE_MAN4_4) | \
                     ((man2 >> VAX_DOUBLE_MAN5_LSHIFT) & VAX_DOUBLE_MAN5_4);  \
       *(tmpout+5) = (man2 >> VAX_DOUBLE_MAN6_LSHIFT) & VAX_DOUBLE_MAN6_5;    \
       *(tmpout+6) = (man2 >> VAX_DOUBLE_MAN7_LSHIFT) & VAX_DOUBLE_MAN7_6;    \
       *(tmpout+7) = (man2 >> VAX_DOUBLE_MAN8_LSHIFT) & VAX_DOUBLE_MAN8_7;
/* 
 * UNLOAD VAX FLOAT MACRO 
 */
#define unload_vax_float(tmpout,sign,expo,man1,man2) \
       tmp1 = (unsigned long)(expo + VAX_FLOAT_EXCESS);                      \
       *tmpout = ((sign << VAX_FLOAT_SIGN_RSHIFT) & VAX_FLOAT_SIGN_0) |      \
                 ((tmp1 >> VAX_FLOAT_EXP1_LSHIFT) & VAX_FLOAT_EXP1_0);       \
       *(tmpout+1) = ((tmp1 << VAX_FLOAT_EXP2_RSHIFT) & VAX_FLOAT_EXP2_1) |  \
                     ((man1 >> VAX_FLOAT_MAN1_LSHIFT) & VAX_FLOAT_MAN1_1);   \
       *(tmpout+2) = (man1 >> VAX_FLOAT_MAN2_LSHIFT) & VAX_FLOAT_MAN2_2;     \
       *(tmpout+3) = (man1 >> VAX_FLOAT_MAN3_LSHIFT) & VAX_FLOAT_MAN3_3;


/* 
 * LOAD CRAY FLOAT DOUBLE MACRO 
 */
#define load_cray_float(tmpin,sign,expo,man1,man2) \
       sign = ((unsigned long)*tmpin & (unsigned long)CRAY_FLOAT_SIGN_0) >> (unsigned long)CRAY_FLOAT_SIGN_RSHIFT;         \
       expo = (man1 == 0 && man2 == 0) ? 0 :((((*tmpin & CRAY_FLOAT_EXP1_0) << CRAY_FLOAT_EXP1_LSHIFT) |     \
              (((unsigned int)*(tmpin+1) & (unsigned int)CRAY_FLOAT_EXP2_1) >> (unsigned int)CRAY_FLOAT_EXP2_RSHIFT))   \
              - CRAY_FLOAT_EXCESS); \
       man1 = ((*(tmpin+2) & CRAY_FLOAT_MAN1_2) << CRAY_FLOAT_MAN1_LSHIFT) |  \
              ((*(tmpin+3) & CRAY_FLOAT_MAN2_3) << CRAY_FLOAT_MAN2_LSHIFT) |  \
              ((*(tmpin+4) & CRAY_FLOAT_MAN3_4) << CRAY_FLOAT_MAN3_LSHIFT) |  \
              ((*(tmpin+5) & CRAY_FLOAT_MAN4_5) << CRAY_FLOAT_MAN4_LSHIFT);   \
       man2 = ((*(tmpin+6) & CRAY_FLOAT_MAN5_6) << CRAY_FLOAT_MAN5_LSHIFT) |  \
              ((*(tmpin+7) & CRAY_FLOAT_MAN6_7) << CRAY_FLOAT_MAN6_LSHIFT); \
       expo = (man1 == 0x0 && man2 == 0x0) ? 0 : expo;


/* 
 * UNLOAD CRAY DOUBLE MACRO 
 */
#define unload_cray_float(tmpout,sign,expo,man1,man2)                        \
       tmp1 = (expo == 0 && man1 == 0x0 && man2 == 0x0) ? 0 : (unsigned long)(expo + CRAY_FLOAT_EXCESS);                     \
       *tmpout = ((sign << CRAY_FLOAT_SIGN_RSHIFT) & CRAY_FLOAT_SIGN_0) |    \
                 ((tmp1 >> CRAY_FLOAT_EXP1_LSHIFT) & CRAY_FLOAT_EXP1_0);     \
       *(tmpout+1) = tmp1 & CRAY_FLOAT_EXP2_1;                               \
       *(tmpout+2) = (man1 >> CRAY_FLOAT_MAN1_LSHIFT) & CRAY_FLOAT_MAN1_2;   \
       *(tmpout+3) = (man1 >> CRAY_FLOAT_MAN2_LSHIFT) & CRAY_FLOAT_MAN2_3;   \
       *(tmpout+4) = (man1 >> CRAY_FLOAT_MAN3_LSHIFT) & CRAY_FLOAT_MAN3_4;   \
       *(tmpout+5) = man1 & CRAY_FLOAT_MAN4_5;                               \
       *(tmpout+6) = (man2 >> CRAY_FLOAT_MAN5_LSHIFT) & CRAY_FLOAT_MAN5_6;   \
       *(tmpout+7) = (man2 >> CRAY_FLOAT_MAN6_LSHIFT) & CRAY_FLOAT_MAN6_7;
       

/* 
 * LOAD CRAY DOUBLE MACRO 
 */
#define load_cray_double(tmpin,sign,expo,man1,man2) \
       load_cray_float(tmpin,sign,expo,man1,man2)

/* 
 * UNLOAD CRAY DOUBLE MACRO 
 */
#define unload_cray_double(tmpout,sign,expo,man1,man2) \
       unload_cray_float(tmpout,sign,expo,man1,man2)

/*
 * MACRO TO SCREW WITH VAX ORDERING
 */
#define diddle_vax_float(tmpvar) \
    c = *tmpvar; *tmpvar = *(tmpvar+2); *(tmpvar+2) = c; \
    c = *(tmpvar+1); *(tmpvar+1) = *(tmpvar+3); *(tmpvar+3) = c;

/*
 * MACRO TO SCREW WITH VAX ORDERING
 */
#define diddle_vax_double(tmpvar) \
    c = *tmpvar; *tmpvar = *(tmpvar+6); *(tmpvar+6) = c; \
    c = *(tmpvar+1); *(tmpvar+1) = *(tmpvar+7); *(tmpvar+7) = c;\
    c = *(tmpvar+2); *(tmpvar+2) = *(tmpvar+4); *(tmpvar+4) = c;\
    c = *(tmpvar+3); *(tmpvar+3) = *(tmpvar+5); *(tmpvar+5) = c;
   
#endif /* _kutils_convert_h_ */
/* Don't add after this point */
