 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */


%{
#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>    Private Khoros Expression Grammar (yacc) Routines
   >>>>
   >>>>  Private:
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"
static int        num_args;
static SymbolList *symlist;

%}

%union {
	double     value;
	char       *string;
	Symbol     *symbol;
	SymbolList *symlist;
}

%token  <string>   STRING PRINTF
%token  <value>    NUMBER OPERATOR UOPERATOR INSTRUCTION
%token  <symbol>   VARIABLE EXPRESSION FUNCTION UFUNCTION EVALUATE
		   CONSTANT UNDEFINED

%type   <symlist>  expr sexpr arglist str_or_expr var_or_const
%type	<symbol>   assign

%right 	';' '?' ':' '=' AADD ASUB AMUL ADIV AOR AAND AXOR ASL ASR STRCAT
	IF THEN ELSE
%left	OR
%left	AND
%left	NE LT LE GT GE EQ INCREMENT DECREMENT
%left 	'+' '-'
%left	'*' '/'
%left	'|' '&' '%' '^' SL SR
%left	UMINUS CINT CFLOAT CSTRING '~' '!'
%right 	POW
%%

list:   list_types
	| list ';'
	| list ';' list
	| list ';' error
	  {
	     yyerrok;
	  }
	;

list_types:
	| expr
	  {
	     kexpr_eval_symlist($1, TRUE, &FinalValue);
	     kexpr_free_symlist($1);
	  }
	| sexpr
	  {
	     kexpr_eval_symlist($1, TRUE, &FinalValue);
	     kexpr_free_symlist($1);
	  }
	| assign
	  {
	     if ($1->type != UFUNCTION) kexpr_check_variable($1);
	     kexpr_eval_symbol($1, FALSE, &FinalValue);
	     CompiledSymbol = $1;
	  }
	;

assign:	  VARIABLE '=' expr
	  {
	     kexpr_free_symbol($1);
	     $$->symlist = $1->symlist = $3;
	  }
	| VARIABLE ':' '=' expr
	  {
	     kexpr_eval_symlist($4, TRUE, &FinalValue);
	     kexpr_free_symlist($4);
	     $$->Value = $1->Value = FinalValue.Value;
	  }
	| VARIABLE ':' expr '=' expr
	  {
	     kexpr_eval_symlist($3, TRUE, &FinalValue);
	     kexpr_free_symlist($3);
	     $$->Value = $1->Value = FinalValue.Value;
	     kexpr_free_symbol($1);
	     $$->symlist = $1->symlist = $5;
	  }
	| VARIABLE '=' assign
	  {
	     kexpr_free_symbol($1);
	     $$->symlist = $1->symlist = kexpr_copy_symlist($3->symlist);
	     kexpr_check_variable($3);
	     kexpr_eval_symbol($3, FALSE, &FinalValue);
	  }
	| FUNCTION '(' arglist ')' '=' expr
	  {
	     char error[KLENGTH];

	     /*
	      *  Don't allow the user to redefine a predefined function,
	      *  such as cos().  Only allow them to change or add user
	      *  defined functions.
	      */
	     if ($1->type == FUNCTION)
	     {
		sprintf(error,"Error!  '%s' is pre-defined function not a user \
defined one.\nYou are only allowed to define or change user defined functions.",
			$1->name);
		kexpr_error(error);
	     }

	     /*
	      *  Change the type to be a user defined function.  Also, since
	      *  this is a user defined function we need to change the function
	      *  argument variables.
	      *
	      *  (see kexpr_check_function() for more details).
	      */
	     kexpr_free_symbol($1);
	     $1->type = UFUNCTION;
	     kexpr_check_function($1, $3, $6);
	     $$->symlist = $1->symlist = kexpr_add_symlist($3, $6);
	  }
	| VARIABLE AADD expr
	  {
	     if ($1->type == UNDEFINED)
	     {
		kexpr_delete_symbol(current_id, $1);
	        kexpr_error("Undefined variable");
	     }
	     symlist = kexpr_add_operator(NULL, '+', "+", OPERATOR);
	     symlist = kexpr_add_symlist(symlist, $1->symlist);
	     symlist = kexpr_add_symlist(symlist, $3);
	     $$->symlist = $1->symlist = symlist;
	  }
	| VARIABLE ASUB expr
	  {
	     if ($1->type == UNDEFINED)
	     {
		kexpr_delete_symbol(current_id, $1);
	        kexpr_error("Undefined variable");
	     }
	     symlist = kexpr_add_operator(NULL, '-', "-", OPERATOR);
	     symlist = kexpr_add_symlist(symlist, $1->symlist);
	     symlist = kexpr_add_symlist(symlist, $3);
	     $$->symlist = $1->symlist = symlist;
	  }
	| VARIABLE INCREMENT
	  {
	     if ($1->type == UNDEFINED)
	     {
		kexpr_delete_symbol(current_id, $1);
	        kexpr_error("Undefined variable");
	     }
	     symlist = kexpr_add_operator(NULL, '+', "+", OPERATOR);
	     symlist = kexpr_add_symlist(symlist, $1->symlist);
	     symlist = kexpr_add_number(symlist, 1.0);
	     $$->symlist = $1->symlist = symlist;
	  }
	| VARIABLE DECREMENT
	  {
	     if ($1->type == UNDEFINED)
	     {
		kexpr_delete_symbol(current_id, $1);
	        kexpr_error("Undefined variable");
	     }
	     symlist = kexpr_add_operator(NULL, '-', "-", OPERATOR);
	     symlist = kexpr_add_symlist(symlist, $1->symlist);
	     symlist = kexpr_add_number(symlist, 1.0);
	     $$->symlist = $1->symlist = symlist;
	  }
	| VARIABLE AMUL expr
	  {
	     if ($1->type == UNDEFINED)
	     {
		kexpr_delete_symbol(current_id, $1);
	        kexpr_error("Undefined variable");
	     }
	     symlist = kexpr_add_operator(NULL, '*', "*", OPERATOR);
	     symlist = kexpr_add_symlist(symlist, $1->symlist);
	     symlist = kexpr_add_symlist(symlist, $3);
	     $$->symlist = $1->symlist = symlist;
	  }
	| VARIABLE ADIV expr
	  {
	     if ($1->type == UNDEFINED)
	     {
		kexpr_delete_symbol(current_id, $1);
	        kexpr_error("Undefined variable");
	     }
	     symlist = kexpr_add_operator(NULL, '/', "/", OPERATOR);
	     symlist = kexpr_add_symlist(symlist, $1->symlist);
	     symlist = kexpr_add_symlist(symlist, $3);
	     $$->symlist = $1->symlist = symlist;
	  }
	| VARIABLE AOR expr
	  {
	     if ($1->type == UNDEFINED)
	     {
		kexpr_delete_symbol(current_id, $1);
	        kexpr_error("Undefined variable");
	     }
	     symlist = kexpr_add_operator(NULL, OR, "||", OPERATOR);
	     symlist = kexpr_add_symlist(symlist, $1->symlist);
	     symlist = kexpr_add_symlist(symlist, $3);
	     $$->symlist = $1->symlist = symlist;
	  }
	| VARIABLE AAND expr
	  {
	     if ($1->type == UNDEFINED)
	     {
		kexpr_delete_symbol(current_id, $1);
	        kexpr_error("Undefined variable");
	     }
	     symlist = kexpr_add_operator(NULL, AND, "&&", OPERATOR);
	     symlist = kexpr_add_symlist(symlist, $1->symlist);
	     symlist = kexpr_add_symlist(symlist, $3);
	     $$->symlist = $1->symlist = symlist;
	  }
	| VARIABLE AXOR expr
	  {
	     if ($1->type == UNDEFINED)
	     {
		kexpr_delete_symbol(current_id, $1);
	        kexpr_error("Undefined variable");
	     }
	     symlist = kexpr_add_operator(NULL, '-', "-", OPERATOR);
	     symlist = kexpr_add_symlist(symlist, $1->symlist);
	     symlist = kexpr_add_symlist(symlist, $3);
	     $$->symlist = $1->symlist = symlist;
	  }
	| VARIABLE ASL expr
	  {
	     if ($1->type == UNDEFINED)
	     {
		kexpr_delete_symbol(current_id, $1);
	        kexpr_error("Undefined variable");
	     }
	     symlist = kexpr_add_operator(NULL, SL, "<<", OPERATOR);
	     symlist = kexpr_add_symlist(symlist, $1->symlist);
	     symlist = kexpr_add_symlist(symlist, $3);
	     $$->symlist = $1->symlist = symlist;
	  }
	| VARIABLE ASR expr
	  {
	     if ($1->type == UNDEFINED)
	     {
		kexpr_delete_symbol(current_id, $1);
	        kexpr_error("Undefined variable");
	     }
	     symlist = kexpr_add_operator(NULL, SR, ">>", OPERATOR);
	     symlist = kexpr_add_symlist(symlist, $1->symlist);
	     symlist = kexpr_add_symlist(symlist, $3);
	     $$->symlist = $1->symlist = symlist;
	  }
	;

str_or_expr:    STRING
          {
             $$ = kexpr_add_string(NULL, $1);
          }
        | EXPRESSION
          {
             $$ = kexpr_add_variable(NULL, $1);
          }
        | PRINTF '(' STRING ',' arglist ')'
          {
             $$ = kexpr_add_operator(NULL, PRINTF, "printf", OPERATOR);
             $$ = kexpr_add_string($$, $3);
             $$ = kexpr_add_symlist($$, $5);
          }
        ;
 
sexpr:  str_or_expr
        | sexpr str_or_expr
          {
             $$ = kexpr_add_operator(NULL, STRCAT, "", OPERATOR);
             $$ = kexpr_add_symlist($$, $1);
             $$ = kexpr_add_symlist($$, $2);
          }
        ;

var_or_const: VARIABLE
	  {
	     $$ = kexpr_add_variable(NULL, $1);
	  }
	| CONSTANT
	  {
	     if ($1->type == UNDEFINED)
	     {
		kexpr_delete_symbol(current_id, $1);
		kexpr_error("Undefined constant");
	     }
	     $$ = kexpr_add_variable(NULL, $1);
	  }
	;
	  
expr:     var_or_const
	| NUMBER
	  {
	     $$ = kexpr_add_number(NULL, $1);
	  }
	| NUMBER var_or_const %prec '*'
	  {
	     $$ = kexpr_add_operator(NULL, '*', "*", OPERATOR);
	     $$ = kexpr_add_number($$, $1);
	     $$ = kexpr_add_symlist($$, $2);
	  }
	| IF '(' expr ')' expr ELSE expr
	  {
	     $$ = kexpr_add_instruction(NULL, IF, "if", 3);
	     $$ = kexpr_add_symlist($$, $3);
	     $$ = kexpr_add_symlist($$, $5);
	     $$ = kexpr_add_symlist($$, $7);
	  }
	| expr '?' expr ':' expr
	  {
	     $$ = kexpr_add_instruction(NULL, IF, "if", 3);
	     $$ = kexpr_add_symlist($$, $1);
	     $$ = kexpr_add_symlist($$, $3);
	     $$ = kexpr_add_symlist($$, $5);
	  }
	| EVALUATE '(' expr ')'
	  {
	     Symbol temp;

	     kexpr_eval_symlist($3, TRUE, &temp);
	     if (temp.type == NUMBER)
	        $$ = kexpr_add_number(NULL, temp.Value);
	     else
		kexpr_error("Can only evaluate numerical expressions");
	  }
	| FUNCTION '(' arglist ')'
	  {
	     $$ = kexpr_add_function(NULL, $1, num_args);
	     $$ = kexpr_add_symlist($$, $3);
	  }
	| expr AND expr
	  {
	     $$ = kexpr_add_operator(NULL, AND, "&&", OPERATOR);
	     $$ = kexpr_add_symlist($$, $1);
	     $$ = kexpr_add_symlist($$, $3);
	  }
	| expr OR  expr
	  {
	     $$ = kexpr_add_operator(NULL, OR, "||", OPERATOR);
	     $$ = kexpr_add_symlist($$, $1);
	     $$ = kexpr_add_symlist($$, $3);
	  }
	| expr EQ  expr
	  {
	     $$ = kexpr_add_operator(NULL, EQ, "==", OPERATOR);
	     $$ = kexpr_add_symlist($$, $1);
	     $$ = kexpr_add_symlist($$, $3);
	  }
	| expr NE  expr
	  {
	     $$ = kexpr_add_operator(NULL, NE, "!=", OPERATOR);
	     $$ = kexpr_add_symlist($$, $1);
	     $$ = kexpr_add_symlist($$, $3);
	  }
	| expr LE  expr
	  {
	     $$ = kexpr_add_operator(NULL, LE, "<=", OPERATOR);
	     $$ = kexpr_add_symlist($$, $1);
	     $$ = kexpr_add_symlist($$, $3);
	  }
	| expr GE  expr
	  {
	     $$ = kexpr_add_operator(NULL, GE, ">=", OPERATOR);
	     $$ = kexpr_add_symlist($$, $1);
	     $$ = kexpr_add_symlist($$, $3);
	  }
	| expr LT  expr
	  {
	     $$ = kexpr_add_operator(NULL, LT, "<", OPERATOR);
	     $$ = kexpr_add_symlist($$, $1);
	     $$ = kexpr_add_symlist($$, $3);
	  }
	| expr GT  expr
	  {
	     $$ = kexpr_add_operator(NULL, GT, ">", OPERATOR);
	     $$ = kexpr_add_symlist($$, $1);
	     $$ = kexpr_add_symlist($$, $3);
	  }
	| expr '+' expr
	  {
	     $$ = kexpr_add_operator(NULL, '+', "+", OPERATOR);
	     $$ = kexpr_add_symlist($$, $1);
	     $$ = kexpr_add_symlist($$, $3);
	  }
	| expr '-' expr
	  {
	     $$ = kexpr_add_operator(NULL, '-', "-", OPERATOR);
	     $$ = kexpr_add_symlist($$, $1);
	     $$ = kexpr_add_symlist($$, $3);
	  }
	| expr '*' expr
	  {
	     $$ = kexpr_add_operator(NULL, '*', "*", OPERATOR);
	     $$ = kexpr_add_symlist($$, $1);
	     $$ = kexpr_add_symlist($$, $3);
	  }
	| expr '/' expr
	  {
	     $$ = kexpr_add_operator(NULL, '/', "/", OPERATOR);
	     $$ = kexpr_add_symlist($$, $1);
	     $$ = kexpr_add_symlist($$, $3);
	  }
	| expr POW expr
	  {
	     $$ = kexpr_add_operator(NULL, POW, "--", OPERATOR);
	     $$ = kexpr_add_symlist($$, $1);
	     $$ = kexpr_add_symlist($$, $3);
	  }
	| expr '%' expr
	  {
	     $$ = kexpr_add_operator(NULL, '%', "%", OPERATOR);
	     $$ = kexpr_add_symlist($$, $1);
	     $$ = kexpr_add_symlist($$, $3);
	  }
	| expr '&' expr
	  {
	     $$ = kexpr_add_operator(NULL, '&', "&", OPERATOR);
	     $$ = kexpr_add_symlist($$, $1);
	     $$ = kexpr_add_symlist($$, $3);
	  }
	| expr '|' expr
	  {
	     $$ = kexpr_add_operator(NULL, '|', "|", OPERATOR);
	     $$ = kexpr_add_symlist($$, $1);
	     $$ = kexpr_add_symlist($$, $3);
	  }
	| expr '^' expr
	  {
	     $$ = kexpr_add_operator(NULL, '^', "^", OPERATOR);
	     $$ = kexpr_add_symlist($$, $1);
	     $$ = kexpr_add_symlist($$, $3);
	  }
	| expr SL expr
	  {
	     $$ = kexpr_add_operator(NULL, SL, "<<", OPERATOR);
	     $$ = kexpr_add_symlist($$, $1);
	     $$ = kexpr_add_symlist($$, $3);
	  }
	| expr SR expr
	  {
	     $$ = kexpr_add_operator(NULL, SR, ">>", OPERATOR);
	     $$ = kexpr_add_symlist($$, $1);
	     $$ = kexpr_add_symlist($$, $3);
	  }
	| '~' expr
	  {
	     $$ = kexpr_add_operator(NULL, '~', "~", UOPERATOR);
	     $$ = kexpr_add_symlist($$, $2);
	  }
	| CINT expr
	  {
	     $$ = kexpr_add_operator(NULL, CINT, "(int)", UOPERATOR);
	     $$ = kexpr_add_symlist($$, $2);
	  }
	| CFLOAT expr
	  {
	     $$ = kexpr_add_operator(NULL, CFLOAT, "(float)", UOPERATOR);
	     $$ = kexpr_add_symlist($$, $2);
	  }
	| CSTRING expr
	  {
	     $$ = kexpr_add_operator(NULL, CSTRING, "(string)", UOPERATOR);
	     $$ = kexpr_add_symlist($$, $2);
	  }
	| '!' expr
	  {
	     $$ = kexpr_add_operator(NULL, '!', "!", UOPERATOR);
	     $$ = kexpr_add_symlist($$, $2);
	  }
	| '(' expr ')'
	  {
	     $$ = $2;
	  }
	| '-' expr %prec UMINUS
	  {
	     $$ = kexpr_add_operator(NULL, UMINUS, "-", UOPERATOR);
	     $$ = kexpr_add_symlist($$, $2);
	  }
	;

arglist:  {
	     num_args = 0;
	     $$ = NULL;
	  }

	| expr
	  {
	     num_args = 1;
	     $$ = kexpr_add_symlist(NULL, $1);
	  }

	| expr ',' arglist
	  {
	     num_args += 1;
	     $$ = kexpr_add_symlist(NULL, $1);
	     $$ = kexpr_add_symlist($$, $3);
	  }
	;

%%
