 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */



%{

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>      Private Khoros Expression Lexical Analyzer Routines
   >>>>
   >>>>  Private:
   >>>>		     kexpr_set_value()
   >>>>		     kexpr_set_string()
   >>>>
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"
#include "y.tab.h"

#undef output
#define output(charval) (kprintf("unrecognized character: %c\n", charval))

/*
#undef input
#define input() (*sptr++)
 */
#if !defined(__bsdi__) && !defined(FLEX_SCANNER)
#undef  input
#define input()  (*sptr++)
#else
#undef YY_INPUT
#define YY_INPUT(buf, result, max_size) \
(result = (*sptr == '\0') ? 0 : (buf[0] = *sptr++, 1))
#endif
 
#undef  unput
#define unput(c) ((*--sptr)=(char)(c))

extern YYSTYPE yylval;
%}

%o 5000
%a 3000

S	[ \t\n]*
B	[a-zA-Z][a-zA-Z0-9_]*
D	[0-9]
E	[Ee][-+]?{D}+

%START vrules srules

%%

<srules>"=" {
           return('=');
        }

<srules>"printf"/{S}"(" {
	   return(PRINTF);
	}

<srules>.  {
	   char     token[512];
	   register int c, i = 0;

	   if (yytext[0] == '$')
	   {
	      for (;;)
	      {
	         c = input();
	         if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' &&
		     c <= '9' || c == '_')
	         {
		    token[i++] = c;
	         }
	         else
	         {
		    token[i] = '\0';
		    unput(c); break;
	         }
	      }
	      yylval.symbol = kexpr_get_constant(token);
	      if (yylval.symbol->type == UNDEFINED ||
	          yylval.symbol->type == EXPRESSION ||
	          yylval.symbol->type == VARIABLE)
	      {
	         return(EXPRESSION);
	      }
	      else
	         return(yylval.symbol->type);
	   }
	   else
	   {
	      token[i++] = yytext[0];
	      for (;;)
	      {
	         c = input();
	         if (c != '\0' && c != '$')
	         {
		    token[i++] = c;
	         }
	         else
	         {
		    token[i] = '\0';
		    unput(c); break;
	         }
	      }
	      yylval.string = kstrdup(token);
	      return(STRING);
	   }
	}

<vrules>"#".*		 { ; }  /* skip everything after a csh style comment */
<vrules>"/*"	{	        /* skip everything inside a C style comment */
	   register int c;
	   for (;;)
	   {
	      while ((c = input()) != '*' && c != EOF && c != '\0')
				;
	      if (c == '*')
	      {
	         if ((c = input()) == '/')
		    break;
	      }
	      else
		 break;
	   }
	}

"++"	{ return(INCREMENT); }
"--"	{ return(DECREMENT); }
"<<"	{ return(SL); }
">>"	{ return(SR); }
"=="	{ return(EQ); }
"!="	{ return(NE); }
"<="	{ return(LE); }
">="	{ return(GE); }
".GT."	{ return(GT); }
".LT."	{ return(LT); }
".EQ."	{ return(EQ); }
".LE."	{ return(LE); }
".GE."	{ return(GE); }
".NE."	{ return(NE); }
"**"	{ return(POW); }
"<"	{ return(LT); }
">"	{ return(GT); }
"("	{ return('('); }
")"	{ return(')'); }
","	{ return(','); }
";"	{ return(';'); }
"="	{ return('='); }
"+"	{ return('+'); }
"-"	{ return('-'); }
"*"	{ return('*'); }
"/"	{ return('/'); }
"~"	{ return('~'); }
"!"	{ return('!'); }
"%"	{ return('%'); }
"&"	{ return('&'); }
"^"	{ return('^'); }
"|"	{ return('|'); }
"&&"	{ return(AND); }
".AND."	{ return(AND); }
"||"	{ return(OR); }
".OR."	{ return(OR); }
"+="	{ return(AADD); }
"-="	{ return(ASUB); }
"*="	{ return(AMUL); }
"/="	{ return(ADIV); }
"|="	{ return(AOR); }
"&="	{ return(AAND); }
"^="	{ return(AXOR); }
"<<="	{ return(ASL); }
">>="	{ return(ASR); }
":"	{ return(':'); }
"?"	{ return('?'); }
"IF"	{ return(IF); }
"if"	{ return(IF); }
"THEN"	{ return(THEN); }
"then"	{ return(THEN); }
"ELSE"	{ return(ELSE); }
"else"	{ return(ELSE); }
""	{ return('\0'); }


<vrules>{S}		 { ; }	/* skip blanks and tabs */

<vrules>{D}+		  |
<vrules>{D}+"."{D}*({E})? |
<vrules>{D}*"."{D}+({E})? |
<vrules>{D}+{E} {
	   yylval.value = atof(yytext);
	   return(NUMBER);
	}

<vrules>{B}/{S}"=" {
	   yylval.symbol = kexpr_get_variable(yytext, TRUE);
	   return(VARIABLE);
	}

<vrules>"eval"/{S}"(" {
	   return(EVALUATE);
	}

<vrules>{B}/"(" {
	   yylval.symbol = kexpr_get_function(yytext);
	   return(FUNCTION);
	}

<vrules>{B} {
	   yylval.symbol = kexpr_get_constant(yytext);
	   if (yylval.symbol->type == UNDEFINED ||
	       yylval.symbol->type == EXPRESSION)
	   {
	      return(VARIABLE);
	   }
	   else
	      return(yylval.symbol->type);
	}

<vrules>"("{S}"int"{S}")" {
	   return(CINT);
	}

<vrules>"("{S}"float"{S}")" {
	   return(CFLOAT);
	}

<vrules>"("{S}"string"{S}")" {
	   return(CSTRING);
	}

%%

/*-----------------------------------------------------------
|
|  Routine Name: kexpr_set_value - set value rules
|
|       Purpose: kexpr_set_value() - indicates that the lex value rules
|		 should be used instead of the string lex rules.
|
|         Input: None
|
|        Output: None, except that all future calls to parsing will
|		 use the numerical value lex rules.
|
|    Written By: Mark Young  
|          Date: Thu Jun 25 1992
| Modifications:
|
------------------------------------------------------------*/


void kexpr_set_value(void)
{
	BEGIN vrules;
	CompiledSymbol   = NULL;
	FinalValue.Value = 0.0;
}

/*-----------------------------------------------------------
|
|  Routine Name: kexpr_set_string - set string rules
|
|       Purpose: kexpr_set_string() - indicates that the lex string
|		 manipulation rules should be used instead of the
|		 numerical value lex rules.
|
|         Input: None
|
|        Output: None, except that all future calls to parsing will
|		 use the string manipulation lex rules.
|
|    Written By: Mark Young  
|          Date: Thu Jun 25 1992
| Modifications:
|
------------------------------------------------------------*/


void kexpr_set_string(void)
{
	BEGIN srules;
}
