/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>   Routines to generate online help file (*.hlp)       <<<<
   >>>>                                                       <<<<
   >>>>   Static:                                             <<<<
   >>>>  Private:                                             <<<<
   >>>>                kgen_clui_generate_helpfile()          <<<<
   >>>>   Public:                                             <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"


/*---------------------------------------------------------------
|
|  Routine Name: kgen_clui_generate_helpfile
|
|       Purpose: Creates the help file 
|
|         Input: program   - program object being created
|                prog_spec -  pointer to the internal PS struct
|                opath     -  path to program object being created
|                tbname   -  toolbox passed in by user
|                oname     -  name of program object being generated
|
|        Output: Returns TRUE on success, FALSE on failure
|    Written By: Danielle Argiro 
|          Date: Jan 14, 1993 14:58
| Modifications:
--------------------------------------------------------------*/

int  kgen_clui_generate_helpfile(
   kobject   program,
   char    **prog_spec,
   char     *opath,
   char     *tbname,
   char     *oname)
{
        kstring   routine           = "kgen_clui_generate_helpfile()";
	kobject   file_object       = NULL;
	kstring   short_description = NULL;
	int       force_flag        = FALSE;
	int       isnewfile         = FALSE;
	kobject   toolbox;
	kfile     *file;
	char      fullpath[KLENGTH];
	char      directory[KLENGTH];
	char      *copyright;
	char      *filepath;
	char      temp[KLENGTH];

	/*
         * get file object representing help page
         */
	if (!kcms_get_attributes(program,
				 KCMS_PARENT,           &toolbox,
				 KCMS_CMOBJ_GEN_HELP,   &file_object,
				 KCMS_CMOBJ_SHORT_DESC, &short_description,
				 KCMS_END)
	    || !kcms_query_bit(program, KCMS_CMOBJ_FLAGS, KCMS_BIT_CMOBJ_FORCE,
			       &force_flag))
	    return(FALSE);

        /*
         * 1st time *.hlp file has been created - create file object, so 
         * that kcms registers the help page in the kcms database
         */
	if (file_object == NULL)
        {
            ksprintf(temp, "%s/help/%s.hlp", opath, oname);
            file_object = kcms_create_fileobj(program, temp, NULL,
                                               KCMS_FOBJ_TYPE_HELP,
                                               KCMS_FOBJ_SUBTYPE_HELP,
                                               KCMS_FOBJ_GEN_HELP,
                                               KCMS_FOBJ_ACCESS_RDWR);
            if (file_object == NULL)
                return(FALSE);
            isnewfile = TRUE;
            filepath = temp;
        }

	/*
	 * the *.hlp file has already been created & added to program database;
         * simply get the path to the help page.
	 */
	 else if (!kcms_get_attribute(file_object, KCMS_PATH, &filepath))
                return(FALSE);

        /*
         *  if somehow the database GHOST_HELP key got deleted from the kcms
         *  database, but the man1 file really is there, don't want to
         *  clobber it!
         */
         if ((isnewfile) && (kaccess(filepath, R_OK) == 0))
         {
             kerror(KCODEGEN, routine,
                    "WARNING!  CMS database appears to have been corrupted; cms dbm key GHOST_HELP is missing, but the %s.hlp file does exist.  Regeneration of help file will NOT take place. Adding GHOST_HELP cms key to database; next run of ghostwriter should be OK.", oname);
	     return(FALSE);
         }

	/*
	 * get the directory to the help file.  if the directory does
         * not exist, it will get created by kmake_dir();  if kmake_dir()
         * cannot create it, it will return the ENOENT error.  
	 */
	(void) kdirname(filepath, directory);
	if (!kmake_dir(directory, 0777) && errno != ENOENT)
	{
	     kerror(KCODEGEN, routine,
		    "Can't create directory %s in which to deposit help file", 
		    directory);
	     return(FALSE);
	}
     	if (kfullpath(filepath, NULL, fullpath) == NULL)
	    return(FALSE);
	
	/*
	 *  see if help file already exists.  If so, prompt to over-write,
	 *  return TRUE if the answer is NO
	 */
	if (force_flag == FALSE &&
	    koverwrite(kget_notify(), filepath) == FALSE)
	    return(TRUE);
	
	/*
	 *  create & open help file  
	 */
	if ((file = kfopen(fullpath, "w"))== NULL)
	{
	     kerror(KCODEGEN, routine,
	            "Could not create file '%s'", fullpath);
	     return(FALSE);
	}
	
	/* 
	 * print out name and short description 
	 */
	kfprintf(file, ".section 1 PROGRAM\n");
	kfprintf(file, "%s \\- ", oname);

	if (short_description != NULL)
	   kfprintf(file, "%s\n", short_description);
	else
	   kfprintf(file, "\n");
	
	
	/* 
	 * print out description
	 */
	kfprintf(file, ".section 1 DESCRIPTION\n");
	if (kstrlen(prog_spec[MAN1_LONGDESC]) > 0) 
	    kfprintf(file, "%s\n", prog_spec[MAN1_LONGDESC]);
	
	/*
	 * print out pane arguments
	 */
	kfprintf(file, ".section 1 \"PANE ARGUMENTS\"\n");
	kfprintf(file, ".syntax %s %s\n", tbname, oname);
	
	/* 
	 * print out examples
	 */
	kfprintf(file, ".section 1 EXAMPLES\n");
	if (kstrlen(prog_spec[MAN1_EXAMPLES]) > 0) 
	    kfprintf(file, "%s\n", prog_spec[MAN1_EXAMPLES]);
	
	/* 
	 * print see also
	 */
	kfprintf(file, ".section 1 \"SEE ALSO\"\n");
	if (kstrlen(prog_spec[MAN1_SEEALSO]) > 0) 
	   kfprintf(file, "%s\n", prog_spec[MAN1_SEEALSO]);
	
	/* 
	 * print out restrictions
	 */
	kfprintf(file, ".section 1 RESTRICTIONS \n");
	if (kstrlen(prog_spec[MAN1_RESTRICTIONS]) > 0) 
	    kfprintf(file, "%s\n", prog_spec[MAN1_RESTRICTIONS]);

	/*
	 * print out references
	 */
	kfprintf(file, ".section 1 REFERENCES \n");
	if (kstrlen(prog_spec[MAN1_REFERENCES]) > 0) 
	    kfprintf(file, "%s\n", prog_spec[MAN1_REFERENCES]);
	
	/* 
	 * print copyright
	 */
	kfprintf (file, ".section 1 COPYRIGHT\n");
	copyright = kcms_get_copyright(toolbox, KCMS_TB_COPYRIGHT_SHORT,
				       KCMS_LANG_NONE);
	if (copyright != NULL) 
	    kfprintf(file, "%s\n", copyright);
	kfree(copyright);
	
	/*
	 *  that's the end...
	 */
	kfclose(file);
 	kannounce(KCODEGEN, routine, "done generating %s help page", oname);
	kinfo(KHOSTILE, "your %s help page is even worse than the man page!",
	      oname);
	return(TRUE);
}
