/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>      CLUI Pane Information Extraction Routine         <<<<
   >>>>                                                       <<<<
   >>>>  Private:                                             <<<<
   >>>>		kgen_clui_get_pane_info()		      <<<<
   >>>>                                                       <<<<
   >>>>   Static:                                             <<<<
   >>>>         save_sel_list_info()                          <<<<
   >>>>         save_toggle_info()                            <<<<
   >>>>   Public:                                             <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"

static int  save_sel_list_info PROTO((kselection *));

/*-------------------------------------------------------------
|
|  Routine Name: kgen_clui_get_pane_info
|
|       Purpose: This routine gets argument information from the 
|		 UIS provided in the *.pane file.
|
|		 It fills out the global kgen_req_args[] and 
|		 global kgen_opt_args[] int arrays with the UIS lines of those 
|		 selections that are required and optional, respectively.
|
|		 It sets global variables kgen_req_num and kgen_opt_num with
|		 the size of each array, respectively.  
|
|		 If there are mutually exclusive groups on the pane, it
|		 sets up the global array of linked lists of mutually 
|		 exclusive selections, one linked list per mutually exclusive
|		 group.
|
|         Input:  form - pointer to the form tree
|
|	 Output: Returns TRUE on success, FALSE on failure; sets globals:
|		 prog_desc - the program description from (-P) line
|		 req_args  - array of indices of arguments that are required
|		 opt_args  - array of indices of arguments that are optional
|		 num_req   - number of required arguments (size of req_args[])
|		 num_opt   - number of optional arguments (size of opt_args[])
|
|    Written By: Danielle Argiro
|          Date: Thu Jul 23, 1992 10:01
| Modifications: Converted from Khoros 1.0 (DA)
|
--------------------------------------------------------------*/

int kgen_clui_get_pane_info(
   kform *form)
{
	kgen_req_num        = 0;
	kgen_opt_num        = 0;
	kgen_arg_total      = 0;

	if (form == NULL)
	    return(FALSE);

	if (!(kvf_check_for_single_pane(form, "kgen_clui_get_pane_info")))
	    return(FALSE);

	if (!(save_sel_list_info(form->subform->guide->pane->sel_list)))
	    return(FALSE);
 
	kgen_arg_total = kgen_req_num + kgen_opt_num;

	return(TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: save_sel_list_info 
|
|       Purpose: Creates global arrays of pointers to selections,
|                one of optional selections and one of required selections,
|                so ghostwriter can first deal with all required
|                arguments, and then with all optional arguments.
|
|         Input: sel_list - pointer to header of selection list
|
|        Output: 
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|    Written By: Danielle Argiro
|          Date: March 30, 1994
| Modifications: 
|
------------------------------------------------------------*/

static int save_sel_list_info(
   kselection *sel_list)
{
	int        optional;
	kselection *selection;

	selection = sel_list;

	while (selection != NULL)
	{
	    switch(selection->type) {

	   	/* 
		 * ignore irrelevant UIS lines 
		 */
	   	case KUIS_QUIT:
	   	case KUIS_ROUTINE:
	   	case KUIS_HELP:
	   	case KUIS_BLANK:
	   	case KUIS_WORKSPACE:
	   	case KUIS_STDIN:
	   	case KUIS_STDOUT:
	   	case KUIS_PANEACTION:
	   	case KUIS_SUBFORMACTION:
	   	case KUIS_STARTSUBMENU:
	   	case KUIS_MASTERACTION:
	   	     break;
     
		/*
	         *  basic arguments: enter UIS line in string array for 
                 *  required args if the UIS says it's required, or the array 
                 *  for optional args if it's optional
	         */
	   	case KUIS_INTEGER:
	   	case KUIS_FLOAT:
	   	case KUIS_DOUBLE:
	   	case KUIS_STRING:
	   	case KUIS_STRINGLIST:
           	case KUIS_INPUTFILE:
	   	case KUIS_OUTPUTFILE:
	   	case KUIS_LOGICAL:
	   	case KUIS_FLAG:
	        case KUIS_TOGGLE:
                case KUIS_LIST:
                case KUIS_DISPLAYLIST:
                case KUIS_CYCLE:
                     kvf_get_attribute(selection->back_kformstruct,
                                       KVF_OPTIONAL, &optional);
                     if (optional)
                         kgen_opt_sels[kgen_opt_num++] = selection;
                     else kgen_req_sels[kgen_req_num++] = selection;
                     break;

	        case KUIS_MUTEXCL:
	        case KUIS_MUTINCL:
	        case KUIS_GROUP:
		     kvf_get_attribute(selection->back_kformstruct,
				       KVF_OPTIONAL, &optional);
		     if (optional)
			 kgen_opt_sels[kgen_opt_num++] = selection;
		     else kgen_req_sels[kgen_req_num++] = selection;
		     break;

	          default:
		     kerror(KCODEGEN, "kgen_clui_get_pane_info",
		           "unidentified line in .pane file");
		     return(FALSE);

	    } /* end switch */

	    selection = selection->next;

	} /* end while */

	return(TRUE);
}
