/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
    >>>>       Library Routine for kcodegen
    >>>> 
    >>>>       Private: 
    >>>>       Static: 
    >>>>       Public: 
    >>>>                kgen_clui_generate
    >>>> 
    >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */
 
#include "internals.h"


/************************************************************
*  Routine Name: kgen_generate_clui - generate code for command line interface
*
*       Purpose: Generates code & documentation for a software object,
*                including the CLUI information structure, code to extract
*                user input from the command line and store it in the CLUI
*                information structure, code to print the usage statement
*                for the program, the skeleton main program, the man page, 
*                the online help page, and so on. 
*
*         Input: object	- software object for which to generate code 
*        Output:
*       Returns: TRUE if successful, FALSE otherwise.
*    Written By: Danielle Argiro and Neil Bowers
*          Date: March 16, 1994
*************************************************************/
int kgen_generate_clui(
   kobject object)
{
        kform     *form = NULL; 
        char      **prog_spec;
	int       genflag;
	kobject   file_object           = NULL;
	int       object_type;
        char      *opath, *uis_filename = NULL; 
	kstring   short_description     = NULL;
	kstring   oname;
	kstring   bname;
	kstring   tbname;
	kstring   form_var = NULL;
	int       hybrid = FALSE, noclui = FALSE;
	kstring   datestamp;


	if (!kcms_get_attributes(object,
				 KCMS_CMOBJ_TYPE,  &object_type,
				 KCMS_NAME,        &oname,
				 KCMS_CMOBJ_BNAME, &bname,
				 KCMS_END)
	    || !kcms_get_indirect_attribute(object, KCMS_PARENT,
					    KCMS_NAME, &tbname))
	   return FALSE;

	/*
	 *  if this is an xvroutine, we'll need the variable after the -F line.
	 *  also, need to determine if it is a hybrid routine.
	 */
	if (object_type == KCMS_XVROUTINE)
	{
	    kcms_get_attribute(object, KCMS_CMOBJ_UIS_FORM, &file_object);
	    if (file_object != NULL)
	    {
                if (!kcms_get_attribute(file_object, KCMS_PATH, &uis_filename)
		    || uis_filename == NULL)
		{
                    return(FALSE);
		}
		if ((form = kvf_create_form(uis_filename,
					    NONE, NULL, NULL)) == NULL)
		   return(FALSE);
	        form_var = ktoken_to_string(form->var_token);
		kvf_destroy_form(form);
	    }
	    else 
	    {
		hybrid = TRUE;
	    }
	}

        /*
         * get the *.pane file, read in the UIS, and create the form tree 
         */
	if (!kcms_get_attribute(object, KCMS_CMOBJ_UIS_PANE, &file_object))
	   return (FALSE);

	if (file_object != NULL)
	{
	   if (!kcms_get_attribute(file_object, KCMS_PATH, &uis_filename)
	       || uis_filename == NULL)
	   {
	      return(FALSE);
	   }

	   form = kvf_create_form(uis_filename, NONE, NULL, NULL);
	   if (form == NULL) return(FALSE);

	   if (!kvf_check_for_single_pane(form, NULL))
	   {
	      kerror(KCODEGEN, "kgen_clui_generate",
		     "%s.pane contains multiple pane and/or multiple "
		     "subform specifications;  however, *.pane files are "
		     "restricted to single pane definitions.  Please "
		     "correct your %s.pane file to specify a single pane "
		     "on a single subform (UIS file syntax: "
		     "-F, -M, -P .... -E, -E, -E).", oname, oname);
	      return(FALSE);
	   }
	}
	else noclui = TRUE;

	if (!noclui)
	{
            if (!(kgen_clui_get_pane_info(form))) 
                return(FALSE);
	}
	else
	{
	   kgen_req_num        = 0;
	   kgen_opt_num        = 0;
	   kgen_arg_total      = 0;
	}

	/*
	 *  get the prog spec from existing files (*.c, *.1, *.h, etc)
	 */
        if (!kcms_get_attributes(object,
				 KCMS_PATH,             &opath,
				 KCMS_CMOBJ_PROGSPEC,   &prog_spec,
				 KCMS_CMOBJ_SHORT_DESC, &short_description,
				 KCMS_END)
	    || prog_spec == NULL)
	{
	    return(FALSE);
	}

        if ((prog_spec[MAN1_LONGDESC] == NULL) && 
            (short_description != NULL) &&
            (kget_notify() == KHOSTILE))
        {
            kinfo(KHOSTILE, "Sorry, but i'm not going to generate code or "
		  "documentation until you write a long object description.");
            return(TRUE);
        }
        else if ((prog_spec[MAN1_LONGDESC] != NULL) &&
                 (kstrlen(prog_spec[MAN1_LONGDESC]) < 100) &&
                   (kget_notify() == KHOSTILE))
        {
            kinfo(KHOSTILE, "Sorry, but i'm not going to generate code or "
		  "documentation until you write a longer, more complete "
		  "object description.");
            return(TRUE);
        }


	if (object_type == KCMS_SCRIPT)
	{
            /* generate man1 file */
            kgen_clui_generate_man1file(object, prog_spec, opath,
				 tbname, oname, bname);

	}
	else if (object_type == KCMS_PANE)
	{

	    /* are we supposed to generate frontend shell script */
	    kcms_get_attribute(object, KCMS_CMOBJ_GENERATE_EXECUTABLE, 
			       &genflag);
	    if (genflag)
	    {
		/* if so, generate pane script */
	        kgen_clui_generate_panescript(object, opath, tbname, 
				              oname, bname);

               /* and generate man1 file */
               kgen_clui_generate_man1file(object, prog_spec, opath,
				 tbname, oname, bname);
	    }
	}
        else if (!noclui)
        {
            /* generate man1 file */
            kgen_clui_generate_man1file(object, prog_spec, opath,
				 tbname, oname, bname);

            /* generate *.h file */
            kgen_clui_generate_hfile(object, prog_spec, opath, 
                              tbname, oname, hybrid);

            /* generate *.c file */
            kgen_clui_generate_cfile(object, prog_spec, opath,
	 		             oname, hybrid, form_var);

            /* generate usage.c file */
	    kgen_clui_generate_getargs_file(object, form, opath, oname);

            /* generate l*.c if it is requested, and it's not an xvroutine */
	    kgen_clui_generate_lfile(object, prog_spec, oname);

	    /* generate prototype for library routine (if necessary) */
	    kgen_clui_genlibproto(object, prog_spec, tbname, oname);
        }

	else if (object_type == KCMS_LIBRARY)
	{
	    kgen_clui_generate_library(object);
            kgen_clui_generate_man3file(object, prog_spec, opath,
				        tbname, oname);
	}

	if (!noclui)
	{
            kgen_clui_generate_helpfile(object, prog_spec, opath, 
				        tbname, oname);
	}

	datestamp = kcms_get_date();
	kcms_set_attribute(object, KCMS_DATE, NULL, NULL, datestamp);
	kfree(datestamp);

	kinfo(KHOSTILE, "you'd be better off if you stayed away from "
	      "computing altogether");
        return(TRUE);
}
