/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            Image Display Utility Routines
   >>>>
   >>>>   Static:
   >>>>             _header_init_info()
   >>>>  Private:
   >>>>             get_header_info()
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include "cmobjP.h"

#define HEADER		0
#define ROUTINE_NAME	1
#define PURPOSE		2
#define INPUT		3
#define OUTPUT		4
#define RETURNS		5
#define RESTRICTIONS	6
#define WRITTENBY	7
#define DATE		8
#define VERIFIED	9
#define SIDEEFFECTS	10
#define MODIFICATIONS	11
#define DECLARATION	12
#define HEADEREND	13

typedef struct _Keyword
{
   char *key;
   char *address;
   char *info_list;
   char *format;
}
Keyword;

typedef struct _ParamEntry
{
   char *parameter;
   char *address;
   char *format;
}
ParamEntry;

Keyword key_array[15] =
{
   {"^/\\*{3,}$", "^\\s*\\{.*$", NULL, NULL},
   {"^/\\*{3,}$", "^\\s*#\\s*define", NULL, NULL},
   {"^\\s*\\*\\s*Routine Name:", NULL, NULL, NULL},
   {"^\\s*\\*\\s*Purpose:", NULL, NULL, NULL},
   {"^\\s*\\*\\s*Input:", NULL, NULL, NULL},
   {"^\\s*\\*\\s*Output:", NULL, NULL, NULL},
   {"^\\s*\\*\\s*Returns:", NULL, NULL, NULL},
   {"^\\s*\\*\\s*Restrictions:", NULL, NULL, NULL},
   {"^\\s*\\*\\s*Written By:", NULL, NULL, NULL},
   {"^\\s*\\*\\s*Date:", NULL, NULL, NULL},
   {"^\\s*\\*\\s*Verified:", NULL, NULL, NULL},
   {"^\\s*\\*\\s*Side Effects:", NULL, NULL, NULL},
   {"^\\s*\\*\\s*Modifications:", NULL, NULL, NULL},
   {"^\\s*\\*\\s*Declaration:", NULL, NULL, NULL},
   {"^\\s*\\*{3,}/$", NULL, NULL, NULL}};

Keyword *key[15];

static char *oname = NULL;
static klist *list = NULL,
  *tlist = NULL,
  *start = NULL;
static char *strRoutine = NULL;
static int fileoffset = 0;

#define isinclude(name)	((kstrcmp(name+kstrlen(name)-2, ".h") == 0) ? \
			 TRUE : FALSE)

/*-----------------------------------------------------------
| Routine Name:	_kcms_header_info_init - initialize key array
|
| Purpose:	This initializes the array of keys used to parse
|		headers.  This routine is used to convert between
|		the .h keys, and the keys for normal src files.
|
| Input:	fileobj - the fileobj we are trying to manipulate
| Output:	
| Returns:	
|
| Written By:	Steven Jorgensen
| Date:		Nov 30, 1992 18:39
------------------------------------------------------------*/
static void
_kcms_header_info_init(
			 kobject fileobj)
{
   char *filename;


   if (kcms_get_attribute(fileobj, KCMS_PATH, &filename)
       && !isinclude(filename))
   {
      key[HEADER] = &key_array[0];
   }
   else
      key[HEADER] = &key_array[1];

   key[ROUTINE_NAME]  = &key_array[2];
   key[PURPOSE]       = &key_array[3];
   key[INPUT]         = &key_array[4];
   key[OUTPUT]        = &key_array[5];
   key[RETURNS]       = &key_array[6];
   key[RESTRICTIONS]  = &key_array[7];
   key[WRITTENBY]     = &key_array[8];
   key[DATE]          = &key_array[9];
   key[VERIFIED]      = &key_array[10];
   key[SIDEEFFECTS]   = &key_array[11];
   key[MODIFICATIONS] = &key_array[12];
   key[DECLARATION]   = &key_array[13];
   key[HEADEREND]     = &key_array[14];
}

/*-----------------------------------------------------------
| Routine Name:	_kcms_eat_space - eat ' ', '\t', '*', and '\n'
|
| Purpose:	This routine eats all beginning garbage of a string
|		and returns a pointer to the first non-garbage character
|
| Input:	data - string to clean up
|
| Returns:	a pointer to the first non-garbage character
|
| Written By:	Steven Jorgensen
| Date:		Dec 07, 1992 11:55
------------------------------------------------------------*/
static char *
_kcms_eat_space(
   kstring  data)
{
   while ((isspace(((unsigned int)*data))) ||
	  (((unsigned int)*data) == '*') ||
	  (((unsigned int)*data) == '\n'))
      data++;

   return data;
}

/*-----------------------------------------------------------
| Routine Name:	_kcms_get_paramlist - get the parameter list from a string
|		of parameters
|
| Purpose:	This routine takes the single string that the string
|		parser found splits it up into a list of parameters with
|		their descriptions.
|
| Input:	object      - the object to find the parameter info for
|		index       - the index into the global key array
|		declaration - the index the declaration is stored in
|
| Output:	cnt    - counter containing the size of the list
|
| Returns:	a pointer to the paramter names and descriptions.
|
| Written By:	Steven Jorgensen
| Date:		Dec 07, 1992 14:58
------------------------------------------------------------*/
static char ***
_kcms_get_paramlist(
   header_info  *header,
   int           index,
   int           declaration,
   int          *cnt)
{
   kstring     routine = "_kcms_get_paramlist";
   char        b[KLENGTH];
   ParamEntry *paramlist;
   char     ***result;
   char      **alist;
   char      **rlist;
   char       *tmp;
   char       *tmp1;
   char       *tmp2;
   char       *tmp3;
   char       *tmp4;
   int         lcnt;
   int         i;
   int         j;
   int         status;


   /*---------------------------------------------------------
    | Get the list of function parameters from the declaration
    | The result is stored in the array variable 'rlist' and
    | the array size is lcnt.  Note, 'rlist' is a set of pointers
    | that point into the 'alist' array entries.  'alist' holds
    | the parameters types and names, and 'rlist' is an array
    | of pointers that just points to the parameter name part of
    | the 'alist' string.
    ---------------------------------------------------------*/
   *cnt = 0;
   ksprintf(b, "%s\\s*\\(", header->name);
   tmp = kparse_string_scan(key[declaration]->info_list, b, "\\)\\s*$",
			    KLITERAL, NULL, NULL, &status);
   if (status != KPARSE_OK)
      return NULL;

   if (kstrchr(tmp, '('))
   {
      tmp1 = kregex_replace(tmp, "\\s+", " ", NULL);
      kfree(tmp);
      while (status == KPARSE_OK)
      {
         tmp = kparse_string_search(tmp1, "PROTO\\s*\\(\\s*\\(", KLITERAL,
				     &tmp3, &status);
	 if (tmp == NULL)
	    continue;
	 tmp2 = kparse_string_search(tmp, "\\)\\s*\\)", KLITERAL,NULL,&status);
	 if (tmp2 == NULL)
	    continue;
	 tmp4 = kstring_ncopy(tmp1, tmp - kstrlen(tmp3) - tmp1, NULL);
	 kfree(tmp3);
         tmp = tmp1;
	 tmp1 = kstring_cat(tmp4, tmp2, NULL);
	 kfree(tmp4);
	 kfree(tmp);
      }
      tmp = kregex_replace(tmp1, "\\(\\s*", "(", NULL);
      tmp1 = kregex_replace(tmp, "\\s*\\)\\s*", ")", NULL);
   }
   else
      tmp1 = tmp;
   
   alist = kparse_string_delimit(tmp1, ",", KDELIM_CLEAN, &lcnt);
   kfree(tmp1);
   rlist = (char **)kcalloc((unsigned int)lcnt, sizeof(char *));
   if (rlist == NULL)
   {
      kerror(KCMS, routine,
	     "Cannot allocate memory for a parameter list\n");
      karray_free(alist, lcnt, NULL);
      return NULL;
   }
   for (i = 0; i < lcnt; i++)
   {
      tmp = alist[i];
      tmp1 = NULL;
      while (*tmp != '\0')
      {
	 if (isspace(*tmp))
	    tmp1 = tmp;
	tmp++;
      }
      if (tmp1 == NULL)
	 rlist[i] = alist[i];
      else
	 rlist[i] = tmp1 + 1;
      while (((unsigned int)*(rlist[i])) == '*' ||
	     ((unsigned int)*(rlist[i])) == '(')
	 (rlist[i])++;
      tmp = rlist[i];
      while (isalnum(*tmp) || ((unsigned int) *tmp) == '_')
         tmp++;
      *tmp = '\0';
   }

   /*---------------------------------------------------------
    | 'paramlist' is an array to determine the starting locations
    | of each parameters location in the input string, and keep track
    | of information of which parameter in the header directly follows
    | the current entry.  Entry 0 corresponds to the parameter named in
    | 'rlist[0]', and so on.
    ---------------------------------------------------------*/
   if ((paramlist = (ParamEntry *)kcalloc((unsigned int)lcnt,
	sizeof(ParamEntry))) == NULL)
   {
      kerror(KCMS, routine, "Cannot allocate memory for a parameter list\n");
      karray_free(alist, lcnt, NULL);
      kfree(rlist);
      return NULL;
   }
   for (i = 0; i < lcnt; i++)
   {
      paramlist[i].parameter = rlist[i];
      ksprintf(b, "\\b%s\\s*-\\s*", rlist[i]);
      paramlist[i].address = kparse_string_search(key[index]->info_list, b,
				   KLITERAL, &paramlist[i].format, &status);
      if (status != KPARSE_OK)
	 paramlist[i].format = NULL;
   }
   /*---------------------------------------------------------
    | 'result' is an array of associated strings.  Each pointer
    | points to an array of values where item 0 is the parameter
    | name, and item 1 is the parameter description.  This is
    | the array that is returned to the calling routine, and
    | the int pointer 'cnt' passed in is set to the size of 'result'.
    ---------------------------------------------------------*/
   if ((result = (char ***)kcalloc((unsigned int)lcnt,
				   sizeof(char **))) == NULL)
   {
      kerror(KCMS, routine, "Cannot allocate memory for a parameter list\n");
      karray_free(alist, lcnt, NULL);
      kfree(rlist);
      return NULL;
   }
   for (i = 0; i < lcnt; i++)
   {
      if (paramlist[i].address != NULL)
      {
         tmp = NULL;
         tmp1 = NULL;
         for (j = 0 ; j < lcnt; j++)
	    if ((i != j) && ((paramlist[j].address > paramlist[i].address) &&
		((tmp == NULL) || (paramlist[j].address < tmp))))
	    {
	       tmp  = paramlist[j].address;
	       tmp1 = paramlist[j].format;
	    }
	 if (tmp == NULL)
	    tmp2 = kstrdup(paramlist[i].address);
	 else
	    tmp2 = kstring_ncopy(paramlist[i].address,
				 (int)(tmp - paramlist[i].address -
				       kstrlen(tmp1)),
				 NULL);
         if ((result[*cnt] = (char **)kcalloc(2, sizeof(char *))) == NULL)
         {
	    kerror(KCMS, routine,
		   "Cannot allocate memory for a parameter entry\n");
	    karray_free(alist, lcnt, NULL);
	    kfree(tmp1);
	    kfree(tmp2);
	    kfree(rlist);
	    kfree(paramlist);
	    return NULL;
         }
         result[*cnt][0] = kstrdup(paramlist[i].parameter);
         result[*cnt][1] = kstrip_header(tmp2);
	 (*cnt)++;
	 kfree(tmp2);
      }
   }
   for (i = 0; i < lcnt; i++)
   {
      kfree(paramlist[i].format);
   }
   karray_free(alist, lcnt, NULL);
   kfree(paramlist);
   kfree(rlist);

   return result;
}

/*-----------------------------------------------------------
|
| Routine Name:	_kcms_fill_key_array - fill in information in the key array
|
| Purpose:	This routine fills out the info_list field for keys
|		1-14 in the global header information array.
|		This routine will return TRUE if everything was successful
|		while parsing the header.  If FALSE is returned, it means
|		either the parsing failed, or the routine name didn't
|		match the one we're looking for.
|
| Input:	object  - The object we're trying to get documentation headers
|		for.
|		fileobj - the file obj we're parsing
|		routine - The routine name we're looking for.  If NULL,
|		we just want the next one.
| Output:	routine - Set to the name of the routine we've found
| Returns:	TRUE (1) on successful parse and search, FALSE (0) otherwise
|
| Written By:	Steven Jorgensen
| Date:		Dec 04, 1992 15:13
| Modifications:
|
------------------------------------------------------------*/
static int
_kcms_fill_key_array(
   kobject object,
   kobject fileobj)
{
   char *routine_name = "undetermined";
   int i;
   int j;
   int status;
   int declaration;
   int routine_token;
   char *tmp;
   char *tmp1;
   char *tmp2;
   char *filename;
   char fullpath[KLENGTH];
   struct stat info;
   klist *litem;
   header_info *header = NULL;
   header_info *theader = NULL;


   routine_token = kstring_to_token(routine_name);
   if (!kcms_get_attribute(fileobj, KCMS_PATH, &filename))
      return FALSE;
   kfullpath(filename, NULL, fullpath);
   kfree(strRoutine);
   for (i = ROUTINE_NAME; i <= HEADEREND; i++)
   {
      kfree(key[i]->info_list);
      kfree(key[i]->format);
      key[i]->address = NULL;
      key[i]->address = kparse_string_search(key[HEADER]->info_list,
					     key[i]->key, KIGNORE_CASE,
					     &key[i]->format, &status);
      if (i == 1 && status != KPARSE_OK)
	 return FALSE;
      else if (status != KPARSE_OK)
	 kinfo(KSYSLIB, "Header parsing warning on routine '%s', in file '%s'.  This routine does not have the key '%s' in the header.  This causes this section to be empty.  If it is incorrect for this field to be empty, you should add the key and text into the header. Then, this program should be rerun.\n", routine_name, filename, key[i]->key);
      else if (i == 1)
      {
	 tmp = _kcms_eat_space(key[i]->address);
	 tmp1 = kstrpbrk(tmp, " \t-()\n");
	 if (tmp1 == NULL)
	    tmp = kstrdup(tmp);
	 else
	    tmp = kstring_ncopy(tmp, tmp1 - tmp, NULL);
	 routine_name = tmp;
	 routine_token = kstring_to_token(routine_name);
/* NEILB */
	 if ((litem = klist_locate(object->header_list, (kaddr) routine_token))
	      != NULL)
	 {
	    theader = (header_info *) klist_clientdata(litem);
	    if (stat(fullpath, &info) == 0 &&
		info.st_mtime <= theader->parse_time)
	    {
	       kfree(routine_name);
	       return FALSE;
            }
	    kcms_header_info_free(theader);
	    object->header_list = klist_delete(object->header_list, (kaddr)
					       routine_token);
	 }
/* end of NEILB */
	 while ((tmp1 != NULL) && (isspace(((unsigned int)*tmp1)) ||
				   (((unsigned int)*tmp1) == '-') ||
				   (((unsigned int)*tmp1) == '(') ||
				   (((unsigned int)*tmp1) == ')')))
	    tmp1++;
	 key[i]->address = tmp1;
      }
   }

   for (i = ROUTINE_NAME; i <= HEADEREND; i++)
   {
      tmp = NULL;
      tmp1 = NULL;
      if (key[i]->address != NULL)
      {
	 for (j = ROUTINE_NAME; j <= HEADEREND; j++)
	    if ((i != j) &&
		((key[j]->address > key[i]->address) && ((tmp == NULL) ||
						  (key[j]->address < tmp))))
	    {
	       tmp = key[j]->address;
	       tmp1 = key[j]->format;
	    }
	 if (tmp == NULL)
	    tmp2 = kstrdup(key[i]->address);
	 else
	    tmp2 = kstring_ncopy(key[i]->address,
				 (int)(tmp - key[i]->address - 
				       kstrlen(tmp1)),
				 NULL);
	 key[i]->info_list = kstrip_header(tmp2);

	 /*UPDATE:------------------------------------------------------
	 |	this is a KLUDGE, since the regex wasn't finding the
	 |	first argument in the Input: and Output: sections of
	 |	the comment block for functions.
	 -------------------------------------------------------------*/
	 if (i == INPUT || i == OUTPUT)
	 {
	    kstring  t2;
	    t2 = kstring_cat(" ", key[i]->info_list, NULL);
	    kfree(key[i]->info_list);
	    key[i]->info_list = t2;
	 }
	 kfree(tmp2);
	 if (i == ROUTINE_NAME)
	 {
	    tmp2 = key[i]->info_list;
	    key[i]->info_list = kchar_replace(tmp2, (char)'\n', (char)' ',
					      NULL);
	    kfree(tmp2);
	 }
      }
   }

   if (key[DECLARATION]->info_list == NULL)
      declaration = HEADEREND;
   else
      declaration = DECLARATION;
   if ((header = (header_info *) kcalloc(1, sizeof(header_info))) == NULL)
   {
      kerror(KCMS, "kfill_header_info",
	     "Cannot malloc a header_info structure\n");
      kfree(routine_name);
      return FALSE;
   }
   strRoutine = kstrdup(routine_name);
   header->name = routine_name;
   header->shortdesc = kstrdup(key[ROUTINE_NAME]->info_list);
   header->purpose = kstrdup(key[PURPOSE]->info_list);
   header->input = _kcms_get_paramlist(header, INPUT, declaration,
				       &header->in_cnt);
   header->output = _kcms_get_paramlist(header, OUTPUT, declaration,
					&header->out_cnt);
   header->returns = kstrdup(key[RETURNS]->info_list);
   header->restrictions = kstrdup(key[RESTRICTIONS]->info_list);
   header->author = kstrdup(key[WRITTENBY]->info_list);
   header->date = kstrdup(key[DATE]->info_list);
   header->verified = kstrdup(key[VERIFIED]->info_list);
   header->sideeff = kstrdup(key[SIDEEFFECTS]->info_list);
   header->mods = kstrdup(key[MODIFICATIONS]->info_list);

#if 0
   header->declaration = kstrdup(key[declaration]->info_list);
#endif

   /*-- strip out code generation tags if present ---------------------*/
   tmp = kregex_replace(key[declaration]->info_list,
			"/\\*\\s+-library_def\\s+\\*/$", "", NULL);
   tmp2 = kregex_replace(tmp,
			"/\\*\\s+-library_def_end\\s+\\*/$", "", NULL);
   kfree(tmp);

   tmp = kregex_replace(tmp2,
			"/\\*\\s+-library_code\\s+\\*/$", "", NULL);
   kfree(tmp2);

   header->declaration = kstring_cleanup(tmp, NULL);
   kfree(tmp);

   header->filename = kstrdup(filename);
   header->parse_time = time(NULL);
   object->header_list = klist_add(object->header_list,
				   (kaddr) routine_token, (kaddr) header);
   object->single = routine_token;
   return (object->routine == 0 || object->routine == routine_token);
}

/*-----------------------------------------------------------
|
| Routine Name:	kcms_header_info_copy - copy information into a header_info
|		structure
|
| Purpose:	This routine copies all data in the original header to
|		the a new header_info structure and returns it.
|
| Input:	header - the header info struct to copy
|
| Output:	
|
| Returns:	A pointer to the header info struct on success, or NULL on
|		Error
|
| Written By:	Steven Jorgensen
| Date:		Dec 08, 1992 12:18
| Modifications:
|
------------------------------------------------------------*/
header_info *
kcms_header_info_copy(
			header_info * header)
{
   char *routine = "kcms_header_info_copy";
   header_info *new;
   int i;


   if (header == NULL)
      return NULL;

   if ((new = (header_info *) kcalloc(1, sizeof(header_info))) == NULL)
   {
      kerror(KCMS, routine,
	     "Cannot malloc a header_info structure\n");
      return NULL;
   }

   new->name = kstrdup(header->name);
   new->shortdesc = kstrdup(header->shortdesc);
   new->purpose = kstrdup(header->purpose);
   new->returns = kstrdup(header->returns);
   new->restrictions = kstrdup(header->restrictions);
   new->author = kstrdup(header->author);
   new->date = kstrdup(header->date);
   new->verified = kstrdup(header->verified);
   new->sideeff = kstrdup(header->sideeff);
   new->mods = kstrdup(header->mods);
   new->declaration = kstrdup(header->declaration);
   new->filename = kstrdup(header->filename);

   new->in_cnt = header->in_cnt;
   if ((new->input = (char ***)kcalloc((unsigned int)new->in_cnt,
				       sizeof(char **))) == NULL)
   {
      kerror(KCMS, routine,
	     "Cannot allocate memory for input parameter list\n");
      new->in_cnt = 0;
      kcms_header_info_free(new);
      return NULL;
   }
   for (i = 0; i < new->in_cnt; i++)
   {
      new->input[i] = (char **)kcalloc(2, sizeof(char *));
      if (new->input[i] == NULL)
      {
	 kerror(KCMS, routine,
		"Cannot allocate memory for a parameter\n");
	 new->in_cnt = i;
	 kcms_header_info_free(new);
	 return NULL;
      }
      new->input[i][0] = kstrdup(header->input[i][0]);
      new->input[i][1] = kstrdup(header->input[i][1]);
   }
   new->out_cnt = header->out_cnt;
   if ((new->output = (char ***)kcalloc((unsigned int)new->out_cnt,
					sizeof(char **))) == NULL)
   {
      kerror(KCMS, routine,
	     "Cannot allocate memory for output parameter list\n");
      new->out_cnt = 0;
      kcms_header_info_free(new);
      return NULL;
   }
   for (i = 0; i < new->out_cnt; i++)
   {
      new->output[i] = (char **)kcalloc(2, sizeof(char *));
      if (new->output[i] == NULL)
      {
	 kerror(KCMS, routine,
		"Cannot allocate memory for parameter entry\n");
	 new->out_cnt = i;
	 kcms_header_info_free(new);
	 return NULL;
      }
      new->output[i][0] = kstrdup(header->output[i][0]);
      new->output[i][1] = kstrdup(header->output[i][1]);
   }
   return new;
}

/*-----------------------------------------------------------
| Routine Name:	kcms_header_info_free - free a header_info struct
|
| Purpose:	This routine frees all memory associated with
|		a header_info structure.
|
| Input:	header - a pointer to the header info struct to free
|
| Written By:	Steven Jorgensen
| Date:		Dec 07, 1992 18:42
------------------------------------------------------------*/
void
kcms_header_info_free(
			header_info * header)
{
   int i;


   if (header == NULL)
      return;
   kfree(header->name);
   kfree(header->shortdesc);
   kfree(header->purpose);
   for (i = 0; i < header->in_cnt; i++)
   {
      kfree(header->input[i][0]);
      kfree(header->input[i][1]);
      kfree(header->input[i]);
   }
   kfree(header->input);
   for (i = 0; i < header->out_cnt; i++)
   {
      kfree(header->output[i][0]);
      kfree(header->output[i][1]);
      kfree(header->output[i]);
   }
   kfree(header->output);
   kfree(header->returns);
   kfree(header->restrictions);
   kfree(header->author);
   kfree(header->date);
   kfree(header->verified);
   kfree(header->sideeff);
   kfree(header->mods);
   kfree(header->declaration);
   kfree(header->filename);
   kfree(header);
}

/*-----------------------------------------------------------
| Routine Name:	get_header_info - get source header information
|
| Purpose:	This routine gets source code header information from
|		public headers to use in generating man or manual
|		information.
|
| Input:	object - the program object to operate on
| Output:	
| Returns:	TRUE (1) on success, FALSE (0) otherwise
|
| Written By:	Steven Jorgensen
| Date:		Nov 30, 1992 11:03
------------------------------------------------------------*/
int
kcms_get_header_info(
		       kobject object)
{
   char *routine = "kcms_get_header_info";
   char curfile2[KLENGTH];
   char fullpath[KLENGTH];
   char *fname;
   kobject obj;
   int status = KPARSE_OK;
   int done = FALSE;
   int d2;
   int curfile_tkn;
   int curfile2_tkn;
   kfile *file;
   klist *hlist;
   header_info *header;
   struct stat info;
   


   /*---------------------------------------------------
    | For efficiency, we keep internal information to indicate the
    | current file we are in, and the position in that file.  If the
    | object name of the object passed in is not the oname of our
    | buffer, than we need to reset the buffer.
    ---------------------------------------------------*/
   if (kstrcmp(object->oname, oname) != 0)
   {
      fileoffset = 0;
      kfree(oname);
      kfree(strRoutine);
      klist_free(start, NULL);
      if (!kcms_get_attribute(object, KCMS_CMOBJ_ALL_SRC, &list))
      {
	 list = NULL;
	 kerror(KCMS, routine, "Could not get source code list");
	 return FALSE;
      }
      start = list = klist_copy(list);
      tlist = klist_head(start);
      oname = kstrdup(object->oname);
   }

   /*---------------------------------------------------
    | Check list to see if it we should restart from first file
    | object so that we can parse in headers that have changed.
    ---------------------------------------------------*/
   for (hlist = klist_head(object->header_list); hlist != NULL;
	hlist = klist_next(hlist))
   {
      header = (header_info *) klist_clientdata(hlist);
      kfullpath(header->filename, NULL, fullpath);
      if (stat(fullpath, &info) == -1 || info.st_mtime > header->parse_time)
      {
        kfree(strRoutine);
        tlist = klist_head(start);
        fileoffset = 0;
	break;
      }
   }

   /*---------------------------------------------------
    | Main parsing loop.  Because list and tlist are static,
    | it will remember where it left off so it can continue
    | on the next call to this routine.
    ---------------------------------------------------*/
   for (list = tlist; list != NULL && done == FALSE; list = klist_next(list))
   {
      /*---------------------------------------------------
      | If user has specified a filename to parse via object->filename,
      | we need to advance the list pointer until we get to the correct
      | fileobject.  Note, obj is the kobject pointer of the current file
      | object in list we are working on.
      ---------------------------------------------------*/
      obj = (kobject) klist_clientdata(list);
      if (object->filename != NULL)
      {
	 kbasename(object->filename, curfile2);
	 curfile2_tkn = kstring_to_token(curfile2);
         if (!kcms_get_attribute(obj, KCMS_FOBJ_BASENAME_TKN, &curfile_tkn))
	    return FALSE;
         if (curfile2_tkn != curfile_tkn)
	    continue;
      }
      /*---------------------------------------------------
      | This call initializes the parse keys depending on whether
      | or not the file is a *.c or a *.h.
      ---------------------------------------------------*/
      _kcms_header_info_init(obj);

      /*---------------------------------------------------
      | Open current file, and prepare it for parsing.
      ---------------------------------------------------*/
      if (!kcms_get_attribute(obj, KCMS_PATH, &fname))
	 return FALSE;
      if ((file = kfopen(fname, "r")) == NULL)
      {
	 kerror(KCMS, routine, "kfopen of '%s' failed\n", fname);
	 fileoffset = 0;
	 kfree(oname);
	 kfree(strRoutine);
	 return FALSE;
      }
      if ((list == tlist) && (kfseek(file, fileoffset, 0) == -1))
      {
	 kerror(KCMS, routine, "kfseek of '%s' failed\n", fname);
	 fileoffset = 0;
	 kfree(oname);
	 kfree(strRoutine);
	 kfclose(file);
	 return FALSE;
      }

      /*---------------------------------------------------
       | Loop to search for all public header's in the current
       | file object.
       ---------------------------------------------------*/
      d2 = FALSE;
      while (d2 == FALSE)
      {
         /*---------------------------------------------------
          | Scan for a public header 
          ---------------------------------------------------*/
	 kfree(key[HEADER]->info_list);
	 key[HEADER]->info_list = kparse_file_scan(file,
						   key[HEADER]->key,
						   key[HEADER]->address,
						   KIGNORE_CASE, NULL, NULL,
						   &status);
	 d2 = TRUE;
         /*---------------------------------------------------
          | If we didn't find a header, reset file offset, and
	  | set current pointer to the next file in the list
          ---------------------------------------------------*/
	 if ((kstrlen(key[HEADER]->info_list) == 0) ||
	     (status != KPARSE_OK))
	 {
	    tlist = klist_head(start);
	    fileoffset = 0;
	 }
         /*---------------------------------------------------
          | If we did find a header, try to fill out a header
	  | structure.  If that is successful, keep track
	  | of current file and the position in the file for
	  | the next run through.
          ---------------------------------------------------*/
	 else if (_kcms_fill_key_array(object, obj) != FALSE)
	 {
	    tlist = list;
	    fileoffset = kftell(file);
	    done = TRUE;
	 }
         /*---------------------------------------------------
	  | Found what looked to be a header, but it wasn't, so
	  | try again.
          ---------------------------------------------------*/
	 else
	    d2 = FALSE;
      }
      kfclose(file);
   }
   if (status != KPARSE_OK)
      return FALSE;
   return TRUE;
}

void
kcms_sync_header_close(void)
{
   klist_free(start, NULL);
   tlist = NULL;
   start = NULL;
   list = NULL;
   kfree(oname);
   oname = NULL;
   kfree(strRoutine);
   strRoutine = NULL;
   fileoffset = 0;
}
