/*
 * Khoros: $Id$
 */
 
#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif
 
/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	utility routines for kclui
   >>>> 
   >>>>	Private: 
   >>>>	Static: 
   >>>>	Public: 
   >>>>		kclui_check_args
   >>>>		kclui_consolidate_args
   >>>>		kclui_arguments
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"


/****************************************************************
* 
*  Routine Name: kclui_check_args - command line argument checker
* 
*       Purpose: This routine verifies that all command line arguments
*		 have been successfully processed.
*         Input: 
*        Output: 
*
*       Returns: TRUE (1) on success, FALSE (0) otherwise
*
*  Restrictions: Restrictions on data or input as applicable
*    Written By: Mark Young & Danielle Argiro
*          Date: Apr 12, 1994
*      Verified: 
*  Side Effects: 
* Modifications:
****************************************************************/

int kclui_check_args(
   void)
{
	int  i, argc; 
	char **argv; 
	char error[KLENGTH];


	error[0] = '\0';
	argc = kprog_get_argc();
	argv = kprog_get_argv();
	for (i = 1; i < argc; i++)
	   (void) kstring_3cat(error, " ", argv[i], error);

	if (argc > 1)
	{
           errno = KINVALID_INPUT;
	   kerror(NULL, "kclui_check_args",
		 "ERROR: Invalid command line option '%s'", error);
	   return(FALSE);
	}
	return(TRUE);
}

/****************************************************************
* 
*  Routine Name: kclui_consolidate_args - consolidate command line arguments.
* 
*       Purpose: consolidates the command line arguments according to the
*		 arguments processed on the clui pane.  The clui pane repre-
*		 sents the possible command line options.  Therefore if
*		 a command line argument variable is not available within
*		 the clui pane, then it is not removed from the argv list.
*		 Also, each argument 
*         Input: pane - the clui pane that represents the possible command line
*			arguments
*        Output: 
*
*       Returns: TRUE (1) on success, FALSE (0) otherwise
*
*  Restrictions: Restrictions on data or input as applicable
*    Written By: Mark Young & Danielle Argiro
*          Date: Apr 12, 1994
*      Verified: 
*  Side Effects: 
* Modifications:
****************************************************************/

int kclui_consolidate_args(
   kform *pane)
{
	int  i, num, argc;
	kselection *selection;
	char *name, **argv, error[KLENGTH];


	error[0] = '\0';
	argc = kprog_get_argc();
	argv = kprog_get_argv();

	for (i = 0; i < argc; i++)
	{
	   name = kstring_cleanup(argv[i], argv[i]);

	   /* a minus sign implies a variable */
	   if (name != NULL && *name == '-')
	   {
	      /* get variable name following - sign */
	      name++;

	      /* look for the variable in the form tree selection list */
	      if ((selection = kvf_variable_sel_search(pane, name)) != NULL)
	      {
		 /* if it was in the form tree, delete it from argument list */
		 argv[i] = NULL;

		 /* want to delete the value following the -variable, if
	            it's not a flag, or the special cases -A or -a  */
		 if (selection->type != KUIS_FLAG)
		 {
		    if (kstrcasecmp(name, "A") == 0 && i+1 < argc)
		    {
		       name = kstring_cleanup(argv[i+1], argv[i+1]);
		       if (name == NULL || *name != '-')
		          argv[++i] = NULL;
		    }
		    else argv[++i] = NULL;
		 }
	      }
	   }
	}

	for (i = num = 0; i < argc; i++)
	{
	   if (argv[i] != NULL)
	      argv[num++] = argv[i];
	}
	kprog_set_argc(num);
	return(num);
}

/****************************************************************
* 
*  Routine Name: kclui_arguments - return the command line arguments
* 
*       Purpose: This routine returns the command line arguments
*         Input: 
*        Output: command - the return argument string, or NULL
*
*       Returns: TRUE (1) on success, FALSE (0) otherwise
*
*  Restrictions:
*    Written By: Mark Young & Danielle Argiro
*          Date: Apr 12, 1994
*      Verified: 
*  Side Effects: 
* Modifications:
****************************************************************/

char *kclui_arguments(
   char *command)
{
	int  i, argc;
	char **argv, name[KLENGTH], temp[KLENGTH];


	temp[0] = '\0';
	argc = kprog_get_argc();
	argv = kprog_get_argv();
	for (i = 1; i < argc; i++)
	{
	   if (kstrpbrk(argv[i], " \t\n") != NULL)
	      ksprintf(name, "\"%s\"", argv[i]);
	   else
	      kstrcpy(name, argv[i]);

	   kstring_3cat(temp, " ", name, temp);
	}

	if (command)
	   kstrcpy(command, temp);
	else
	   command = kstrdup(temp);

	return(command);
}
