 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for phantomd
   >>>> 
   >>>>    Written By: Mark Young
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _phantomd_h_
#define _phantomd_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <bootstrap.h>

/* -include_includes */
#include "kutils/ksignal.h"
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
#define PhantomExec "phantom"

/*
 *  define for figuring out the number of transports in the array list
 */
#define NumRemoteTransports ((int) sizeof(remote_transport)/sizeof(remote_transport[0]))
/* -include_defines_end */

#define PANEPATH "$BOOTSTRAP/objects/kroutine/phantomd/uis/phantomd.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  spawn process in background and dis-associate tty (optional logical)
 */
int	 daemon_logic;	/* spawn process in background and dis-associate tty LOGIC */
int	 daemon_flag;  	/* spawn process in background and dis-associate tty FLAG */

/*
 *  number of minutes idle time before quitting (optional integer)
 */
int	 timeout_int; 	/* number of minutes idle time before quitting INT */
int	 timeout_flag;	/* number of minutes idle time before quitting FLAG */

/*
 *  type of transport to start the daemon for (optional string)
 */
char	*transport_string;	/* type of transport to start the daemon for STRING */
int	 transport_flag;   	/* type of transport to start the daemon for FLAG */

} clui_info_struct;

/* -include_typedefs */
typedef struct _remote_info
{
	char    *label;
	char    *identifier;
	int     data_permanence;

	int	(*connect)();
} RemoteTransport;
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/*
 *  Internal structures for the following transports can be found in
 *  the following includes:
 *
 *		tli	   -  Tli.h
 *		socket	   -  Socket.h
 *		sun rpc	   -  SunRPC.h
 *		apollo rpc -  ApolloRPC.h
 */
extern RemoteTransport tli_remotetrans[];
extern RemoteTransport sunrpc_remotetrans[];
extern RemoteTransport apollorpc_remotetrans[];
extern RemoteTransport socket_remotetrans[];


/*
 *  List of currently supported daemons....
 *
 *  To add a new transport please see supporting documentation
 *  transport.3
 */
static RemoteTransport *remote_transport[] =
{
	socket_remotetrans,
	tli_remotetrans,
	sunrpc_remotetrans, 
	apollorpc_remotetrans
};
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void phantomd_get_args PROTO((kform *));
void phantomd_usage_additions PROTO((void));
void phantomd_free_args PROTO((int, kaddr));

/* -include_routines */
int   phantomd_init	PROTO((char *, int, kfile **, kfile **));
void  phantomd_exit	PROTO((int, kaddr));
int   phantomd_stop	PROTO((void));
int   phantomd_start	PROTO((char *, char *));
/* -include_routines_end */

#endif
