 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for krename
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "krename.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Renames a software object
|
|       Purpose: main program for krename
|
|         Input:
|		char *clui_info->tb_string; {name of toolbox}
|		int   clui_info->tb_flag; {TRUE if -tb specified}
|
|		char *clui_info->oname_string; {name of object in specified toolbox}
|		int   clui_info->oname_flag; {TRUE if -oname specified}
|
|		char *clui_info->new_string; {new name for object}
|		int   clui_info->new_flag; {TRUE if -new specified}
|
|        Output:
|       Returns:
|
|    Written By: 
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
   kobject  toolbox;
   kobject  object;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "BOOTSTRAP");
	kexit_handler(krename_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "BOOTSTRAP", "krename",
		krename_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	krename_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
   if ((toolbox = kcms_open_toolbox(clui_info->tb_string)) == NULL)
   {
      kerror(NULL, "main()", "Unable to open toolbox `%s'.\n",
	     clui_info->tb_string);
      kexit(KEXIT_FAILURE);
   }

   if ((object = kcms_open_cmobj(toolbox, clui_info->oname_string)) == NULL)
   {
      kerror(NULL, "main()", "Unable to open object `%s' in toolbox `%s'.\n",
	     clui_info->oname_string, clui_info->tb_string);
      kcms_close(toolbox);
      kexit(KEXIT_FAILURE);
   }
/* -main_before_lib_call_end */

/* -main_library_call */
   if (kcms_rename(object, clui_info->new_string))
   {
      kcms_set_bit(object, KCMS_CMOBJ_FLAGS, KCMS_BIT_CMOBJ_FORCE);
      kgen_generate_object(object);
   }
/* -main_library_call_end */

/* -main_after_lib_call */
   kcms_close(object);
   kcms_close(toolbox);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: krename_usage_additions
| 
|       Purpose: Prints usage additions in krename_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname krename
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void krename_usage_additions(void)
{
	kfprintf(kstderr, "\tRenames a software object\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: krename_free_args
| 
|       Purpose: Frees CLUI struct allocated in krename_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname krename
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
krename_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->tb_string);
	kfree(clui_info->oname_string);
	kfree(clui_info->new_string);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
