 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kman.h"
/*-----------------------------------------------------------
| 
|  Routine Name: kman_get_args
| 
|       Purpose: Gets command line args for kman
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kman
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kman_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for kman is out of sync with arguments specified in kman's *.pane file; please rerun ghostwriter on kman.";


	/*
	 * allocate the kman structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_string(pane, "tb",
			  &(clui_info->tb_string),
			  &(clui_info->tb_flag))))
	{
	    kerror(NULL, "kman_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "k",
			  &(clui_info->k_string),
			  &(clui_info->k_flag))))
	{
	    kerror(NULL, "kman_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "f",
			  &(clui_info->f_string),
			  &(clui_info->f_flag))))
	{
	    kerror(NULL, "kman_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "r",
			  &(clui_info->r_flag))))
	{
	    kerror(NULL, "kman_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "man",
			  &(clui_info->man_flag))))
	{
	    kerror(NULL, "kman_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "hlp",
			  &(clui_info->hlp_flag))))
	{
	    kerror(NULL, "kman_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "manual",
			  &(clui_info->manual_flag))))
	{
	    kerror(NULL, "kman_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



