 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for kman
   >>>> 
   >>>>    Written By: Mark Young
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _kman_h_
#define _kman_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <bootstrap.h>

/* -include_includes */
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
#define MAN    0
#define HELP   1
#define MANUAL 2
/* -include_defines_end */

#define PANEPATH "$BOOTSTRAP/objects/kroutine/kman/uis/kman.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  toolbox in which to search for the manpage (optional string)
 */
char	*tb_string;	/* toolbox in which to search for the manpage STRING */
int	 tb_flag;   	/* toolbox in which to search for the manpage FLAG */

/*
 *  keyword to search the whatis file for (optional string)
 */
char	*k_string;	/* keyword to search the whatis file for STRING */
int	 k_flag;   	/* keyword to search the whatis file for FLAG */

/*
 *  roff formater command for printing man pages (optional string)
 */
char	*f_string;	/* roff formater command for printing man pages STRING */
int	 f_flag;   	/* roff formater command for printing man pages FLAG */

/*
 *  reformats the man page (optional flag)
 */
int	 r_flag;  	/* reformats the man page FLAG */

/*----- optional ME group ----*/
/*
 *  format using manpage macros (optional flag)
 */
int	 man_flag;  	/* format using manpage macros FLAG */

/*
 *  format using helppage macros (optional flag)
 */
int	 hlp_flag;  	/* format using helppage macros FLAG */

/*
 *  format using manual macros (optional flag)
 */
int	 manual_flag;  	/* format using manual macros FLAG */

/*-- optional ME group end ---*/

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void kman_get_args PROTO((kform *));
void kman_usage_additions PROTO((void));
void kman_free_args PROTO((int, kaddr));

/* -include_routines */
int run_kman    PROTO((char **, int, char **, int, int));
int run_kwhatis PROTO((char *, char **, int));
/* -include_routines_end */

#endif
