 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kgentb
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kgentb.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Creates a toolbox from scratch.
|
|       Purpose: main program for kgentb
|
|         Input:
|		char *clui_info->tb_string; {toolbox to create}
|		int   clui_info->tb_flag; {TRUE if -tb specified}
|
|		char *clui_info->path_string; {toolbox path}
|		int   clui_info->path_flag; {TRUE if -path specified}
|
|		char *clui_info->author_string; {toolbox author}
|		int   clui_info->author_flag; {TRUE if -author specified}
|
|		char *clui_info->title_string; {toolbox title}
|		int   clui_info->title_flag; {TRUE if -title specified}
|
|		char *clui_info->info_string; {toolbox info path}
|		int   clui_info->info_flag; {TRUE if -info specified}
|
|		int clui_info->add_flag; {TRUE if -add specified}
|
|        Output:
|       Returns:
|
|    Written By: Steven Jorgensen
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
	kobject		toolbox;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "BOOTSTRAP");
	kexit_handler(kgentb_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "BOOTSTRAP", "kgentb",
		kgentb_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kgentb_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	if (clui_info->tb_string == NULL)
	{
		errno = KNULL_PARAMETER;
		kerror(NULL, "main()", "Toolbox field is NULL");
		kexit(KEXIT_FAILURE);
	}
	if ((toolbox = kcms_open_toolbox(clui_info->tb_string)) != NULL)
	{
		kerror(NULL, "main()", "Toolbox '%s' already exists",
		       clui_info->tb_string);
		kcms_close(toolbox);
		kexit(KEXIT_FAILURE);
	}
/* -main_before_lib_call_end */

/* -main_library_call */
   if (clui_info->add_flag)
      toolbox = kcms_add_toolbox(clui_info->tb_string, clui_info->path_string);
   else
      toolbox = kcms_create_toolbox(clui_info->tb_string,
                                    clui_info->path_string);

	if (toolbox == NULL)
	{
		kerror(NULL,"main()","Error %s toolbox '%s'",
			(clui_info->add_flag == TRUE) ? "adding" : "creating",
			clui_info->tb_string);
		kexit(KEXIT_FAILURE);
	}

	if (!clui_info->add_flag)
	{
	   if (clui_info->author_string)
	      kcms_set_attribute(toolbox, KCMS_TB_AUTHOR,
			clui_info->author_string);

	   if (clui_info->title_string)
	      kcms_set_attribute(toolbox, KCMS_TB_TITLE,
			clui_info->title_string);

	   if (clui_info->info_string)
	      kcms_set_attribute(toolbox, KCMS_TB_INFO_FILE,
			clui_info->info_string);
	}
/* -main_library_call_end */

/* -main_after_lib_call */
	kcms_close(toolbox);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kgentb_usage_additions
| 
|       Purpose: Prints usage additions in kgentb_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kgentb
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kgentb_usage_additions(void)
{
	kfprintf(kstderr, "\tCreates a toolbox from scratch.\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kgentb_free_args
| 
|       Purpose: Frees CLUI struct allocated in kgentb_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kgentb
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kgentb_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->tb_string);
	kfree(clui_info->path_string);
	kfree(clui_info->author_string);
	kfree(clui_info->title_string);
	kfree(clui_info->info_string);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
