 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for kgenobj
   >>>> 
   >>>>    Written By: 
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _kgenobj_h_
#define _kgenobj_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <bootstrap.h>

/* -include_includes */
#include "kcms/kcms.h"
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$BOOTSTRAP/objects/kroutine/kgenobj/uis/kgenobj.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  toolbox name (required string)
 */
char	*tb_string;	/* toolbox name STRING */
int	 tb_flag;   	/* toolbox name FLAG */

/*
 *  object name (required string)
 */
char	*oname_string;	/* object name STRING */
int	 oname_flag;   	/* object name FLAG */

/*
 * type of object (Required string toggle)
 *	kroutine (kroutine)
 *	xvroutine (xvroutine)
 *	example (example)
 *	testsuite (testsuite)
 *	library (library)
 *	script (script)
 *	pane (pane),
 */
char	*type_toggle;		/* type of object STRING TOGGLE */
int	 type_flag;		/* type of object FLAG */

/*
 *  short description of object (optional string)
 */
char	*description_string;	/* short description of object STRING */
int	 description_flag;   	/* short description of object FLAG */

/*
 *  An object to use as a template (optional string)
 */
char	*temp_obj_string;	/* An object to use as a template STRING */
int	 temp_obj_flag;   	/* An object to use as a template FLAG */

/*
 *  Toolbox Template Object is in.  If not specified, it assumes the toolbox for the new object (optional string)
 */
char	*temp_tb_string;	/* Toolbox Template Object is in.  If not specified, it assumes the toolbox for the new object STRING */
int	 temp_tb_flag;   	/* Toolbox Template Object is in.  If not specified, it assumes the toolbox for the new object FLAG */

/*
 *  binary name (optional string)
 */
char	*bname_string;	/* binary name STRING */
int	 bname_flag;   	/* binary name FLAG */

/*
 *  Start a *.form file for the object (optional flag)
 */
int	 form_flag;  	/* Start a *.form file for the object FLAG */

/*
 * Alternate programming language (Optional string toggle)
 *	none (none)
 *	fortran (fortran)
 *	perl (perl)
 *	csh (csh)
 *	sh (sh)
 *	ksh (ksh),
 */
char	*lang_toggle;		/* Alternate programming language STRING TOGGLE */
int	 lang_flag;		/* Alternate programming language FLAG */

/*----- optional MI group ----*/
/*
 *  Start a *.pane file for the object (optional flag)
 */
int	 pane_flag;  	/* Start a *.pane file for the object FLAG */

/*
 *  Will this object be available from Cantata? (optional logical)
 */
int	 cantata_logic;	/* Will this object be available from Cantata? LOGIC */
int	 cantata_flag;  	/* Will this object be available from Cantata? FLAG */

/*
 *  category name (optional string)
 */
char	*cat_string;	/* category name STRING */
int	 cat_flag;   	/* category name FLAG */

/*
 *  subcategory name (optional string)
 */
char	*subcat_string;	/* subcategory name STRING */
int	 subcat_flag;   	/* subcategory name FLAG */

/*-- optional MI group end ---*/

/*----- optional MI group ----*/
/*
 *  Allow the user to specify whether or not to create a l*.c file (optional flag)
 */
int	 lib_flag;  	/* Allow the user to specify whether or not to create a l*.c file FLAG */

/*
 *  library object to associate l*.c with (optional string)
 */
char	*lname_string;	/* library object to associate l*.c with STRING */
int	 lname_flag;   	/* library object to associate l*.c with FLAG */

/*-- optional MI group end ---*/

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void kgenobj_get_args PROTO((kform *));
void kgenobj_usage_additions PROTO((void));
void kgenobj_free_args PROTO((int, kaddr));

/* -include_routines */
int do_exit_junk PROTO((kobject, kobject, kobject, kobject, char *, kvalist));
/* -include_routines_end */

#endif
