 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            File Title
   >>>>
   >>>>  Static:
   >>>>             _static_routines()
   >>>>  Private:
   >>>>             private_routines()
   >>>>  Public:
   >>>>             public_routines()
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kgenobj.h"


/*-----------------------------------------------------------
|
|  Routine Name: do_exit_junk - do exit junk
|
|       Purpose: do memory and pointer clean up before a kexit failure
|
|         Input: template_cmobj - template object to close
|		 cmobj          - failed cmobj to remove
|		 toolbox	- toolbox to close
|		 mesg		- message to print
|		 kvalist	- variable args to support message
|
|        Output:
|       Returns: KEXIT_FAILURE
|
|    Written By: Steven Jorgensen
|          Date: Sep 17, 1993
| Modifications:
|
------------------------------------------------------------*/
int
do_exit_junk(
	kobject template_cmobj,
	kobject template_tb,
	kobject cmobj,
	kobject toolbox,
	char 	*mesg,
	kvalist)
{
	kva_list args;
	kva_start(args, mesg);
	if (mesg != NULL)
		kverror("kcms", "main()", mesg, args);
	if (template_cmobj)
		kcms_close(template_cmobj);
	if (template_tb && template_tb != toolbox)
		kcms_close(template_tb);
	if (cmobj)
		kcms_destroy(cmobj);
	if (toolbox)
		kcms_close(toolbox);
	return(KEXIT_FAILURE);
}
