 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for kgendepend
   >>>> 
   >>>>    Written By: 
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _kgendepend_h_
#define _kgendepend_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <bootstrap.h>

/* -include_includes */
#include "ifparser.h"
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
#define MAXDEFINES	512
#define MAXFILES	512
#define MAXDIRS		64
#define SYMTABINC	10	/* must be > 1 for define() to work right */
#define	TRUE		1
#define	FALSE		0

/* the following must match the directives table in main.c */
#define	IF		0
#define	IFDEF		1
#define	IFNDEF		2
#define	ELSE		3
#define	ENDIF		4
#define	DEFINE		5
#define	UNDEF		6
#define	INCLUDE		7
#define	LINE		8
#define	PRAGMA		9
#define DERROR          10
#define IDENT           11
#define SCCS            12
#define ELIF            13
#define EJECT           14
#define IFFALSE         15     /* pseudo value --- never matched */
#define ELIFFALSE       16     /* pseudo value --- never matched */
#define INCLUDEDOT      17     /* pseudo value --- never matched */
#define IFGUESSFALSE    18     /* pseudo value --- never matched */
#define ELIFGUESSFALSE  19     /* pseudo value --- never matched */
/* -include_defines_end */

#define PANEPATH "$BOOTSTRAP/objects/kroutine/kgendepend/uis/kgendepend.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

/* -include_typedefs */
typedef	int boolean;

struct symtab {
	char	*s_name;
	char	*s_value;
};

struct	inclist {
	char		*i_incstring;	/* string from #include line */
	char		*i_file;	/* path name of the include file */
	struct inclist	**i_list;	/* list of files it itself includes */
	int		i_listlen;	/* length of i_list */
	struct symtab	*i_defs;	/* symbol table for this file */
	int		i_ndefs;	/* current # defines */
	int		i_deflen;	/* amount of space in table */
	boolean		i_defchecked;	/* whether defines have been checked */
	boolean		i_notified;	/* whether we have revealed includes */
	boolean		i_marked;	/* whether it's in the makefile */
	boolean		i_searched;	/* whether we have read this */
	boolean         i_included_sym; /* whether #include SYMBOL was found */
					/* Can't use i_list if TRUE */
};

struct filepointer {
	char	*f_p;
	char	*f_base;
	char	*f_end;
	long	f_len;
	long	f_line;
};
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
#ifdef DEBUG
extern int      _debugmask;
/*
 * debug levels are:
 *
 *     0        show ifn*(def)*,endif
 *     1        trace defined/!defined
 *     2        show #include
 *     3        show #include SYMBOL
 *     4-6      unused
 */
#define debug(level,arg) { if (_debugmask & (1 << level)) warning arg; }
#else
#define debug(level,arg) /**/
#endif /* DEBUG */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void kgendepend_get_args PROTO((kform *));
void kgendepend_usage_additions PROTO((void));
void kgendepend_free_args PROTO((int, kaddr));

/* -include_routines */
    /* cppsetup.c */
 
int cppsetup PROTO((register char *, register struct filepointer *, register struct inclist *));
 
    /* include.c */
 
struct inclist *inc_path PROTO((register char *, register char *, boolean));
void remove_dotdot PROTO((char *));
int isdot PROTO((register char *));
int isdotdot PROTO((register char *));
int issymbolic PROTO((register char *, register char *));
struct inclist *newinclude PROTO((register char *, register char *));
void included_by PROTO((register struct inclist *, register struct inclist *));
void inc_clean PROTO((void));
 
    /* main.c */
 
void process_depend PROTO((int, char **));
struct filepointer *getfile PROTO((char *));
void freefile PROTO((struct filepointer *));
char *copy PROTO((char *));
int match PROTO((char *, char **));
char *getline PROTO((struct filepointer *));
char *base_name PROTO((char *));
void redirect PROTO((char *, char *));
 
    /* parse.c */
 
int find_includes PROTO((struct filepointer *, struct inclist *, struct inclist *, int, boolean));
int gobble PROTO((register struct filepointer *, struct inclist *, struct inclist *));
int deftype PROTO((register char *, register struct filepointer *, register struct inclist *, register struct inclist *, int));
struct symtab *isdefined PROTO((register char *, struct inclist *, struct inclist **));
struct symtab *fdefined PROTO((register char *, struct inclist *, struct inclist **));
int zero_value PROTO((register char *, register struct filepointer *, register struct inclist *));
void define PROTO((char *, struct inclist *));
void define2 PROTO((char *, char *, struct inclist *));
struct symtab *slookup PROTO((register char *, register struct inclist *));
void undefine PROTO((char *, register struct inclist *));
 
    /* pr.c */
 
void add_include PROTO((struct filepointer *, struct inclist *, struct inclist *, char *, boolean, int));
void recursive_pr_include PROTO((register struct inclist *, register char *, register char *));
void pr PROTO((register struct inclist *, char *, char *));
/* -include_routines_end */

#endif
