 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kecho
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kecho.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Echo attributes of toolbox or software object
|
|       Purpose: main program for kecho
|
|         Input:
|		char *clui_info->echo_toggle; {what to echo}
|		int   clui_info->echo_flag; {TRUE if -echo specified}
|
|		char *clui_info->tb_string; {toolbox name}
|		int   clui_info->tb_flag; {TRUE if -tb specified}
|
|		int clui_info->fullpath_flag; {TRUE if -fullpath specified}
|
|		Optional M.E. group:
|		    char *clui_info->oname_string; {Program or Library Object Name}
|		    int   clui_info->oname_flag; {TRUE if -oname specified}
|
|		    char *clui_info->type_string; {type of object}
|		    int   clui_info->type_flag; {TRUE if -type specified}
|
|        Output:
|       Returns:
|
|    Written By: 
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
   kstring   routine    = "main()";

   kobject   toolbox	= NULL;
   kobject   object	= NULL;
   kobject   fileobj	= NULL;
   klist    *olist;
   kstring   tbname;
   kstring   oname;
   kstring   estring;
   kstring   objname;
   kstring   stringval  = NULL;
   int	     attribute  = 0;
   char	   **toolboxes;
   int	     ntbs;
   kstring   path;
   kstring   fullpath;
   int	     otype;
   int	     i;
   int       imakefile  = FALSE;   /* Kludge to make sure Imakefile is seen */
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "BOOTSTRAP");
	kexit_handler(kecho_free_args, NULL);

/* -main_get_args_call */
   pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "BOOTSTRAP", "kecho",
			  kecho_usage_additions);

   if (!(kclui_check_args()))
      kexit(KEXIT_FAILURE);
   kecho_get_args(pane);
   kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
   tbname  = clui_info->tb_string;
   oname   = clui_info->oname_string;
   estring = clui_info->echo_toggle;
   if (clui_info->type_flag)
      reqtype = kcms_attr_string2int(KCMS_CMOBJ_TYPE, clui_info->type_string);

   if (clui_info->oname_flag && !clui_info->tb_flag)
   {
      kerror(NULL, routine,
             "You must specify a toolbox (-tb) with the -oname switch.");
      kexit(KEXIT_FAILURE);
   }

   /*-- if a toolbox was specified, open it ---------------------------*/
   if (clui_info->tb_flag && (toolbox = kcms_open_toolbox(tbname)) == NULL)
   {
      kerror(NULL, routine, "can't open toolbox `%s'\n", tbname);
      kexit(KEXIT_FAILURE);
   }

   /*-- if a software object was specified, then open it --------------*/
   if (clui_info->oname_flag
       && (object = kcms_open_cmobj(toolbox, oname)) == NULL)
   {
      kerror(NULL, routine, "can't open object `%s' in toolbox `%s'\n",
	     oname, tbname);
      kexit(KEXIT_FAILURE);
   }

   if (estring != NULL)
   {
      if (!kstrcmp(estring,"toolboxes"))
      {
	 if ((toolboxes = kcms_query_toolboxes(&ntbs)) == NULL)
	 {
	    kfprintf(kstderr,"can't read TOOLBOX file\n");
	    kexit(KEXIT_FAILURE);
	 }
	 for (i=0; i<ntbs; i++)
	 {
	    kprintf("%s",toolboxes[i]);
	    if (i < ntbs-1)
	       kprintf(" ");
	    else
	       kprintf("\n");
	 }
      }
      else if (!kstrcmp(estring,"objects"))
      {
	 if (tbname == NULL || oname != NULL)
	 {
	    kfprintf(kstderr,"objects: tb, !oname\n");
	    kexit(KEXIT_FAILURE);
	 }

	 kcms_get_attribute(toolbox, KCMS_TB_SOFTWARE_OBJECTS, &olist);

	 for (;olist; olist=klist_next(olist))
	 {
	    object = klist_clientdata(olist);
	    kcms_get_attribute(object, KCMS_NAME, &objname);
	    kcms_get_attribute(object, KCMS_CMOBJ_PROGTYPE, &otype);
	    if (!clui_info->type_flag || otype == reqtype)
	       kprintf("%s ",objname);
	 }
	 kprintf("\n");
      }
      else if (!kstrcmp(estring,"path"))
      {
	 if (tbname == NULL)
	 {
	    kfprintf(kstderr,"need at least a toolbox\n");
	    kexit(KEXIT_FAILURE);
	 }
	 if (oname == NULL)
	 {
	    /*-- toolbox path --*/
	    kcms_get_attribute(toolbox,KCMS_TB_PATH,&path);
	    kprintf("%s\n",path);
	 }
	 else
	 {
	    /*-- object's path --*/
	    kcms_get_attribute(object, KCMS_CMOBJ_OPATH,&path);
	    fullpath = kexpandpath(path,NULL,NULL);
	    kprintf("%s\n",fullpath);
	    kfree(fullpath);
	 }
      }
      else if (!kstrcmp(estring, "version"))
      {
	 if (object == NULL)
	 {
	    /*-- toolbox version --*/
	    kcms_get_attribute(toolbox, KCMS_TB_VERSION, &stringval);
	    kprintf("%s\n", stringval);
	 }
	 else
	 {
	    /*-- object's path --*/
	    kcms_get_attribute(object, KCMS_CMOBJ_VERSION, &stringval);
	    kprintf("%s\n", stringval);
	 }
      }
      else if (!kstrcmp(estring, "poc"))
      {
	 if (object == NULL)
	 {
	    /*-- toolbox version --*/
	    kcms_get_attribute(toolbox, KCMS_TB_AUTHOR, &stringval);
	    kprintf("%s\n", stringval);
	 }
	 else
	 {
	    /*-- object's path --*/
	    kcms_get_attribute(object, KCMS_CMOBJ_AUTHOR, &stringval);
	    kprintf("%s\n", stringval);
	 }
      }
      else if (!kstrcmp(estring, "email"))
      {
	 if (object == NULL)
	 {
	    /*-- toolbox version --*/
	    kcms_get_attribute(toolbox, KCMS_TB_AUTHOR_EMAIL, &stringval);
	    kprintf("%s\n", stringval);
	 }
	 else
	 {
	    /*-- object's path --*/
	    kcms_get_attribute(object, KCMS_CMOBJ_AUTHOR_EMAIL, &stringval);
	    kprintf("%s\n", stringval);
	 }
      }
      else if (!kstrcmp(estring, "object-info"))
      {
	 if (object != NULL)
	    print_object_info(object);
	 else if (toolbox != NULL)
	    kcms_foreach(toolbox, print_object_info, KOBJ_CMSOBJ, TRUE);
      }
      else if (!kstrcmp(estring, "category")
	       || !kstrcmp(estring, "subcategory")
	       || !kstrcmp(estring, "icon")
	       || !kstrcmp(estring, "description")
	       || !kstrcmp(estring, "bname"))
      {
	 if (tbname == NULL || oname == NULL)
	 {
	    kfprintf(kstderr,"need a toolbox and object\n");
	    kexit(KEXIT_FAILURE);
	 }

	 if (!kstrcmp(estring,"category"))
	    attribute = KCMS_CMOBJ_CATEGORY;
	 else if (!kstrcmp(estring,"subcategory"))
	    attribute = KCMS_CMOBJ_SUBCATEGORY;
	 else if (!kstrcmp(estring,"description"))
	    attribute = KCMS_CMOBJ_SHORT_DESC;
	 else if (!kstrcmp(estring,"icon"))
	    attribute = KCMS_CMOBJ_ICON_NAME;
	 else
	    attribute = KCMS_CMOBJ_BNAME;

	 kcms_get_attribute(object, attribute, &stringval);
	 if (stringval == NULL)
	    stringval = "";
	 kprintf("%s\n", stringval);
      }
      else if (!kstrcmp(estring,"allsrc")
	       || !kstrcmp(estring,"allfiles")
	       || !kstrcmp(estring,"src")
	       || !kstrcmp(estring,"ysrc")
	       || !kstrcmp(estring,"lsrc")
	       || !kstrcmp(estring,"fsrc"))
      {
	 if (tbname == NULL || oname == NULL)
	 {
	    kfprintf(kstderr,"need a toolbox and object\n");
	    kexit(KEXIT_FAILURE);
	 }

	 if (!kstrcmp(estring,"allsrc"))
	 {
	    attribute = KCMS_CMOBJ_ALL_SRC;
	 }
	 else if (!kstrcmp(estring,"allfiles"))
	 {
	    attribute = KCMS_CMOBJ_ALL_FILES;
	 }
	 else if (!kstrcmp(estring,"src"))
	 {
	    attribute = 0;
	 }
	 else if (!kstrcmp(estring,"ysrc"))
	 {
	    attribute = 0;
	 }
	 else if (!kstrcmp(estring,"lsrc"))
	 {
	    attribute = 0;
	 }
	 else if (!kstrcmp(estring,"fsrc"))
	 {
	    attribute = 0;
	 }
	 kcms_get_attribute(object, attribute, &olist);

	 for (;olist; olist=klist_next(olist))
	 {
	    fileobj = klist_clientdata(olist);
	    kcms_get_attribute(fileobj, KCMS_FOBJ_FULLNAME, &path);

	    kprintf("%s ",clui_info->fullpath_flag ? 
		    kfullpath(path,NULL,NULL) : path);

	    /* MY/JMAS: Kludge to make sure Imakefile is seen */
	    if (kstrstr(path,"/src/Imakefile") != NULL)
	       imakefile = TRUE;
	 }

	 /* MY/JMAS: Kludge to make sure Imakefile is seen */
	 if (imakefile == FALSE && kstrcmp(estring,"allfiles") == 0)
	 {
	    kcms_get_attribute(object,KCMS_CMOBJ_OPATH,&path);
	    kprintf("%s/src/Imakefile ", path);
	 }
	 kprintf("\n");
      }
      else
      {
	 kfprintf(kstderr,"\nUnknown -echo attribute '%s'\n\n", estring);
	 /*kecho_usage();*/
	 kexit(KEXIT_FAILURE);
      }
   }
/* -main_before_lib_call_end */

/* -main_library_call */
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kecho_usage_additions
| 
|       Purpose: Prints usage additions in kecho_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kecho
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kecho_usage_additions(void)
{
	kfprintf(kstderr, "\tEcho attributes of toolbox or software object\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kecho_free_args
| 
|       Purpose: Frees CLUI struct allocated in kecho_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kecho
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kecho_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->echo_toggle);
	kfree(clui_info->tb_string);
	kfree(clui_info->oname_string);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
