 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for ghostwriter
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "ghostwriter.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Generates code & doc for all software objects.
|
|       Purpose: main program for ghostwriter
|
|         Input:
|		char *clui_info->tb_string; {toolbox name}
|		int   clui_info->tb_flag; {TRUE if -tb specified}
|
|		char *clui_info->oname_string; {object name}
|		int   clui_info->oname_flag; {TRUE if -oname specified}
|
|		int clui_info->force_flag; {TRUE if -force specified}
|
|		int clui_info->debug_flag; {TRUE if -debug specified}
|
|        Output:
|       Returns:
|
|    Written By: Danielle Argiro
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
	kstring  routine = "main()";
	kstring  tbname  = NULL;
	kstring  oname   = NULL;
	kobject  program;
	kobject  toolbox;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "BOOTSTRAP");
	kexit_handler(ghostwriter_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "BOOTSTRAP", 
			       "ghostwriter", ghostwriter_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	ghostwriter_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	/*-- were toolbox or object name given on the command-line? ---*/
	if (clui_info->tb_flag)
	   tbname = kstrdup(clui_info->tb_string);
	if (clui_info->oname_flag)
	   oname = kstrdup(clui_info->oname_string);

	/*-- if not, try and parse them from an Imakefile -------------*/
	if (!kcms_get_imake_symbols(&tbname, &oname, NULL, NULL))
	{
	   kerror(NULL, routine, "Could not determine toolbox and object "
		  "names, so nothing was generated\n");
	   kexit(KEXIT_FAILURE);
	}

        if ((toolbox = kcms_open_toolbox(tbname)) == NULL)
        {
            kerror(NULL,"main()","Cannot open toolbox object '%s'\n", tbname);
            kexit(KEXIT_FAILURE);
        }

        /*
         * If program is NULL, call kerror() to print
         * an appropriate error mesg.
         */
        if ((program = kcms_open_cmobj(toolbox, oname)) == NULL)
        {
            kerror(NULL,"main()","Cannot open software object '%s' "
                        "within the toolbox '%s'\n", oname, tbname);
            kcms_close(toolbox);
            kexit(KEXIT_FAILURE);
        }

        if (clui_info->force_flag)
	   kcms_set_bit(program, KCMS_CMOBJ_FLAGS, KCMS_BIT_CMOBJ_FORCE);

	if (clui_info->debug_flag)
		kcms_set_bit(program, KCMS_CMOBJ_FLAGS,
			     KCMS_BIT_CMOBJ_GENDEBUG);
/* -main_before_lib_call_end */

/* -main_library_call */
	(void) kgen_generate_clui(program);
/* -main_library_call_end */

/* -main_after_lib_call */
	kcms_close(program);
	kcms_close(toolbox);
	kfree(tbname);
	kfree(oname);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: ghostwriter_usage_additions
| 
|       Purpose: Prints usage additions in ghostwriter_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname ghostwriter
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void ghostwriter_usage_additions(void)
{
	kfprintf(kstderr, "\tGenerates code & doc for all software objects.\n");

/* -usage_additions */
	kfprintf(kstderr,
		 "\n\tNote:\n\tIf you omit the command line arguments [-tb] and [-oname]\n");
	kfprintf(kstderr,
		 "\tand the Imakefile exists in the local directory, the\n");
	kfprintf(kstderr,
		 "\tdefault values will be derived from the Imakefile.  However,\n");
	kfprintf(kstderr,
		 "\tif the Imakefile does not exist, an error will occur.\n");
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: ghostwriter_free_args
| 
|       Purpose: Frees CLUI struct allocated in ghostwriter_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname ghostwriter
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
ghostwriter_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->tb_string);
	kfree(clui_info->oname_string);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
