/*
 * Khoros: $Id$
 */
 
#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            File Title
   >>>>
   >>>>  Static:
   >>>>  Public:
   >>>>             ReadLine()
   >>>>             ProcessLine()
   >>>>             WriteLine()
   >>>>             mycpp()
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include <bootstrap.h>
#include <kutils/ksignal.h>
#include "kimakedef.h"

#define REVSIZE 9
static char *rev_str[9] = {
	"LD_RUN_PATH",
	"C_TOOLBOX_LIBRARIES",
	"C_TOOLBOX_DEP_LIBRARIES",
	"FOR_TOOLBOX_LIBRARIES",
	"FOR_TOOLBOX_DEP_LIBRARIES",
	"X_TOOLBOX_LIBRARIES",
	"X_TOOLBOX_DEP_LIBRARIES",
	"TOOLBOX_LIBDIR",
	"TOOLBOX_INCLUDE" };
	
static int   rev_num[9] = { 0, 0, 0, 0, 0, 0, 0, 0, 0 };
static int   token_last = -1;
static int   token_next = 1;
static int   token_tablesize = 0;
static char  **token_table = NULL;
static kilist **hash_table = NULL;
static kilist *symbol_list = NULL;

static int   saw_first_target = FALSE;

/*-----------------------------------------------------------
|
|  Routine Name: KReadLine - Read a line from the Makefile
|
|       Purpose: Similiar in function to a kfgets, but it deals with
|		 the fact that Makefiles can have line continuations via
|		 a '\' at the end of a line.
|
|         Input: infile - FILE stream to read from
|       Returns: a pointer to the read line, or NULL on end of file
|
|    Written By: Steven Jorgensen
|          Date: Jan 10, 1995
| Modifications:
------------------------------------------------------------*/
char *KReadLine(infile)
	FILE *infile;
{
   char *tmp, *tmp1, *line = NULL, temp[10*LENGTH];
   int eos, done = FALSE;
   if (infile == NULL)
      return NULL;
   while (done == FALSE && fgets(temp, 10*LENGTH, infile) != NULL)
   {
      eos = kstrlen(temp);
      if (temp[eos-2] == '\\')
	 temp[eos-2] = '\0';
      else
	 done = TRUE;
      tmp1 = line;
      if (line != NULL)
      {
         tmp = kstring_cleanup(temp, NULL);
         line = kstring_3cat(tmp1, " ", tmp, NULL);
	 kfree(tmp);
      }
      else
         line = kstring_copy(temp, NULL);
      if (line == NULL && eos > 0)
	 line = " ";
      kfree(tmp1);
   }
   return line;
}

/*-----------------------------------------------------------
|
|  Routine Name: make_ret_str - make a string with all the symbols in it
|
|       Purpose:
|         Input:
|        Output:
|       Returns:
|    Written By: Steven Jorgensen
|          Date: Mar 28, 1995
| Modifications:
|
------------------------------------------------------------*/
static char *make_ret_str(str)
   char *str;
{
   char *tmp1 = NULL, *tmp2 = NULL;
   kilist *head;
   for (head = kilist_head(symbol_list); head != NULL; head=head->next)
   {
      if (head->client_data == NULL)
	 continue;
      tmp1 = kstring_3cat(tmp2, ktoken_to_string(head->identifier), " = ",
			     NULL);
      kfree(tmp2);
      tmp2 = kstring_3cat(tmp1, head->client_data, "\n", NULL);
      kfree(tmp1);
   }
   tmp1 = kstring_3cat(tmp2, str, NULL, NULL);
   kfree(tmp2);
   return(tmp1);
}

/*-----------------------------------------------------------
|
|  Routine Name: KProcessLine - Process a line from the Makefile
|
|       Purpose: This routine processes lines that set macro
|		 values.  Macro lines set with the = symbol
|		 remembers both the variable name and its value.
|		 += lines are removed for make programs that do
|		 not support this extention (i.e:
|
|		 VARIABLE = first_val
|		 (other lines)
|		 VARAIBLE += append_val1
|		 (other lines)
|		 VARAIBLE += append_val2
|
|		 becomes:
|		 
|		 VARIABLE = first_val
|		 (other lines)
|		 VARAIBLE = first_val append_val1
|		 (other lines)
|		 VARAIBLE = first_val append_val1 append_val2
|
|		 On systems that have a make which supports the +=
|		 feature, no processing is done on the line.
|
|         Input: str - char string to read from
|       Returns: a pointer to the new line, or NULL on error
|    Written By: Steven Jorgensen
|          Date: Jan 10, 1995
------------------------------------------------------------*/
char *KProcessLine(str)
	char *str;
{
   char *newline = NULL, *tmp, *tmp1, *temp, *valname;
   char assignment[LENGTH], varname[LENGTH];
   static int re_compiled = FALSE;
   kilist *sltmp = NULL;
   int var_token = 0, mset = TRUE, mcset = TRUE, i, prepend = FALSE;

   if (!re_compiled)
   {
      if ((tmp = kre_comp("^\\s*([\\w+]+)\\s*((\\+|\\+:)?=)(.*)$")) != NULL)
      {
	 fprintf(stderr, "kre_comp failed.  Error returned is\n\n'%s'\n\n",
		 tmp);
	 return NULL;
      }
      re_compiled = TRUE;
   }

   if (kre_exec(str) == FALSE)
   {
      if (saw_first_target == TRUE)
         return kstrdup(str);
      re_compiled = FALSE;
      if ((tmp = kre_comp("^[$()\\w_]+:.*$")) != NULL)
      {
	 fprintf(stderr, "kre_comp failed.  Error returned is\n\n'%s'\n\n",
		 tmp);
	 return NULL;
      }
      saw_first_target = kre_exec(str);
      if (saw_first_target == TRUE)
	 return make_ret_str(str);
      return kstrdup(str);
   }
   if ((temp = (char *) kmalloc(kstrlen(str))) == NULL)
   {
      fprintf(stderr, "Could not malloc space for macro value\n");
      return NULL;
   }
   assignment[0] = '\0';
   kre_subs("\\1", varname);
   kre_subs("\\2", assignment);
   kre_subs("\\4", temp);
   valname = kstring_cleanup(temp, NULL);
   kfree(temp);
   mset = (strcmp(assignment, "+=") == 0) ? FALSE : TRUE;
   mcset = (strcmp(assignment, "+:=") == 0) ? FALSE : TRUE;
   var_token = kstring_to_token(varname);
   for (i = 0; i < REVSIZE; i++)
   {
      prepend = (var_token == rev_num[i]);
      if (prepend)
	 break;
   }
   sltmp = kilist_locate(symbol_list, var_token);
   if ((mset && mcset) || sltmp == NULL)
   {
      if (sltmp != NULL)
         kfree(sltmp->client_data);
      symbol_list = kilist_delete(symbol_list, var_token);
      symbol_list = kilist_add(symbol_list, var_token, valname);
   }
   else if (valname != NULL)
   {
      tmp = kstrstr(sltmp->client_data, valname);
      if (tmp == NULL || !isspace(tmp[kstrlen(valname)]))
      {
         tmp = sltmp->client_data;
         if (prepend && mcset)
            sltmp->client_data = kstring_3cat(valname, " \\\n \t\t", tmp,NULL);
         else if (mcset)
	    sltmp->client_data = kstring_3cat(tmp, " \\\n \t\t", valname,NULL);
         else if (prepend)
	    sltmp->client_data = kstring_3cat(valname, ":", tmp,NULL);
         else
            sltmp->client_data = kstring_3cat(tmp, ":", valname,NULL);
         kfree(valname);
         kfree(tmp);
      }
   }
   if (saw_first_target == FALSE)
      return NULL;

   sltmp = kilist_locate(symbol_list, var_token);
   if (sltmp->client_data == NULL)
      return NULL;
   tmp = kstring_3cat(varname, " = ", sltmp->client_data, NULL);
   tmp1 = kstring_cat(tmp, "\n", NULL);
   kfree(tmp);
   return tmp1;
}



/*-----------------------------------------------------------
|
|  Routine Name: mycpp - Remove the += Symbols from the Makefile
|
|       Purpose: This routine parses the Makefile looking for lines
|		 with += in them.  It replaces the += syntax with a
|		 correctly appended = version.
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|    Written By: Steven Jorgensen
|          Date: Mar 06, 1995
| Modifications:
|
------------------------------------------------------------*/
int kcpp()
{

   char *bkpath  = "./Makefile.bak";
   char *newpath = "./Makefile.new";
   char *path    = "./Makefile";
   FILE *infile  = NULL;
   FILE *outfile = NULL;
   char *line    = NULL;
   char *outline    = NULL;
   int   i;

   if (access(path, F_OK) == -1)
   {
      fprintf(stderr, "No Makefile to work with.\n");
      return FALSE;
   }
   if (access(bkpath, F_OK) == 0)
   {
      if (unlink(bkpath) == -1)
      {
	 fprintf(stderr, "Cannot remove '%s'\n", bkpath);
	 return FALSE;
      }
   }
   if ((infile = fopen(path,"r")) == NULL)
   {
      fprintf(stderr, "Cannot open '%s' for processing\n", path);
      return FALSE;
   }
   if ((outfile = fopen(newpath,"w")) == NULL)
   {
      fprintf(stderr, "Cannot open '%s' for output\n", newpath);
      return FALSE;
   }

   for (i = 0; i < REVSIZE; i++)
      rev_num[i] = kstring_to_token(rev_str[i]);

   while((line = KReadLine(infile)) != NULL)
   {
      outline = KProcessLine(line);
      kfree(line);
      if (outline != NULL)
      {
         fputs(outline, outfile);
         kfree(outline);
      }
   }

   fclose(infile);
   fclose(outfile);
   if (unlink(path) == -1)
   {
      fprintf(stderr, "Cannot remove '%s'\n", path);
      return FALSE;
   }
   if (rename(newpath, path) == -1)
   {
      fprintf(stderr, "Cannot rename '%s' to '%s'\n", newpath, path);
      return FALSE;
   }

   return TRUE;
}
