/*
 * Khoros: $Id$
 */

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                          <<<<
   >>>>       Purpose: contains routine declarations that are    <<<<
   >>>>                private to the kforms library, but used   <<<<
   >>>>                by exceptions such as cantata, conductor, <<<<
   >>>>                ghostwriter, and conductor-generated code <<<<
   >>>>                                                          <<<<
   >>>>    Written By: Danielle Argiro                           <<<<
   >>>>                                                          <<<<
   >>>>          Date: March 29, 1993                            <<<<
   >>>>                                                          <<<<
   >>>> Modifications:                                           <<<<
   >>>>                                                          <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _kforms_kformsP_h_
#define _kforms_kformsP_h_

        /*-------------------------------------*
        |       #include
        ---------------------------------------*/

        /*-------------------------------------*
        |       #defines
        ---------------------------------------*/

        /*-------------------------------------*
        |       typedefs
        ---------------------------------------*/


/***********	kselection   structure ******/

typedef struct _kselection {

xvobject back;             /* the backplane of the selection                 */
xvobject value_object;     /* the value object of the selection              */
xvobject opt_object;       /* the optional object of selection               */
xvobject label_object;     /* the label object of the selection              */
xvobject pix_object;       /* the <cr> pixmap object for live selections     */
xvobject scroll;           /* scroll bar of integer or float                 */
xvobject submenu;          /* value object is menubutton, holds submenu      */
xvobject *submenu_buttons; /* value object is menubutton, holds menu buttons */

klist  *extra_call_list; /* additional callback routines, if desired         */

char   *line;	         /* UIS line assoc w/ this selection                 */
char   *comment;         /* comment preceding UIS line                       */

int    type;	         /* typeflag identifying type of selection           */
int    modified;	 /* tells cantata if selection has changed           */
int    selected;         /* (for "live"), true when user changes selection   */
int    opt_selected;     /* (for "optional") true when optional button set   */
int    toggle_num;       /* id of toggle member (# of order of appearance)   */
int    prev_selected;    /* in an ME group, TRUE if previously selected      */
                         /* also used by displaylist to indicate doubleclick */
int    name_token;	 /* full name of selection in token form             */
int    var_token;	 /* variable name of selection in token form         */
int    extension_num;    /* number of extensions in extension array          */

struct _kselection    *toggle_next;      /* list of members in toggle        */
struct _kform_struct  *submenu_next;     /* next item in submenu             */
struct _kselection    *group_next;       /* next item in ME/MI group         */

struct _kselection    *back_group;       /* backlink to ME/MI group hdr      */
struct _kselection    *back_submenu;     /* backlink to submenu hdr          */
struct _kselection    *back_toggle;      /* backlink to toggle hdr           */
struct _kcontrol      *back_control;     /* backlink to control              */
struct _kguide        *back_guide;       /* backlink to guide                */
struct _ksubform      *back_subform;     /* backlink to subform              */
struct _kform         *back_form;        /* backlink to form                 */
struct _kform_struct  *back_kformstruct; /* backlink to kformstruct          */
struct _kselection    **extensions;      /* extensions for wksp GUI          */
struct _kselection    *next;             /* ptr to the next selection        */

} kselection;


/******	kcontrol structure: for masters, guidepanes, & panes  *****/

typedef struct _kcontrol {

xvobject back;               /* backplane of the master, guidepane, or pane  */
xvobject label_object;       /* label object for master, guidepane, or pane  */

char   *control_line;        /* -S, -G, or -P line defining control panel    */
char   *control_comment;     /* comment preceding -S, -G, or -P line         */
char   **sel_names;          /* keeps track of selection variable names      */

int    type;                 /* indicates one of master, guidepane, or pane  */
int    excl_subforms;        /* (if master) true if subforms are M.E.        */
int    sel_count;            /* size of sel_names array                      */
int    name_token;           /* full name of control in token form           */
int    var_token;	     /* variable name of control in token form       */

struct _kselection    *sel_list;     /* selection list (pane)                */
struct _kguide        *guide_list;   /* guide button list (guidepane)        */
struct _ksubform      *subform_list; /* subform button list (master)         */

struct _kguide        *back_guide;   /* backlink to guide (if pane)          */
struct _ksubform      *back_subform; /* backlink to subform (if guidepane)   */
struct _kform         *back_form;    /* backlink to form (if master)         */
struct _kform_struct  *back_kformstruct; /* backlink to kformstruct          */

} kcontrol;


/***********	kguide structure *****/

typedef struct _kguide {

xvobject   button;                   /* guide button object                  */

klist    *extra_call_list;           /* additional callback routine          */

char     *line;	                     /* -g UIS line                          */
char     *comment;	             /* comment preceding -g UIS line        */
char     *control_line;              /* controlling UIS line -P              */

int      selected;	             /* true if this guide is selected       */
int      name_token;                 /* full name of guide in token form     */
int      var_token;	             /* variable name of guide as token      */

kcontrol          *pane;             /* the associated pane structure        */
struct _kform_struct *submenu_next;  /* next item in submenu                 */

kselection           *back_submenu;     /* backlink to submenu hdr           */
struct _kcontrol     *back_control;     /* backlink to guidepane             */
struct _ksubform     *back_subform;     /* backlink to subform (if single)   */
struct _kform        *back_form;        /* backlink to form                  */
struct _kform_struct *back_kformstruct; /* backlink to kformstruct           */

struct _kguide       *next;             /* ptr to next guide button          */

} kguide;



/*****	ksubform  structure ******/

typedef struct _ksubform {

xvobject   toplevel; 	    /* toplevel of the subform                       */
xvobject   label_object;    /* label object for subform title                */
xvobject   back; 	    /* backplane of the subform                      */
xvobject   button; 	    /* subform button object                         */

klist    *extra_call_list;  /* additional callback routine                   */

char     *line;             /* -d UIS line assoc w/ subform button           */
char     *comment;          /* comment preceding -d UIS line                 */
char     *control_line;     /* controlling UIS line -M                       */
char     *control_comment;  /* comment preceding -M line                     */

int	 quit;	            /* true when subform exiting                     */
int      type; 	            /* SubformButton or PsuedoSubform                */
int	 selected;	    /* true if this subform is selected              */
int      name_token;        /* full name of subform in token form            */
int      var_token;	    /* variable name of subform as token             */

kcontrol          *guidepane;       /* guidepane structure (if -G exists)    */
kguide            *guide;           /* points to single guide (no guidepane) */
struct _kform_struct *submenu_next; /* next item in submenu                  */

kselection           *back_submenu;     /* backlink to submenu hdr           */
kcontrol             *back_control;     /* backlink to master                */
struct _kform        *back_form;        /* backlink to form                  */
struct _kform_struct *back_kformstruct; /* backlink to kformstruct           */
struct _ksubform  *next;                /* ptr to next subform               */

} ksubform;



/*****	kform  structure ******/

typedef struct _kform {

xvobject toplevel; 	          /* toplevel of the form                    */

char    *control_line;            /* controlling -F UIS line                 */
char    *control_comment;         /* comment preceding -F line               */
char    *uis_location;            /* directory with associated UIS file      */

int    editable;                  /* TRUE only if this form is editable      */
int    quit;		          /* true when form is exiting               */
int    var_token;	          /* variable name of form as token          */

kcontrol *master;                 /* master structure (if -S exists)         */
ksubform *subform;                /* points to single subform (no master)    */

struct _kform_struct *back_kformstruct; /* backlink to kformstruct           */


} kform;


/****** generic kform_struct ********/

typedef struct _kform_struct {

int   type;           /* KFORM, KSUBFORM, KGUIDE, KCONTROL, or KSELECTION */
int   flag;           /* type of UIS line, such as KUIS_INPUTFILE         */
char  *client_data;   /* client data of callback routine                  */
klist *callback_list; /* list of callbacks for changed attributes         */

   /* generic kform_struct will hold only one of the following:           */
union {
	 kform	    *formptr;       /* pointer to form                    */
	 ksubform   *subformptr;    /* pointer to subform                 */
	 kguide     *guideptr;      /* pointer to guide                   */
	 kcontrol   *controlptr;    /* pointer to control                 */
         kselection *selptr;        /* pointer to selection               */
      } u;

struct _kform_struct *next;        /* next kform_struct in a list         */

}  kform_struct;

/*
 *  The form_list structure is used maintain
 *  lists of form trees
 */
typedef struct _kform_list
{
    int		type;		/* KFORM or KSUBFORM			      */
    kaddr       treeptr;        /* points to either a kform or ksubform       */
    int         busy;           /* whether to map the busy window on callback */
    kfunc_void  routine;        /* callback routine, iff applicable           */
    char        *client_data;   /* client data of callback routine            */
    struct _kform_list *next, *prev;
} kform_list;

        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

        /*-------------------------------------*
        |       macros
        ---------------------------------------*/

        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/

/*
 *  NOTE: all kforms get/set attribute routines are declared here
 *        so that the xvforms library can call them directly,
 *        which is more efficient than calling them via kvf_get/set_attributes()
 *
 * attributes.c 
 */
int kvf_vget_attributes PROTO((kform_struct *, kva_list));
int kvf_vset_attributes PROTO((kform_struct *, kva_list));

/*
 * attrib_tbl.c
 */
void kvf_init_attributes PROTO((void));

/*
 *  attrib_gen.c - general set & get routines
 */
int kvf_get_activate         PROTO((kform_struct *, char *, kaddr));
int kvf_set_activate         PROTO((kform_struct *, char *, kaddr));
int kvf_get_selected         PROTO((kform_struct *, char *, kaddr));
int kvf_set_selected         PROTO((kform_struct *, char *, kaddr));
int kvf_get_optional         PROTO((kform_struct *, char *, kaddr));
int kvf_set_optional         PROTO((kform_struct *, char *, kaddr));
int kvf_get_optsel           PROTO((kform_struct *, char *, kaddr));
int kvf_set_optsel           PROTO((kform_struct *, char *, kaddr));
int kvf_get_live             PROTO((kform_struct *, char *, kaddr));
int kvf_set_live             PROTO((kform_struct *, char *, kaddr));

int kvf_get_variable         PROTO((kform_struct *, char *, kaddr));
int kvf_set_variable         PROTO((kform_struct *, char *, kaddr));
int kvf_get_description      PROTO((kform_struct *, char *, kaddr));
int kvf_set_description      PROTO((kform_struct *, char *, kaddr));
int kvf_get_title            PROTO((kform_struct *, char *, kaddr));
int kvf_set_title            PROTO((kform_struct *, char *, kaddr));
int kvf_get_buttontitle      PROTO((kform_struct *, char *, kaddr));
int kvf_set_buttontitle      PROTO((kform_struct *, char *, kaddr));
int kvf_get_guidepanetitle   PROTO((kform_struct *, char *, kaddr));
int kvf_set_guidepanetitle   PROTO((kform_struct *, char *, kaddr));
int kvf_get_literal          PROTO((kform_struct *, char *, kaddr));
int kvf_set_literal          PROTO((kform_struct *, char *, kaddr));
int kvf_get_modified         PROTO((kform_struct *, char *, kaddr));
int kvf_set_modified         PROTO((kform_struct *, char *, kaddr));

int kvf_get_width            PROTO((kform_struct *, char *, kaddr));
int kvf_set_width            PROTO((kform_struct *, char *, kaddr));
int kvf_get_height           PROTO((kform_struct *, char *, kaddr));
int kvf_set_height           PROTO((kform_struct *, char *, kaddr));
int kvf_get_x                PROTO((kform_struct *, char *, kaddr));
int kvf_set_x                PROTO((kform_struct *, char *, kaddr));
int kvf_get_y                PROTO((kform_struct *, char *, kaddr));
int kvf_set_y                PROTO((kform_struct *, char *, kaddr));
int kvf_get_buttonwidth      PROTO((kform_struct *, char *, kaddr));
int kvf_set_buttonwidth      PROTO((kform_struct *, char *, kaddr));
int kvf_get_buttonheight     PROTO((kform_struct *, char *, kaddr));
int kvf_set_buttonheight     PROTO((kform_struct *, char *, kaddr));
int kvf_get_buttonx          PROTO((kform_struct *, char *, kaddr));
int kvf_set_buttonx          PROTO((kform_struct *, char *, kaddr));
int kvf_get_buttony          PROTO((kform_struct *, char *, kaddr));
int kvf_set_buttony          PROTO((kform_struct *, char *, kaddr));
int kvf_get_xpos             PROTO((kform_struct *, char *, kaddr));
int kvf_set_xpos             PROTO((kform_struct *, char *, kaddr));
int kvf_get_ypos             PROTO((kform_struct *, char *, kaddr));
int kvf_set_ypos             PROTO((kform_struct *, char *, kaddr));

int kvf_get_workspace        PROTO((kform_struct *, char *, kaddr));
int kvf_set_workspace        PROTO((kform_struct *, char *, kaddr));

int kvf_get_clientdata       PROTO((kform_struct *, char *, kaddr));
int kvf_set_clientdata       PROTO((kform_struct *, char *, kaddr));

int kvf_set_delete           PROTO((kform_struct *, char *, kaddr));
int kvf_set_display_subform  PROTO((kform_struct *, char *, kaddr));
int kvf_set_display_pane     PROTO((kform_struct *, char *, kaddr));
int kvf_get_me_subforms      PROTO((kform_struct *, char *, kaddr));
int kvf_set_me_subforms      PROTO((kform_struct *, char *, kaddr));

/*
 *  attrib_print.c - set & get routines for printing UIS files
 */
int kvf_get_print_uis        PROTO((kform_struct *, char *, kaddr));
int kvf_set_print_uis        PROTO((kform_struct *, char *, kaddr));
int kvf_get_print_pane       PROTO((kform_struct *, char *, kaddr));
int kvf_set_print_pane       PROTO((kform_struct *, char *, kaddr));
int kvf_get_print_subform    PROTO((kform_struct *, char *, kaddr));
int kvf_set_print_subform    PROTO((kform_struct *, char *, kaddr));
int kvf_get_uis_location     PROTO((kform_struct *, char *, kaddr));
int kvf_set_uis_location     PROTO((kform_struct *, char *, kaddr));
int kvf_get_pane_file        PROTO((kform_struct *, char *, kaddr));
int kvf_set_pane_file        PROTO((kform_struct *, char *, kaddr));
int kvf_get_subform_file     PROTO((kform_struct *, char *, kaddr));
int kvf_set_subform_file     PROTO((kform_struct *, char *, kaddr));

/*
 *  attrib_str.c - set & get routines for files, strings
 */
int kvf_get_file_name        PROTO((kform_struct *, char *, kaddr));
int kvf_set_file_name        PROTO((kform_struct *, char *, kaddr));
int kvf_get_file_check       PROTO((kform_struct *, char *, kaddr));
int kvf_set_file_check       PROTO((kform_struct *, char *, kaddr));
int kvf_get_file_def         PROTO((kform_struct *, char *, kaddr));
int kvf_set_file_def         PROTO((kform_struct *, char *, kaddr));
int kvf_get_string_val       PROTO((kform_struct *, char *, kaddr));
int kvf_set_string_val       PROTO((kform_struct *, char *, kaddr));
int kvf_get_string_def       PROTO((kform_struct *, char *, kaddr));
int kvf_set_string_def       PROTO((kform_struct *, char *, kaddr));
int kvf_get_string_multiline PROTO((kform_struct *, char *, kaddr));
int kvf_set_string_multiline PROTO((kform_struct *, char *, kaddr));

/*
 *  attrib_misc.c - set & get routines for logicals
 */
int kvf_get_logic_val         PROTO((kform_struct *, char *, kaddr));
int kvf_set_logic_val         PROTO((kform_struct *, char *, kaddr)); 
int kvf_get_logic_def         PROTO((kform_struct *, char *, kaddr));
int kvf_set_logic_def         PROTO((kform_struct *, char *, kaddr));
int kvf_get_logic_label       PROTO((kform_struct *, char *, kaddr));
int kvf_set_logic_label       PROTO((kform_struct *, char *, kaddr));


/*
 *  attrib_misc.c - set & get routines for cycles & lists
 */
int kvf_get_list_size         PROTO((kform_struct *, char *, kaddr));
int kvf_set_list_size         PROTO((kform_struct *, char *, kaddr));
int kvf_get_list_val          PROTO((kform_struct *, char *, kaddr));
int kvf_set_list_val          PROTO((kform_struct *, char *, kaddr));
int kvf_get_list_item         PROTO((kform_struct *, char *, kaddr));
int kvf_set_list_item         PROTO((kform_struct *, char *, kaddr));
int kvf_get_list_index        PROTO((kform_struct *, char *, kaddr));
int kvf_set_list_index        PROTO((kform_struct *, char *, kaddr)); 
int kvf_get_list_label        PROTO((kform_struct *, char *, kaddr));
int kvf_set_list_label        PROTO((kform_struct *, char *, kaddr));
int kvf_get_list_start        PROTO((kform_struct *, char *, kaddr));
int kvf_set_list_start        PROTO((kform_struct *, char *, kaddr));
int kvf_get_list_choices      PROTO((kform_struct *, char *, kaddr));
int kvf_set_list_choices      PROTO((kform_struct *, char *, kaddr));
int kvf_get_list_contents     PROTO((kform_struct *, char *, kaddr));
int kvf_set_list_contents     PROTO((kform_struct *, char *, kaddr));
int kvf_get_list_doubleclick  PROTO((kform_struct *, char *, kaddr));
int kvf_set_list_doubleclick  PROTO((kform_struct *, char *, kaddr));
int kvf_set_list_add          PROTO((kform_struct *, char *, kaddr));
int kvf_set_list_delete       PROTO((kform_struct *, char *, kaddr));
int kvf_set_list_deleteall    PROTO((kform_struct *, char *, kaddr));
int kvf_get_val_labels        PROTO((kform_struct *, char *, kaddr));

/*
 *  attrib_misc.c - miscellaneous set & get routines
 */
int kvf_get_exectype          PROTO((kform_struct *, char *, kaddr));
int kvf_set_exectype          PROTO((kform_struct *, char *, kaddr));

int kvf_get_routine           PROTO((kform_struct *, char *, kaddr));
int kvf_set_routine           PROTO((kform_struct *, char *, kaddr));

int kvf_get_help_path         PROTO((kform_struct *, char *, kaddr));
int kvf_set_help_path         PROTO((kform_struct *, char *, kaddr));

/*
 *  attrib_int.c - set & get routines for integers
 */
int kvf_get_nobounds_sel      PROTO((kform_struct *, char *, kaddr));
int kvf_set_nobounds_sel      PROTO((kform_struct *, char *, kaddr));
int kvf_get_bounds_sel        PROTO((kform_struct *, char *, kaddr));
int kvf_set_bounds_sel        PROTO((kform_struct *, char *, kaddr));

int kvf_get_int_gt0_sel       PROTO((kform_struct *, char *, kaddr));
int kvf_set_int_gt0_sel       PROTO((kform_struct *, char *, kaddr));
int kvf_get_int_ge0_sel       PROTO((kform_struct *, char *, kaddr));
int kvf_set_int_ge0_sel       PROTO((kform_struct *, char *, kaddr));
int kvf_get_int_lt0_sel       PROTO((kform_struct *, char *, kaddr));
int kvf_set_int_lt0_sel       PROTO((kform_struct *, char *, kaddr));
int kvf_get_int_le0_sel       PROTO((kform_struct *, char *, kaddr));
int kvf_set_int_le0_sel       PROTO((kform_struct *, char *, kaddr));
int kvf_get_int_upper         PROTO((kform_struct *, char *, kaddr));
int kvf_set_int_upper         PROTO((kform_struct *, char *, kaddr));
int kvf_get_int_lower         PROTO((kform_struct *, char *, kaddr));
int kvf_set_int_lower         PROTO((kform_struct *, char *, kaddr));

int kvf_get_int_def           PROTO((kform_struct *, char *, kaddr));
int kvf_set_int_def           PROTO((kform_struct *, char *, kaddr));
int kvf_get_int_val           PROTO((kform_struct *, char *, kaddr));
int kvf_set_int_val           PROTO((kform_struct *, char *, kaddr));

/*
 *  attrib_flt.c - set & get routines for floats
 */
int kvf_get_float_gt0_sel     PROTO((kform_struct *, char *, kaddr));
int kvf_set_float_gt0_sel     PROTO((kform_struct *, char *, kaddr));
int kvf_get_float_ge0_sel     PROTO((kform_struct *, char *, kaddr));
int kvf_set_float_ge0_sel     PROTO((kform_struct *, char *, kaddr));
int kvf_get_float_lt0_sel     PROTO((kform_struct *, char *, kaddr));
int kvf_set_float_lt0_sel     PROTO((kform_struct *, char *, kaddr));
int kvf_get_float_le0_sel     PROTO((kform_struct *, char *, kaddr));
int kvf_set_float_le0_sel     PROTO((kform_struct *, char *, kaddr));
int kvf_get_float_upper       PROTO((kform_struct *, char *, kaddr));
int kvf_set_float_upper       PROTO((kform_struct *, char *, kaddr));
int kvf_get_float_lower       PROTO((kform_struct *, char *, kaddr));
int kvf_set_float_lower       PROTO((kform_struct *, char *, kaddr));

int kvf_get_float_def         PROTO((kform_struct *, char *, kaddr));
int kvf_set_float_def         PROTO((kform_struct *, char *, kaddr));
int kvf_get_float_val         PROTO((kform_struct *, char *, kaddr));
int kvf_set_float_val         PROTO((kform_struct *, char *, kaddr));

int kvf_get_precision         PROTO((kform_struct *, char *, kaddr));
int kvf_set_precision         PROTO((kform_struct *, char *, kaddr));
int kvf_get_mechanism         PROTO((kform_struct *, char *, kaddr));
int kvf_set_mechanism         PROTO((kform_struct *, char *, kaddr));

/*
 *  attrib_dbl.c - set & get routines for doubles
 */
int kvf_get_double_gt0_sel    PROTO((kform_struct *, char *, kaddr));
int kvf_set_double_gt0_sel    PROTO((kform_struct *, char *, kaddr));
int kvf_get_double_ge0_sel    PROTO((kform_struct *, char *, kaddr));
int kvf_set_double_ge0_sel    PROTO((kform_struct *, char *, kaddr));
int kvf_get_double_lt0_sel    PROTO((kform_struct *, char *, kaddr));
int kvf_set_double_lt0_sel    PROTO((kform_struct *, char *, kaddr));
int kvf_get_double_le0_sel    PROTO((kform_struct *, char *, kaddr));
int kvf_set_double_le0_sel    PROTO((kform_struct *, char *, kaddr));
int kvf_get_double_upper      PROTO((kform_struct *, char *, kaddr));
int kvf_set_double_upper      PROTO((kform_struct *, char *, kaddr));
int kvf_get_double_lower      PROTO((kform_struct *, char *, kaddr));
int kvf_set_double_lower      PROTO((kform_struct *, char *, kaddr));

int kvf_get_double_def        PROTO((kform_struct *, char *, kaddr));
int kvf_set_double_def        PROTO((kform_struct *, char *, kaddr));
int kvf_get_double_val        PROTO((kform_struct *, char *, kaddr));
int kvf_set_double_val        PROTO((kform_struct *, char *, kaddr));

/*
 *  attrib_toggle.c - set & get routines for toggles
 */
int kvf_get_toggle_size       PROTO((kform_struct *, char *, kaddr));
int kvf_set_toggle_size       PROTO((kform_struct *, char *, kaddr));
int kvf_set_toggle_num        PROTO((kform_struct *, char *, kaddr));
int kvf_get_toggle_num        PROTO((kform_struct *, char *, kaddr));
int kvf_set_toggle_val        PROTO((kform_struct *, char *, kaddr));
int kvf_get_toggle_val        PROTO((kform_struct *, char *, kaddr));
int kvf_get_toggle_type       PROTO((kform_struct *, char *, kaddr));
int kvf_set_toggle_members    PROTO((kform_struct *, char *, kaddr));
int kvf_get_toggle_contents   PROTO((kform_struct *, char *, kaddr));
int kvf_get_toggle_contents_desc PROTO((kform_struct *, char *, kaddr));

int kvf_change_intbounds    PROTO((kform_struct *, char *));
int kvf_change_floatbounds  PROTO((kform_struct *, char *));
int kvf_change_doublebounds PROTO((kform_struct *, char *));

/* 
 *  NOTE: guise, preview, and the xvforms & xvlang libraries break our 
 *        conventions in that they call private kforms routines. those 
 *        private routines have their prototypes after this point.
 */

/*
 * begin.c  
 */
kform    *kvf_begin_form    PROTO((void));
kcontrol *kvf_begin_control PROTO((kform *, ksubform *, kguide *, int));

/*
 * creation.c
 */
kselection *kvf_create_new_selection      PROTO((kcontrol *, char *));
kselection *kvf_create_new_toggle_member  PROTO((kselection *, char *));
int           kvf_link_extension    PROTO((kform_struct *, kform_struct *));
kform_struct **kvf_get_extensions  PROTO((kform *, int *));

/*
 * command.c
 */
char *kvf_construct_partial_cmd PROTO((kform *, ksubform *, char *, int));


/* 
 * destroy.c 
 */
void kvf_free_line_info_strings PROTO((Line_Info *));

/*
 * db_util.c
 */
char **kvf_read_database PROTO((kfile *, int *, int *, int **,
                                int **, char ***, int *));
/*
 *  Form Tree Creation Routines (createtree.c)
 */
kform *kvf_build_form PROTO((char **, int, kfunc_void, kaddr,
                             int *, int *, char **));



/* 
 * deparser.c 
 */
void kvf_deparse_startform_line      PROTO((Line_Info *, char **));
void kvf_deparse_startmaster_line    PROTO((Line_Info *, char **));
void kvf_deparse_startsubmenu_line   PROTO((Line_Info *, char **));
void kvf_deparse_startsubform_line   PROTO((Line_Info *, char **));
void kvf_deparse_startguide_line     PROTO((Line_Info *, char **));
void kvf_deparse_startpane_line      PROTO((Line_Info *, char **));
void kvf_deparse_subformbutton_line  PROTO((Line_Info *, char **));
void kvf_deparse_pseudosubform_line  PROTO((Line_Info *, char **));
void kvf_deparse_master_action_line  PROTO((Line_Info *, char **));
void kvf_deparse_guide_line          PROTO((Line_Info *, char **));
void kvf_deparse_quit_line           PROTO((Line_Info *, char **));
void kvf_deparse_subform_action_line PROTO((Line_Info *, char **));
void kvf_deparse_help_line           PROTO((Line_Info *, char **));
void kvf_deparse_input_line          PROTO((Line_Info *, char **));
void kvf_deparse_output_line         PROTO((Line_Info *, char **));
void kvf_deparse_stdin_line          PROTO((Line_Info *, char **));
void kvf_deparse_stdout_line         PROTO((Line_Info *, char **));
void kvf_deparse_int_line            PROTO((Line_Info *, char **));
void kvf_deparse_float_line          PROTO((Line_Info *, char **));
void kvf_deparse_double_line         PROTO((Line_Info *, char **));
void kvf_deparse_logic_line          PROTO((Line_Info *, char **));
void kvf_deparse_flag_line           PROTO((Line_Info *, char **));
void kvf_deparse_cycle_line          PROTO((Line_Info *, char **));
void kvf_deparse_list_line           PROTO((Line_Info *, char **));
void kvf_deparse_displaylist_line    PROTO((Line_Info *, char **));
void kvf_deparse_string_line         PROTO((Line_Info *, char **));
void kvf_deparse_stringlist_line     PROTO((Line_Info *, char **));
void kvf_deparse_routine_line        PROTO((Line_Info *, char **));
void kvf_deparse_toggle_line         PROTO((Line_Info *, char **));
void kvf_deparse_blank_line          PROTO((Line_Info *, char **));
void kvf_deparse_pane_action_line    PROTO((Line_Info *, char **));
void kvf_deparse_includepane_line    PROTO((Line_Info *, char **));
void kvf_deparse_includesubform_line PROTO((Line_Info *, char **));
void kvf_deparse_mutexcl_line        PROTO((Line_Info *, char **));
void kvf_deparse_mutincl_line        PROTO((Line_Info *, char **));
void kvf_deparse_workspace_line      PROTO((Line_Info *, char **));
void kvf_deparse_libcall_line        PROTO((Line_Info *, char **));
void kvf_deparse_ansinfile_line      PROTO((Line_Info *, char **));
void kvf_deparse_ansoutfile_line     PROTO((Line_Info *, char **));
void kvf_deparse_end_line            PROTO((Line_Info *, char **));
void kvf_gen_deparse                 PROTO((Line_Info *, char **));

/*
 *  form_list.c 
 */
void        kvf_delete_entry PROTO((kaddr));
int         kvf_add_entry    PROTO((kaddr, int, int, kfunc_void, kaddr));
int         kvf_change_entry PROTO((kaddr, int, kfunc_void, kaddr));
kform_list *kvf_get_entry    PROTO((kaddr));

/*
 *  group.c
 */
int  kvf_do_group            PROTO((kselection *, kselection *,
                                    int, int, int, kfunc_void));
/* 
 * kformstruct.c 
 */
void          kvf_link_formstruct                PROTO((kform_struct *));
void          kvf_unlink_formstruct              PROTO((kform_struct *));
kform_struct *kvf_create_struct                  PROTO((kaddr, int, int));
kform_struct *kvf_create_struct_from_formname    PROTO((kform *, char *));
kform_struct *kvf_create_struct_from_mastername  PROTO((kform *, char *));
kform_struct *kvf_create_struct_from_subformname PROTO((kform *, char *));
kform_struct *kvf_create_struct_from_guidename   PROTO((ksubform *, char *));
kform_struct *kvf_create_struct_from_panename    PROTO((ksubform *, char *));
kform_struct *kvf_create_struct_from_selname     PROTO((kselection *, char *));
kform_struct **kvf_get_selection_kformstructs   PROTO((kcontrol *, int, int *));
kform_struct *kvf_get_var_selection_kformstruct   PROTO((kform *, char  *));

/*
 *  manip.c
 */
int  kvf_add_subform          PROTO((kform *, ksubform *));
int  kvf_add_guide_to_subform PROTO((ksubform *, kguide *));
void kvf_add_selection        PROTO((kselection *, kselection *));
int  kvf_delete_subform       PROTO((kform *, ksubform *));
int  kvf_delete_guide         PROTO((kguide *));
int  kvf_delete_selection     PROTO((kselection *));
int  kvf_transfer_selections  PROTO((kcontrol *, kcontrol *));
void kvf_update_backlinks     PROTO((kselection *, kform *, ksubform *,
                                     kguide *, kcontrol *));
/*
 *  parser.c 
 */
void kvf_clear_line_info           PROTO((Line_Info *));
int  kvf_parse_startform_line      PROTO((char *, Line_Info *));
int  kvf_parse_startmaster_line    PROTO((char *, Line_Info *));
int  kvf_parse_startsubmenu_line   PROTO((char *, Line_Info *));
int  kvf_parse_startsubform_line   PROTO((char *, Line_Info *));
int  kvf_parse_startguide_line     PROTO((char *, Line_Info *));
int  kvf_parse_startpane_line      PROTO((char *, Line_Info *));
int  kvf_parse_subformbutton_line  PROTO((char *, Line_Info *));
int  kvf_parse_pseudosubform_line  PROTO((char *, Line_Info *));
int  kvf_parse_master_action_line  PROTO((char *, Line_Info *));
int  kvf_parse_guide_line          PROTO((char *, Line_Info *));
int  kvf_parse_quit_line           PROTO((char *, Line_Info *));
int  kvf_parse_subform_action_line PROTO((char *, Line_Info *));
int  kvf_parse_help_line           PROTO((char *, Line_Info *));
int  kvf_parse_input_line          PROTO((char *, Line_Info *));
int  kvf_parse_output_line         PROTO((char *, Line_Info *));
int  kvf_parse_stdin_line          PROTO((char *, Line_Info *));
int  kvf_parse_stdout_line         PROTO((char *, Line_Info *));
int  kvf_parse_int_line            PROTO((char *, Line_Info *));
int  kvf_parse_float_line          PROTO((char *, Line_Info *));
int  kvf_parse_double_line         PROTO((char *, Line_Info *));
int  kvf_parse_logic_line          PROTO((char *, Line_Info *));
int  kvf_parse_flag_line           PROTO((char *, Line_Info *));
int  kvf_parse_cycle_line          PROTO((char *, Line_Info *));
int  kvf_parse_list_line           PROTO((char *, Line_Info *));
int  kvf_parse_displaylist_line    PROTO((char *, Line_Info *));
int  kvf_parse_string_line         PROTO((char *, Line_Info *));
int  kvf_parse_stringlist_line     PROTO((char *, Line_Info *));
int  kvf_parse_routine_line        PROTO((char *, Line_Info *));
int  kvf_parse_toggle_line         PROTO((char *, Line_Info *));
int  kvf_parse_blank_line          PROTO((char *, Line_Info *));
int  kvf_parse_pane_action_line    PROTO((char *, Line_Info *));
int  kvf_parse_includepane_line    PROTO((char *, Line_Info *));
int  kvf_parse_includesubform_line PROTO((char *, Line_Info *));
int  kvf_parse_mutexcl_line        PROTO((char *, Line_Info *));
int  kvf_parse_mutincl_line        PROTO((char *, Line_Info *));
int  kvf_parse_workspace_line      PROTO((char *, Line_Info *));
int  kvf_parse_libcall_line        PROTO((char *, Line_Info *));
int  kvf_parse_ansinfile_line      PROTO((char *, Line_Info *));
int  kvf_parse_ansoutfile_line     PROTO((char *, Line_Info *));
int  kvf_parse_end_line            PROTO((char *, Line_Info *));
int  kvf_gen_parse                 PROTO((char *, Line_Info *));

/* 
 * print.c 
 */
int  kvf_print_UIS_file    PROTO((kform *, char *,  int, int));
int  kvf_print_UIS         PROTO((kfile *, kform *, int, int));
void kvf_print_subform     PROTO((kfile *, ksubform *, int, int, int, int));
void kvf_print_pane        PROTO((kfile *, kcontrol *, int, int));

/*
 * search.c 
 */
kselection *kvf_variable_sel_search       PROTO((kform *, char *));
kselection *kvf_search_sel_subform_action PROTO((ksubform *));
kselection *kvf_search_sel_master_action  PROTO((kform *));
kguide     *kvf_search_sel_guide          PROTO((ksubform *));
kselection *kvf_find_specified_selection  PROTO((kselection *, int, int));


/*
 * utilities.c
 */
char *kvf_ascii_typeflag          PROTO((int));
int   kvf_get_line_type           PROTO((char *));
int   kvf_gui_item_exists         PROTO((kselection *, int));
int   kvf_check_for_single_pane   PROTO((kform *, char *));
char *kvf_get_routine_syntax      PROTO((kform *));
int   kvf_gen_parse_kformstruct   PROTO((kform_struct *, Line_Info *));
void  kvf_gen_deparse_kformstruct PROTO((kform_struct *, Line_Info *));
void  kvf_append_toggle_values_to_buffer PROTO((kselection *, char *));
float kvf_calculate_y_position    PROTO((kcontrol *));
void  kvf_set_context             PROTO((int));

kfunc_int kvf_set_expr_handler    PROTO((kfunc_int));
int       kvf_call_expr_handler   PROTO((kform *, char *, int, kaddr, char *));
kfunc_int kvf_get_expr_handler    PROTO((void));


/* 
 * attrib_toggle.c 
 */
kselection *kvf_begin_toggle_member      PROTO((kselection *, int, int));
int        kvf_switch_toggle_value       PROTO((kselection *));

#endif /* _kforms_kformsP_h_ */
/* Do not add after this line */
