.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DvSetRadiosityUpdateType 3D  "Dore"
.SH NAME
DvSetRadiosityUpdateType \- Set the radiosity update type of a view
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
void DvSetRadiosityUpdateType(view, updatetype)
DtObject view ;
DtRadiosityUpdateType updatetype ;
.sp
.in -.5i
FORTRAN:
.in +.5i
CALL DVSRDU(VIEW,UPDTYP)
INTEGER*4 VIEW
INTEGER*4 UPDTYP
.in -.5i
.fi
.SH DESCRIPTION
.IX DVSRDU
.IX DvSetRadiosityUpdateType
.I DvSetRadiosityUpdateType
sets the radiosity update type value for a view on subsequent updates.
The parameter \f2updatetype\fP 
determines how to process primitive objects for which \f2DoRadiositySwitch\fP
is \f2DcOn <DCON>\fP.
Possible radiosity update type values are:
.PP
.IP "\f2DcRadiosityNone\fP <\f2DCRDNO\fP>"
Ignore radiosity. This is how radiosity calculations and display are turned
off; this causes all radiosity attributes to be ignored.
.IP "\f2DcRadiosityComputeDisp\fP <\f2DCRDCD\fP>"
Compute radiosity and display the results.
.IP "\f2DcRadiosityDisp\fP <\f2DCRDD\fP>"
Display previously computed radiosity. This should be used when only the camera
attributes have changed since the last time radiosity was computed.
.SH ERRORS
.I DvSetRadiosityUpdateType
will fail if the view handle is invalid.
.TP 15
[WARNING - invalid view handle]
.SH DEFAULTS
The default \f2updatetype\fP is \f2DcRadiosityNone\fP <\f2f2DCRDNO\fP>.
.SH "SEE ALSO"
.na
.nh
DvInqRadiosityUpdateType(3D),
DoRadiositySwitch(3D),
DoIntermediateDispType(3D),
DvSetFormFactorCompType(3D),
DvSetRadiosityConvergence(3D)
.ad
.hy
