.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoTranslate 3D  "Dore"
.SH NAME
DoTranslate \- Create a translation geometric transformation object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoTranslate(x, y, z)
DtReal x, y, z;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOXLT(X, Y, Z)
REAL*8 X, Y, Z
.in -.5i
.fi
.SH DESCRIPTION
.IX DOXLT
.IX DoTranslate
.I DoTranslate
creates a translation geometric transformation object that modifies
the current transformation matrix.  The translation can be 
in the X-, Y-, and
Z-directions relative to the current origin.
The parameters \f2x\fP, \f2y\fP, and \f2z\fP are three floating point values for
the X-, Y-, and Z-displacements.
.SH "SEE ALSO"
.na
.nh
DoLookAtFrom(3D), DoRotate(3D), DoScale(3D),
DoShear(3D), DoTransformMatrix(3D)
.ad
.hy
