.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoTextSpace 3D  "Dore"
.SH NAME
DoTextSpace \- Create a text space primitive attribute object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoTextSpace(textspace)
DtReal textspace;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOTSP(TXSPAC)
REAL*8 TXSPAC
.in -.5i
.fi
.SH DESCRIPTION
.IX DOTSP
.IX DoTextSpace
.I DoTextSpace
creates a text space primitive attribute object.  The parameter
\f2textspace\fP specifies the amount of additional space to
insert between adjacent characters in subsequently
executed text primitive objects.
.PP
The \f2textspace\fP parameter is specified as a scaling factor
(fraction) of the font-nominal character width to be used as
additional spacing.  The specified spacing can be positive, negative
or 0.  
When this scaling factor is 0 (the default), 
the spacing built in by the font designer is
used.
A negative value for spacing causes characters to
overlap each other by the specified amount.
.SH DEFAULTS
The default \f2DoTextSpace\fP is 0.0.
.SH "SEE ALSO"
.na
.nh
DoAnnoText(3D), DoText(3D), DoTextAlign(3D), DoTextExpFactor(3D), 
DoTextFont(3D), DoTextHeight(3D), DoTextPath(3D), DoTextPrecision(3D),
DoTextUpVector(3D)
.ad
.hy
