.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoPickSwitch 3D  "Dore"
.SH NAME
DoPickSwitch \- Create a primitive attribute object for enabling or disabling picking 
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoPickSwitch(switchvalue)
DtSwitch switchvalue;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOPS(SWVAL)
INTEGER*4 SWVAL
.in -.5i
.fi
.SH DESCRIPTION
.IX DOPS
.IX DoPickSwitch
.I DoPickSwitch
creates a pickability primitive attribute object.
Executing this object sets the current value of the pickability switch to
\f2switchvalue\fP.  Possible values for \f2switchvalue\fP are:
.IP "\f2DcOn\fP <\f2DCON\fP>"
Subsequent objects are eligible to be picked.
.IP "\f2DcOff\fP <\f2DCOFF\fP>"
Subsequent objects will be ignored for picking.
.PP
\f2DoPickSwitch\fP provides direct control of the pickability
primitive attribute at the lowest level.  For higher level control, see
\f2DoNameSet\fP and \f2DoFilter\fP.
.SH DEFAULTS
The default \f2DoPickSwitch\fP is \f2DcOff\fP <\f2DCOFF\fP>.
.SH "SEE ALSO"
DdPickObjs(3D), DoNameSet(3D), DoFilter(3D)
